/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EJBTimerServiceWrapper;
import com.sun.enterprise.container.common.spi.EjbNamingReferenceManager;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.util.Utility;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.ORB;

@Service
public class EjbNamingReferenceManagerImpl
implements EjbNamingReferenceManager {
    @Inject
    InvocationManager invMgr;
    @Inject
    Provider<GlassFishORBHelper> glassFishORBHelperProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object resolveEjbReference(EjbReferenceDescriptor ejbRefDesc, Context context) throws NamingException {
        Object jndiObj = null;
        boolean resolved = false;
        if (ejbRefDesc.isLocal()) {
            if (ejbRefDesc.hasLookupName()) {
                jndiObj = context.lookup(ejbRefDesc.getLookupName().toString());
                resolved = true;
            }
        } else if (!ejbRefDesc.hasJndiName() && ejbRefDesc.hasLookupName()) {
            try {
                jndiObj = context.lookup(ejbRefDesc.getLookupName().toString());
            }
            catch (NamingException e) {
                ClassLoader oldLoader = null;
                try {
                    oldLoader = Utility.setContextClassLoader((ClassLoader)ejbRefDesc.getReferringBundleDescriptor().getClassLoader());
                    jndiObj = context.lookup(ejbRefDesc.getLookupName().toString());
                }
                catch (Throwable throwable) {
                    Utility.setContextClassLoader(oldLoader);
                    throw throwable;
                }
                Utility.setContextClassLoader((ClassLoader)oldLoader);
            }
            resolved = true;
        } else if (ejbRefDesc.hasJndiName() && ejbRefDesc.getJndiName().isJavaApp() && !ejbRefDesc.getJndiName().hasPrefix("java:app/env/")) {
            SimpleJndiName remoteJndiName = ejbRefDesc.getJndiName();
            String appName = (String)context.lookup("java:app/AppName");
            String globalLookup = remoteJndiName.changePrefix("java:global/" + appName + "/").toString();
            jndiObj = context.lookup(globalLookup);
            resolved = true;
        } else {
            SimpleJndiName remoteJndiName = EJBUtils.getRemoteEjbJndiName(ejbRefDesc);
            ClassLoader origClassLoader = Utility.getClassLoader();
            boolean setCL = false;
            try {
                try {
                    String refInterface = ejbRefDesc.isEJB30ClientView() ? ejbRefDesc.getEjbInterface() : ejbRefDesc.getHomeClassName();
                    origClassLoader.loadClass(refInterface);
                }
                catch (ClassNotFoundException e) {
                    ClassLoader referringBundleClassLoader = ejbRefDesc.getReferringBundleDescriptor().getClassLoader();
                    Utility.setContextClassLoader((ClassLoader)referringBundleClassLoader);
                    setCL = true;
                }
                if (remoteJndiName.hasCorbaPrefix()) {
                    GlassFishORBHelper orbHelper = (GlassFishORBHelper)this.glassFishORBHelperProvider.get();
                    ORB orb = orbHelper.getORB();
                    jndiObj = orb.string_to_object(remoteJndiName.toString());
                } else {
                    jndiObj = context.lookup(remoteJndiName.toString());
                }
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Exception resolving Ejb for '" + ejbRefDesc + "' .  Actual (possibly internal) Remote JNDI name used for lookup is '" + remoteJndiName + "'");
                ne.initCause(e);
                throw ne;
            }
            finally {
                if (setCL) {
                    Utility.setContextClassLoader((ClassLoader)origClassLoader);
                }
            }
        }
        return resolved ? jndiObj : EJBUtils.resolveEjbRefObject(ejbRefDesc, jndiObj);
    }

    public boolean isEjbReferenceCacheable(EjbReferenceDescriptor ejbRefDesc) {
        return !ejbRefDesc.isEJB30ClientView() && ejbRefDesc.getEjbDescriptor() != null;
    }

    public Object getEJBContextObject(String contextType) {
        ComponentInvocation currentInv = this.invMgr.getCurrentInvocation();
        if (currentInv == null) {
            throw new IllegalStateException("no current invocation");
        }
        if (currentInv.getInvocationType() != ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
            throw new IllegalStateException("Illegal invocation type for EJB Context : " + currentInv.getInvocationType());
        }
        EjbInvocation ejbInv = (EjbInvocation)currentInv;
        Object returnObject = ejbInv.context;
        if (contextType.equals("jakarta.ejb.TimerService")) {
            if (EJBTimerService.getEJBTimerService() == null) {
                throw new IllegalStateException("EJB Timer Service not available");
            }
            returnObject = new EJBTimerServiceWrapper(EJBTimerService.getEJBTimerService(), (EJBContextImpl)ejbInv.context);
        }
        return returnObject;
    }
}

