/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.tracing;

import java.io.PrintStream;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public final class GlassFishLoggingTracer {
    private static final String JVM_OPT_LOGGING_TRACING_ENABLED = "org.glassfish.main.jul.tracing.enabled";
    private static final PrintStream OUT = System.out;
    private static final PrintStream ERR = System.err;
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static volatile boolean tracingEnabled = Boolean.getBoolean("org.glassfish.main.jul.tracing.enabled");

    private GlassFishLoggingTracer() {
    }

    public static void setTracingEnabled(boolean tracingEnabled) {
        GlassFishLoggingTracer.tracingEnabled = tracingEnabled;
    }

    public static boolean isTracingEnabled() {
        return tracingEnabled;
    }

    public static void trace(Class<?> source, Supplier<String> message) {
        if (tracingEnabled) {
            LOCK.lock();
            try {
                GlassFishLoggingTracer.trace(source, message.get());
            }
            finally {
                LOCK.unlock();
            }
        }
    }

    public static void trace(Class<?> source, String message) {
        if (tracingEnabled) {
            LOCK.lock();
            try {
                OUT.println(source.getCanonicalName() + ": " + message);
                OUT.flush();
            }
            finally {
                LOCK.unlock();
            }
        }
    }

    public static void stacktrace(Class<?> source, String exceptionMessage) {
        if (tracingEnabled) {
            LOCK.lock();
            try {
                OUT.println(source.getCanonicalName() + ": Don't panic, following stacktrace is only to see what invoked this!");
                new RuntimeException(exceptionMessage).printStackTrace(OUT);
                OUT.flush();
            }
            finally {
                LOCK.unlock();
            }
        }
    }

    public static void error(Class<?> source, String message) {
        LOCK.lock();
        try {
            ERR.println(source.getCanonicalName() + ": " + message);
            ERR.flush();
        }
        finally {
            LOCK.unlock();
        }
    }

    public static void error(Class<?> source, String message, Throwable cause) {
        LOCK.lock();
        try {
            ERR.println(source.getCanonicalName() + ": " + message);
            cause.printStackTrace(ERR);
            ERR.flush();
        }
        finally {
            LOCK.unlock();
        }
    }
}

