/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;

public class StoredProcedureDefinition
extends DatabaseObjectDefinition {
    protected List<FieldDefinition> variables;
    protected List<String> characteristics;
    protected List<String> statements = new LinkedList<String>();
    protected List<FieldDefinition> arguments;
    protected List<Integer> argumentTypes;
    protected static final Integer IN = 1;
    protected static final Integer OUT = 2;
    protected static final Integer INOUT = 3;

    public StoredProcedureDefinition() {
        this.variables = new LinkedList<FieldDefinition>();
        this.characteristics = new LinkedList<String>();
        this.arguments = new LinkedList<FieldDefinition>();
        this.argumentTypes = new LinkedList<Integer>();
    }

    public void addArgument(String argumentName, Class<?> type) {
        this.addArgument(new FieldDefinition(argumentName, type));
    }

    public void addArgument(String argumentName, Class<?> type, int size) {
        this.addArgument(new FieldDefinition(argumentName, type, size));
    }

    public void addArgument(String argumentName, String typeName) {
        this.addArgument(new FieldDefinition(argumentName, typeName));
    }

    public void addArgument(FieldDefinition argument) {
        this.getArguments().add(argument);
        this.getArgumentTypes().add(IN);
    }

    public void addInOutputArgument(String argumentName, Class<?> type) {
        this.addInOutputArgument(new FieldDefinition(argumentName, type));
    }

    public void addInOutputArgument(FieldDefinition argument) {
        this.getArguments().add(argument);
        this.getArgumentTypes().add(INOUT);
    }

    public void addOutputArgument(String argumentName, Class<?> type) {
        this.addOutputArgument(new FieldDefinition(argumentName, type));
    }

    public void addOutputArgument(String argumentName, Class<?> type, int size) {
        this.addOutputArgument(new FieldDefinition(argumentName, type, size));
    }

    public void addOutputArgument(String argumentName, String typeName) {
        this.addOutputArgument(new FieldDefinition(argumentName, typeName));
    }

    public void addOutputArgument(FieldDefinition argument) {
        this.getArguments().add(argument);
        this.getArgumentTypes().add(OUT);
    }

    public void addStatement(String statement) {
        this.getStatements().add(statement);
    }

    public void addCharacteristic(String characteristic) {
        this.getCharacteristics().add(characteristic);
    }

    public void addVariable(String variableName, String typeName) {
        this.addVariable(new FieldDefinition(variableName, typeName));
    }

    public void addVariable(FieldDefinition variable) {
        this.getVariables().add(variable);
    }

    @Override
    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            DatabasePlatform platform = session.getPlatform();
            writer.write(this.getCreationHeader() + this.getFullName());
            if (this.getArguments().size() > this.getFirstArgumentIndex() || platform.requiresProcedureBrackets()) {
                writer.write(" (");
            }
            writer.write("\n");
            for (int i = this.getFirstArgumentIndex(); i < this.getArguments().size(); ++i) {
                writer.write("\t");
                FieldDefinition argument = this.getArguments().get(i);
                Integer argumentType = this.getArgumentTypes().get(i);
                if (argumentType == IN) {
                    this.printArgument(argument, writer, session);
                } else if (argumentType == OUT) {
                    this.printOutputArgument(argument, writer, session);
                } else if (argumentType == INOUT) {
                    this.printInOutputArgument(argument, writer, session);
                }
                if (i >= this.getArguments().size() - 1) continue;
                writer.write(",\n");
            }
            if (this.getArguments().size() > this.getFirstArgumentIndex() || platform.requiresProcedureBrackets()) {
                writer.write(")");
            }
            this.printReturn(writer, session);
            for (String characteristic : this.getCharacteristics()) {
                writer.write(characteristic);
                writer.write("\n");
            }
            writer.write(platform.getProcedureAsString());
            writer.write("\n");
            writer.write(platform.getProcedureOptionList());
            writer.write("\n");
            if (platform.shouldPrintStoredProcedureVariablesAfterBeginString()) {
                writer.write(platform.getProcedureBeginString());
                writer.write("\n");
            }
            if (!this.getVariables().isEmpty()) {
                writer.write("DECLARE\n");
            }
            for (FieldDefinition field : this.getVariables()) {
                writer.write("\t");
                writer.write(field.getName());
                writer.write(" ");
                writer.write(field.getTypeName());
                writer.write(platform.getBatchDelimiterString());
                writer.write("\n");
            }
            if (!platform.shouldPrintStoredProcedureVariablesAfterBeginString()) {
                writer.write(platform.getProcedureBeginString());
                writer.write("\n");
            }
            for (String statement : this.getStatements()) {
                writer.write(statement);
                writer.write(platform.getBatchDelimiterString());
                writer.write("\n");
            }
            writer.write(platform.getProcedureEndString());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write(this.getDeletionHeader() + this.getFullName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public List<FieldDefinition> getArguments() {
        return this.arguments;
    }

    public String getCreationHeader() {
        return "CREATE PROCEDURE ";
    }

    public String getDeletionHeader() {
        return "DROP PROCEDURE ";
    }

    public int getFirstArgumentIndex() {
        return 0;
    }

    public List<Integer> getArgumentTypes() {
        return this.argumentTypes;
    }

    public List<String> getStatements() {
        return this.statements;
    }

    public List<String> getCharacteristics() {
        return this.characteristics;
    }

    public List<FieldDefinition> getVariables() {
        return this.variables;
    }

    protected void printArgument(FieldDefinition argument, Writer writer, AbstractSession session) throws IOException {
        DatabasePlatform platform = session.getPlatform();
        FieldTypeDefinition fieldType = StoredProcedureDefinition.getFieldTypeDefinition(session, argument.type, argument.typeName);
        writer.write(platform.getProcedureArgumentString());
        if (platform.shouldPrintInputTokenAtStart()) {
            writer.write(" ");
            writer.write(platform.getInputProcedureToken());
            writer.write(" ");
        }
        writer.write(argument.name);
        writer.write(" ");
        writer.write(fieldType.getName());
        if (fieldType.isSizeAllowed() && platform.allowsSizeInProcedureArguments() && (argument.size != 0 || fieldType.isSizeRequired())) {
            writer.write("(");
            if (argument.size == 0) {
                writer.write(Integer.toString(fieldType.getDefaultSize()));
            } else {
                writer.write(Integer.toString(argument.size));
            }
            if (argument.subSize != 0) {
                writer.write(",");
                writer.write(Integer.toString(argument.subSize));
            } else if (fieldType.getDefaultSubSize() != 0) {
                writer.write(",");
                writer.write(Integer.toString(fieldType.getDefaultSubSize()));
            }
            writer.write(")");
        }
    }

    protected void printInOutputArgument(FieldDefinition argument, Writer writer, AbstractSession session) throws ValidationException {
        try {
            DatabasePlatform platform = session.getPlatform();
            FieldTypeDefinition fieldType = StoredProcedureDefinition.getFieldTypeDefinition(session, argument.type, argument.typeName);
            writer.write(platform.getProcedureArgumentString());
            if (platform.shouldPrintOutputTokenAtStart()) {
                writer.write(" ");
                writer.write(platform.getCreationInOutputProcedureToken());
                writer.write(" ");
            }
            writer.write(argument.name);
            if (!platform.shouldPrintOutputTokenAtStart() && platform.shouldPrintOutputTokenBeforeType()) {
                writer.write(" ");
                writer.write(platform.getCreationInOutputProcedureToken());
            }
            writer.write(" ");
            writer.write(fieldType.getName());
            if (fieldType.isSizeAllowed() && platform.allowsSizeInProcedureArguments() && (argument.size != 0 || fieldType.isSizeRequired())) {
                writer.write("(");
                if (argument.size == 0) {
                    writer.write(Integer.toString(fieldType.getDefaultSize()));
                } else {
                    writer.write(Integer.toString(argument.size));
                }
                if (argument.subSize != 0) {
                    writer.write(",");
                    writer.write(Integer.toString(argument.subSize));
                } else if (fieldType.getDefaultSubSize() != 0) {
                    writer.write(",");
                    writer.write(Integer.toString(fieldType.getDefaultSubSize()));
                }
                writer.write(")");
            }
            if (!platform.shouldPrintOutputTokenAtStart() && !platform.shouldPrintOutputTokenBeforeType()) {
                writer.write(" ");
                writer.write(platform.getCreationInOutputProcedureToken());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    protected void printOutputArgument(FieldDefinition argument, Writer writer, AbstractSession session) throws ValidationException {
        try {
            DatabasePlatform platform = session.getPlatform();
            FieldTypeDefinition fieldType = StoredProcedureDefinition.getFieldTypeDefinition(session, argument.type, argument.typeName);
            writer.write(platform.getProcedureArgumentString());
            if (platform.shouldPrintOutputTokenAtStart()) {
                writer.write(" ");
                writer.write(platform.getCreationOutputProcedureToken());
                writer.write(" ");
            }
            writer.write(argument.name);
            if (!platform.shouldPrintOutputTokenAtStart() && platform.shouldPrintOutputTokenBeforeType()) {
                writer.write(" ");
                writer.write(platform.getCreationOutputProcedureToken());
            }
            writer.write(" ");
            writer.write(fieldType.getName());
            if (fieldType.isSizeAllowed() && platform.allowsSizeInProcedureArguments() && (argument.size != 0 || fieldType.isSizeRequired())) {
                writer.write("(");
                if (argument.size == 0) {
                    writer.write(Integer.toString(fieldType.getDefaultSize()));
                } else {
                    writer.write(Integer.toString(argument.size));
                }
                if (argument.subSize != 0) {
                    writer.write(",");
                    writer.write(Integer.toString(argument.subSize));
                } else if (fieldType.getDefaultSubSize() != 0) {
                    writer.write(",");
                    writer.write(Integer.toString(fieldType.getDefaultSubSize()));
                }
                writer.write(")");
            }
            if (!platform.shouldPrintOutputTokenAtStart() && !platform.shouldPrintOutputTokenBeforeType()) {
                writer.write(" ");
                writer.write(platform.getCreationOutputProcedureToken());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    protected void printReturn(Writer writer, AbstractSession session) throws ValidationException {
    }

    public void setArguments(List<FieldDefinition> arguments) {
        this.arguments = arguments;
    }

    public void setStatements(List<String> statements) {
        this.statements = statements;
    }

    public void setVariables(List<FieldDefinition> variables) {
        this.variables = variables;
    }
}

