/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.runnablejar.commandline;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.runnablejar.commandline.Arguments;
import org.glassfish.runnablejar.commandline.Option;
import org.glassfish.runnablejar.commandline.UnknownPropertyException;

public class CommandLineParser {
    private static final Logger logger = Logger.getLogger(CommandLineParser.class.getName());

    public Arguments parse(String[] commandLineArgs) {
        Arguments arguments = new Arguments();
        arguments.setDefaults();
        for (int i = 0; i < commandLineArgs.length; ++i) {
            String arg = commandLineArgs[i];
            if (arg.startsWith("-")) {
                int initialCharsToIgnore = arg.startsWith("--") ? 2 : 1;
                String optionPart = arg.substring(initialCharsToIgnore);
                String[] keyValue = optionPart.split("=", 2);
                String key = keyValue[0];
                try {
                    String value;
                    boolean nextArgIsValue = false;
                    if (keyValue.length == 2) {
                        value = keyValue[1];
                    } else {
                        boolean hasNextArg = i + 1 < commandLineArgs.length;
                        boolean bl = nextArgIsValue = hasNextArg && !commandLineArgs[i + 1].startsWith("-");
                        if (nextArgIsValue) {
                            value = commandLineArgs[i + 1];
                            ++i;
                        } else {
                            value = "true";
                        }
                    }
                    Option option = arguments.setOption(key, value);
                    if (!nextArgIsValue || option == null || option.handlesValue(value)) continue;
                    --i;
                }
                catch (UnknownPropertyException e) {
                    logger.log(Level.WARNING, e, () -> "Unknown argument " + arg);
                }
                continue;
            }
            if (this.isdeployable(arg)) {
                arguments.deployables.add(arg);
                continue;
            }
            arguments.commands.add(arg);
        }
        return arguments;
    }

    private boolean isdeployable(String arg) {
        File file = new File(arg);
        return file.exists();
    }
}

