/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetServerIDResponseControl
extends Control
implements DecodeableControl {
    public static final String GET_SERVER_ID_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.15";
    private static final long serialVersionUID = 5271084342514677677L;
    private final String serverID;

    GetServerIDResponseControl() {
        this.serverID = null;
    }

    public GetServerIDResponseControl(String serverID) {
        super(GET_SERVER_ID_RESPONSE_OID, false, new ASN1OctetString(serverID));
        Validator.ensureNotNull(serverID);
        this.serverID = serverID;
    }

    public GetServerIDResponseControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_SERVER_ID_RESPONSE_MISSING_VALUE.get());
        }
        this.serverID = value.stringValue();
    }

    @Override
    public GetServerIDResponseControl decodeControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        return new GetServerIDResponseControl(oid, isCritical, value);
    }

    public static GetServerIDResponseControl get(LDAPResult result) throws LDAPException {
        Control c = result.getResponseControl(GET_SERVER_ID_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GetServerIDResponseControl) {
            return (GetServerIDResponseControl)c;
        }
        return new GetServerIDResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    public static GetServerIDResponseControl get(SearchResultEntry entry) throws LDAPException {
        Control c = entry.getControl(GET_SERVER_ID_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GetServerIDResponseControl) {
            return (GetServerIDResponseControl)c;
        }
        return new GetServerIDResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    public static GetServerIDResponseControl get(SearchResultReference ref) throws LDAPException {
        Control c = ref.getControl(GET_SERVER_ID_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GetServerIDResponseControl) {
            return (GetServerIDResponseControl)c;
        }
        return new GetServerIDResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    public String getServerID() {
        return this.serverID;
    }

    @Override
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_GET_SERVER_ID_RESPONSE.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("GetServerIDResponseControl(serverID='");
        buffer.append(this.serverID);
        buffer.append("')");
    }
}

