/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.errors;

import com.sun.tdk.signaturetest.errors.ErrorFormatter;
import com.sun.tdk.signaturetest.errors.MessageType;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.plugin.MessageTransformer;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SortedErrorFormatter
extends ErrorFormatter {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(SortedErrorFormatter.class);
    private Map<String, String> testedsuper = new HashMap<String, String>();
    private boolean verbose = false;
    protected List<ErrorFormatter.Message> failedMessages = new ArrayList<ErrorFormatter.Message>();
    protected static final int tabSize = 20;

    public SortedErrorFormatter(PrintWriter out, boolean isv) {
        super(out);
        this.verbose = isv;
    }

    public void tested(ClassDescription tested) {
        if (!this.getTestedsuper().containsKey(tested.getQualifiedName())) {
            SuperInterface[] items;
            if (tested.getSuperClass() != null) {
                this.getTestedsuper().put(tested.getQualifiedName(), tested.getSuperClass().getQualifiedName());
            }
            if ((items = tested.getInterfaces()) != null) {
                for (SuperInterface item : items) {
                    this.getTestedsuper().put(tested.getQualifiedName(), ((MemberDescription)item).getQualifiedName());
                }
            }
        }
    }

    @Override
    public void addError(MessageType kind, String className, MemberType type, String def, String tail, MemberDescription errorObject) {
        ErrorFormatter.Message c = this.createError(kind, className, type, def, tail, errorObject);
        this.failedMessages.add(c);
        if (!kind.isWarning()) {
            ++this.numErrors;
        }
    }

    @Override
    public void printErrors() {
        int exmsgs = this.msgExclude(this.getTestedsuper());
        String nl = System.getProperty("line.separator");
        MessageTransformer t = PluginAPI.BEFORE_MESSAGE_SORT.getMessageTransformer();
        if (t != null) {
            this.failedMessages = t.changeMessageList(this.failedMessages);
        }
        this.sortErrors();
        boolean hasHeader = false;
        int length = this.failedMessages.size();
        MessageType lastType = null;
        this.numErrors = 0;
        for (ErrorFormatter.Message current : this.failedMessages) {
            if (!current.messageType.isWarning()) {
                ++this.numErrors;
            }
            if (current.messageType != lastType) {
                hasHeader = true;
                this.out.println(nl + current.messageType.getLocMessage() + nl + SortedErrorFormatter.space('-', current.messageType.getLocMessage().length()) + nl);
                lastType = current.messageType;
            }
            if (hasHeader) {
                if (current.definition.isEmpty()) {
                    this.out.println(current.className);
                    continue;
                }
                int currentTab = (current.className.length() + 1) / 20;
                if ((current.className.length() + 1) % 20 != 0) {
                    ++currentTab;
                }
                this.out.println(current.className + ":" + SortedErrorFormatter.space(' ', (currentTab *= 20) - current.className.length() - 1) + current.definition);
                if (!this.isVerbose() || current.tail.isEmpty()) continue;
                this.out.println(i18n.getString("SortedErrorFormatter.error.affected", current.tail));
                continue;
            }
            this.out.println(current);
        }
        if (!this.failedMessages.isEmpty()) {
            this.out.println("");
        }
        if (exmsgs > 0) {
            this.out.println(i18n.getString("SortedErrorFormatter.error.dupmesg", Integer.toString(exmsgs)));
        }
    }

    protected void sortErrors() {
        Collections.sort(this.failedMessages, new Comparator<ErrorFormatter.Message>(){

            @Override
            public int compare(ErrorFormatter.Message m1, ErrorFormatter.Message m2) {
                int comp = m1.messageType.compareTo(m2.messageType);
                if (comp == 0) {
                    comp = m1.className.compareTo(m2.className);
                    if (comp == 0 && (comp = m1.definition.compareTo(m2.definition)) == 0) {
                        comp = m1.tail != null && m2.tail != null ? m1.tail.compareTo(m2.tail) : (m1.tail == null ? -1 : 1);
                    }
                    return comp;
                }
                return comp;
            }
        });
    }

    protected static String space(char c, int len) {
        char[] buff = new char[len];
        for (int i = 0; i < len; ++i) {
            buff[i] = c;
        }
        return new String(buff);
    }

    public int msgExclude(Map<String, String> supernames) {
        int k;
        int n;
        ArrayList<ErrorFormatter.Message> v;
        int i;
        int excludedMessages = 0;
        ArrayList<ArrayList<ErrorFormatter.Message>> vv = new ArrayList<ArrayList<ErrorFormatter.Message>>();
        for (i = 0; i < this.failedMessages.size(); ++i) {
            ErrorFormatter.Message msgi = this.failedMessages.get(i);
            v = null;
            for (n = 0; n < vv.size(); ++n) {
                List x = (List)vv.get(n);
                if (!this.msgCompare((ErrorFormatter.Message)x.get(0), msgi)) continue;
                v = (List)vv.get(n);
                break;
            }
            if (v != null) continue;
            for (k = i + 1; k < this.failedMessages.size(); ++k) {
                ErrorFormatter.Message msgk = this.failedMessages.get(k);
                if (!this.msgCompare(msgk, msgi)) continue;
                if (v == null) {
                    v = new ArrayList<ErrorFormatter.Message>();
                    vv.add(v);
                    v.add(msgi);
                }
                v.add(msgk);
            }
        }
        ArrayList exclude = new ArrayList();
        for (n = 0; n < vv.size(); ++n) {
            v = (ArrayList<ErrorFormatter.Message>)vv.get(n);
            for (k = 0; k < v.size(); ++k) {
                boolean flag = true;
                block5: while (flag) {
                    flag = false;
                    ErrorFormatter.Message msgk = (ErrorFormatter.Message)v.get(k);
                    String supk = supernames.get(msgk.className);
                    if (supk == null) continue;
                    for (i = k + 1; i < v.size(); ++i) {
                        ErrorFormatter.Message msgi = (ErrorFormatter.Message)v.get(i);
                        if (!msgi.className.equals(supk)) continue;
                        v.set(k, msgi);
                        v.set(i, msgk);
                        flag = true;
                        continue block5;
                    }
                }
            }
            k = v.size();
            block7: while (--k >= 0) {
                ErrorFormatter.Message msgk = (ErrorFormatter.Message)v.get(k);
                String supk = supernames.get(msgk.className);
                if (supk == null) continue;
                i = k;
                while (--i >= 0) {
                    ErrorFormatter.Message msgi = (ErrorFormatter.Message)v.get(i);
                    if (!msgi.className.equals(supk)) continue;
                    if (!msgi.tail.isEmpty()) {
                        msgi.tail = msgi.tail + ",";
                    }
                    msgi.tail = msgi.tail + msgk.className;
                    if (!msgk.tail.isEmpty()) {
                        msgi.tail = msgi.tail + "," + msgk.tail;
                    }
                    exclude.add(v.get(k));
                    ++excludedMessages;
                    continue block7;
                }
            }
        }
        i = this.failedMessages.size();
        block9: while (--i >= 0) {
            ErrorFormatter.Message msgi = this.failedMessages.get(i);
            for (k = 0; k < exclude.size(); ++k) {
                ErrorFormatter.Message msgk = (ErrorFormatter.Message)exclude.get(k);
                if (msgi != msgk) continue;
                this.failedMessages.remove(i);
                continue block9;
            }
        }
        return excludedMessages;
    }

    protected boolean msgCompare(ErrorFormatter.Message m1, ErrorFormatter.Message m2) {
        return m1.messageType == m2.messageType && m1.definition.equals(m2.definition);
    }

    protected Map<String, String> getTestedsuper() {
        return this.testedsuper;
    }

    protected void setTestedsuper(Map<String, String> testedsuper) {
        this.testedsuper = testedsuper;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

