/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._int.totaldigits.totaldigits_5;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class totalDigits5_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        totalDigits5_ValidateCTTests test = new totalDigits5_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final int[] validValues = {-2147483648, -100000000, -10000000, -1000000, -100000, -10000, 
                               -1000, -100, -10, -1, 0, 2147483647, 100000000, 10000000, 1000000, 
                               100000, 10000, 1000, 100, 10, 1};
    
    JAXBElement<Integer> elemObj;

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Validate001( ) {
        String xmlDocName = "totalDigits-5-1.xml";
        elemObj = (JAXBElement<Integer>)unmarshal(xmlDocName);
        return testValid();
    }

    public Status Validate003( ) {
        elemObj = (JAXBElement<Integer>)(new ObjectFactory()).createNISTSchemaIntTotalDigits5(-10);
        
        return testValid();
    }


}

