/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.event.ViewListener;
import fr.inria.zvtm.glyphs.VText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.Timer;

public class GLViewPanel
extends ViewPanel {
    protected JPanel panel = new JPanel(){

        public void paint(Graphics g) {
            GLViewPanel.this.paint(g);
        }
    };
    Dimension oldSize;
    Timer edtTimer;
    BufferedImage backBuffer;
    BufferedImage backLensBuffer;
    int backBufferW = 0;
    int backBufferH = 0;
    private Graphics2D[] backBufferGraphics = null;
    Graphics2D lensG2D = null;

    public Component getComponent() {
        return this.panel;
    }

    GLViewPanel(Vector cameras, View v, boolean arfome) {
        ActionListener taskPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GLViewPanel.this.panel.repaint();
            }
        };
        this.edtTimer = new Timer(20, taskPerformer);
        this.panel.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if (GLViewPanel.this.panel.isShowing()) {
                    GLViewPanel.this.start();
                } else {
                    GLViewPanel.this.stop();
                }
            }
        });
        this.parent = v;
        this.cams = new Camera[cameras.size()];
        this.evHs = new ViewListener[this.cams.length];
        for (int nbcam = 0; nbcam < cameras.size(); ++nbcam) {
            this.cams[nbcam] = (Camera)cameras.get(nbcam);
        }
        this.visibilityPadding = new int[this.cams.length][4];
        for (int i = 0; i < this.visibilityPadding.length; ++i) {
            Arrays.fill(this.visibilityPadding[i], 0);
        }
        this.panel.setBackground(this.backColor);
        this.panel.addMouseListener(this);
        this.panel.addMouseMotionListener(this);
        this.panel.addMouseWheelListener(this);
        this.panel.addComponentListener(this);
        this.setAutoRequestFocusOnMouseEnter(arfome);
        this.size = this.panel.getSize();
        if (VirtualSpaceManager.debugModeON()) {
            System.out.println("View refresh time set to " + this.getRefreshRate() + "ms");
        }
        this.start();
    }

    private void start() {
        this.backBufferGraphics = null;
        this.oldSize = this.size = this.panel.getSize();
        this.edtTimer.start();
    }

    void stop() {
        this.edtTimer.stop();
    }

    private void updateOffscreenBuffer(boolean resized) {
        int i;
        if (resized) {
            this.backBuffer = null;
            this.backLensBuffer = null;
            if (this.backBufferGraphics != null) {
                for (i = 0; i < this.backBufferGraphics.length; ++i) {
                    this.backBufferGraphics[i].dispose();
                }
                this.backBufferGraphics = null;
            }
            if (this.lens != null) {
                this.lens.resetMagnificationBuffer();
                if (this.lensG2D != null) {
                    this.lensG2D.dispose();
                    this.lensG2D = null;
                }
            }
        }
        if (this.backBuffer == null) {
            this.gconf = this.panel.getGraphicsConfiguration();
            this.backBuffer = this.gconf.createCompatibleImage(this.size.width, this.size.height);
            this.backLensBuffer = this.gconf.createCompatibleImage(this.size.width, this.size.height);
            this.backBufferW = this.backBuffer.getWidth();
            this.backBufferH = this.backBuffer.getHeight();
            if (this.backBufferGraphics != null) {
                for (i = 0; i < this.backBufferGraphics.length; ++i) {
                    this.backBufferGraphics[i].dispose();
                }
                this.backBufferGraphics = null;
            }
        }
        if (this.backBufferGraphics == null) {
            this.backBufferGraphics = new Graphics2D[1];
            for (i = 0; i < this.backBufferGraphics.length; ++i) {
                this.backBufferGraphics[i] = this.backBuffer.createGraphics();
            }
            this.stableRefToBackBufferGraphics = this.backBufferGraphics[0];
        }
        if (this.lens != null) {
            this.lensG2D = this.lens.getMagnificationGraphics();
            this.lensG2D.setFont(VText.getMainFont());
            if (this.antialias) {
                this.lensG2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                this.lensG2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        block33: {
            try {
                this.updateCursorOnly = false;
                this.size = this.panel.getSize();
                boolean backbufferResize = false;
                if (this.size.width != this.oldSize.width || this.size.height != this.oldSize.height) {
                    if (VirtualSpaceManager.debugModeON()) {
                        System.out.println("Resizing JPanel: (" + this.oldSize.width + "x" + this.oldSize.height + ") -> (" + this.size.width + "x" + this.size.height + ")");
                    }
                    this.oldSize = this.size;
                    this.updateAntialias = true;
                    this.updateFont = true;
                    backbufferResize = true;
                }
                boolean drawLens = this.lens != null;
                this.updateOffscreenBuffer(backbufferResize);
                this.standardStroke = this.stableRefToBackBufferGraphics.getStroke();
                this.standardTransform = this.stableRefToBackBufferGraphics.getTransform();
                if (drawLens) {
                    this.lensG2D.setPaintMode();
                    this.lensG2D.setBackground(this.backColor);
                    this.lensG2D.clearRect(0, 0, this.lens.mbw, this.lens.mbh);
                }
                if (this.updateFont) {
                    this.stableRefToBackBufferGraphics.setFont(VText.getMainFont());
                    if (drawLens) {
                        for (int i = 0; i < this.backBufferGraphics.length; ++i) {
                            this.backBufferGraphics[i].setFont(VText.getMainFont());
                        }
                        if (this.lensG2D != null) {
                            this.lensG2D.setFont(VText.getMainFont());
                        }
                    }
                    this.updateFont = false;
                }
                if (this.updateAntialias) {
                    Object hint = this.antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
                    this.stableRefToBackBufferGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
                    if (drawLens) {
                        for (int i = 0; i < this.backBufferGraphics.length; ++i) {
                            this.backBufferGraphics[i].setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
                        }
                        if (this.lensG2D != null) {
                            this.lensG2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
                        }
                    }
                    this.updateAntialias = false;
                }
                if (this.notBlank) {
                    block32: {
                        block31: {
                            this.stableRefToBackBufferGraphics.setPaintMode();
                            this.stableRefToBackBufferGraphics.setBackground(this.backColor);
                            this.stableRefToBackBufferGraphics.clearRect(0, 0, this.panel.getWidth(), this.panel.getHeight());
                            this.backgroundHook();
                            try {
                                for (int nbcam = 0; nbcam < this.cams.length; ++nbcam) {
                                    Camera camera = this.cams[nbcam];
                                    if (camera == null || !camera.enabled || !camera.eager && !camera.shouldRepaint()) continue;
                                    this.camIndex = this.cams[nbcam].getIndex();
                                    this.drawnGlyphs = this.cams[nbcam].parentSpace.getDrawnGlyphs(this.camIndex);
                                    this.drawnGlyphs.removeAllElements();
                                    double uncoef = (this.cams[nbcam].focal + this.cams[nbcam].altitude) / this.cams[nbcam].focal;
                                    double viewW = this.size.width;
                                    double viewH = this.size.height;
                                    double viewWC = this.cams[nbcam].vx - (viewW / 2.0 - (double)this.visibilityPadding[nbcam][0]) * uncoef;
                                    double viewNC = this.cams[nbcam].vy + (viewH / 2.0 - (double)this.visibilityPadding[nbcam][1]) * uncoef;
                                    double viewEC = this.cams[nbcam].vx + (viewW / 2.0 - (double)this.visibilityPadding[nbcam][2]) * uncoef;
                                    double viewSC = this.cams[nbcam].vy - (viewH / 2.0 - (double)this.visibilityPadding[nbcam][3]) * uncoef;
                                    double lviewWC = 0.0;
                                    double lviewNC = 0.0;
                                    double lviewEC = 0.0;
                                    double lviewSC = 0.0;
                                    double lensVx = 0.0;
                                    double lensVy = 0.0;
                                    if (drawLens) {
                                        lviewWC = this.cams[nbcam].vx + (double)(this.lens.lx - this.lens.lensWidth / 2) * uncoef;
                                        lviewNC = this.cams[nbcam].vy + (double)(-this.lens.ly + this.lens.lensHeight / 2) * uncoef;
                                        lviewEC = this.cams[nbcam].vx + (double)(this.lens.lx + this.lens.lensWidth / 2) * uncoef;
                                        lviewSC = this.cams[nbcam].vy + (double)(-this.lens.ly - this.lens.lensHeight / 2) * uncoef;
                                        lensVx = (lviewWC + lviewEC) / 2.0;
                                        lensVy = (lviewSC + lviewNC) / 2.0;
                                    }
                                    this.gll = this.cams[nbcam].parentSpace.getDrawingList();
                                    for (int i = 0; i < this.gll.length; ++i) {
                                        if (!this.gll[i].visibleInViewport(viewWC, viewNC, viewEC, viewSC, camera)) continue;
                                        this.gll[i].project(camera, this.size);
                                        if (this.gll[i].isVisible()) {
                                            this.gll[i].draw(this.backBufferGraphics[0], this.size.width, this.size.height, camera.getIndex(), this.standardStroke, this.standardTransform, 0, 0);
                                        }
                                        camera.parentSpace.drewGlyph(this.gll[i], this.camIndex);
                                    }
                                    if (drawLens) {
                                        double sub = 0.2;
                                        lviewWC = (long)(camera.vx + ((double)this.lens.lx - (double)this.lens.getRadius() * sub) * uncoef);
                                        lviewNC = (long)(camera.vy + ((double)(-this.lens.ly) + (double)this.lens.getRadius() * sub) * uncoef);
                                        lviewEC = (long)(camera.vx + ((double)this.lens.lx + (double)this.lens.getRadius() * sub) * uncoef);
                                        lviewSC = (long)(camera.vy + ((double)(-this.lens.ly) - (double)this.lens.getRadius() * sub) * uncoef);
                                        lensVx = (lviewWC + lviewEC) / 2.0;
                                        lensVy = (lviewSC + lviewNC) / 2.0;
                                        this.gll = this.cams[nbcam].parentSpace.getDrawingList();
                                        for (int i = 0; i < this.gll.length; ++i) {
                                            if (!this.gll[i].visibleInViewport(lviewWC, lviewNC, lviewEC, lviewSC, camera)) continue;
                                            this.gll[i].projectForLens(camera, this.lens.mbw, this.lens.mbh, this.lens.getMaximumMagnification(), lensVx, lensVy);
                                            if (!this.gll[i].isVisibleThroughLens()) continue;
                                            this.gll[i].drawForLens(this.lensG2D, this.lens.mbw, this.lens.mbh, camera.getIndex(), this.standardStroke, this.standardTransform, 0, 0);
                                        }
                                    }
                                    this.gll = null;
                                }
                            }
                            catch (NullPointerException ex) {
                                if (!VirtualSpaceManager.debugModeON()) break block31;
                                System.err.println("GLViewPanel.run.paint " + ex);
                            }
                        }
                        this.foregroundHook();
                        this.drawBackBuffer(g);
                        if (drawLens) {
                            this.drawLens(g);
                        }
                        if (this.cursor_inside) {
                            try {
                                this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                                if (this.parent.mouse.isSensitive()) {
                                    this.parent.mouse.getPicker().computePickedGlyphList(this.evHs[this.activeLayer], this.cams[this.activeLayer], this);
                                }
                            }
                            catch (NullPointerException ex) {
                                if (!VirtualSpaceManager.debugModeON()) break block32;
                                System.err.println("viewpanel.run.drawdrag " + ex);
                            }
                        }
                    }
                    GLViewPanel gLViewPanel = this;
                    synchronized (gLViewPanel) {
                        this.lastButOneRepaint = this.lastRepaint;
                        this.lastRepaint = System.currentTimeMillis();
                        this.delay = this.lastRepaint - this.lastButOneRepaint;
                        break block33;
                    }
                }
                this.stableRefToBackBufferGraphics.setPaintMode();
                this.stableRefToBackBufferGraphics.setColor(this.blankColor);
                this.stableRefToBackBufferGraphics.fillRect(0, 0, this.panel.getWidth(), this.panel.getHeight());
                this.portalsHook();
            }
            catch (NullPointerException ex0) {
                if (!VirtualSpaceManager.debugModeON()) break block33;
                ex0.printStackTrace();
            }
        }
        if (this.repaintListener != null) {
            this.repaintListener.viewRepainted(this.parent);
        }
    }

    private void drawBackBuffer(Graphics g) {
        g.drawImage(this.backBuffer, 0, 0, null);
    }

    private void copyLensMagBitmap() {
        Graphics2D lg = this.backLensBuffer.createGraphics();
        int x1 = this.lens.lx + this.lens.w / 2 - this.lens.getRadius();
        int y1 = this.lens.ly + this.lens.h / 2 - this.lens.getRadius();
        int x2 = this.lens.lx + this.lens.w / 2 + this.lens.getRadius();
        int y2 = this.lens.ly + this.lens.h / 2 + this.lens.getRadius();
        lg.drawImage(this.backBuffer, x1, y1, x2, y2, x1, y1, x2, y2, null);
        lg.dispose();
    }

    private void drawLens(Graphics g) {
        this.copyLensMagBitmap();
        this.lens.transform(this.backLensBuffer);
        int x1 = this.lens.lx + this.lens.w / 2 - this.lens.getRadius();
        int y1 = this.lens.ly + this.lens.h / 2 - this.lens.getRadius();
        int x2 = this.lens.lx + this.lens.w / 2 + this.lens.getRadius();
        int y2 = this.lens.ly + this.lens.h / 2 + this.lens.getRadius();
        g.drawImage(this.backLensBuffer, x1, y1, x2, y2, x1, y1, x2, y2, null);
    }

    public void setRefreshRate(int rr) {
        if (rr > 0) {
            this.edtTimer.setDelay(rr);
        }
    }

    public int getRefreshRate() {
        return this.edtTimer.getDelay();
    }

    public BufferedImage getImage() {
        return null;
    }
}

