/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.VCircle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCircle<T>
extends VCircle {
    Paint gp;
    Paint highlightPaint = null;
    volatile boolean highlighted = false;
    AffineTransform at;

    public PCircle(Paint gp) {
        this(0.0, 0.0, 0, 10.0, gp);
    }

    public PCircle(double x, double y, int z, double d, Paint p) {
        this(x, y, z, d, p, Color.BLACK);
    }

    public PCircle(double x, double y, int z, double d, Paint p, Color bc) {
        super(x, y, z, d, Color.WHITE, bc);
        this.gp = p;
    }

    public void setPaint(Paint p) {
        this.gp = p;
    }

    public Paint getPaint() {
        return this.gp;
    }

    public void setCursorInsidePaint(Paint p) {
        this.highlightPaint = p;
    }

    @Override
    public void highlight(boolean h, Color unused) {
        this.highlighted = h;
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].cr > 1 && this.pc[i].cr > 1) {
            this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx - this.pc[i].cr / 2, dy + this.pc[i].cy - this.pc[i].cr / 2);
            this.at.concatenate(AffineTransform.getScaleInstance(this.coef, this.coef));
            g.setTransform(this.at);
            if (this.isFilled()) {
                g.setPaint(this.highlighted && this.highlightPaint != null ? this.highlightPaint : this.gp);
                g.fillOval(0, 0, (int)Math.round(this.size), (int)Math.round(this.size));
            }
            if (this.isBorderDrawn()) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawOval(0, 0, (int)Math.round(this.size), (int)Math.round(this.size));
                    g.setStroke(stdS);
                } else {
                    g.drawOval(0, 0, (int)Math.round(this.size), (int)Math.round(this.size));
                }
            }
            g.setTransform(stdT);
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].lcr > 1 && this.pc[i].lcr > 1) {
            this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx - this.pc[i].lcr / 2, dy + this.pc[i].lcy - this.pc[i].lcr / 2);
            this.at.concatenate(AffineTransform.getScaleInstance(this.coef, this.coef));
            g.setTransform(this.at);
            if (this.isFilled()) {
                g.setPaint(this.highlighted && this.highlightPaint != null ? this.highlightPaint : this.gp);
                g.fillOval(0, 0, (int)Math.round(this.size), (int)Math.round(this.size));
            }
            if (this.isBorderDrawn()) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawOval(0, 0, (int)Math.round(this.size), (int)Math.round(this.size));
                    g.setStroke(stdS);
                } else {
                    g.drawOval(0, 0, (int)Math.round(this.size), (int)Math.round(this.size));
                }
            }
            g.setTransform(stdT);
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    @Override
    public Object clone() {
        PCircle<T> res = new PCircle<T>(this.vx, this.vy, 0, this.size, this.gp, this.getBorderColor());
        res.cursorInsideColor = this.cursorInsideColor;
        return res;
    }
}

