/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.launchconfiguration.job;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.efm.execution.core.SymbexPreferenceUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class SewJob
extends Job {
    private IWorkbenchWindow fWindow;
    protected String fFileParameterLocation;
    protected IConsoleView fConsoleView;
    private ProcessBuilder avmProcessBuilder;
    private Process avmProcess;
    private IResource fResource;
    static Map<IResource, MessageConsole> fTableOfConsole = new HashMap<IResource, MessageConsole>();
    protected MessageConsole mc;
    protected MessageConsoleStream mcs;
    String SEW_EXE = SymbexPreferenceUtil.strDiversityAvmExecLocation();

    public SewJob(IWorkbenchWindow window, String name, IFile sewFile, IResource resource) {
        super(name);
        this.fWindow = window;
        this.fFileParameterLocation = sewFile.getLocation().toOSString();
        this.fResource = resource;
        this.createConsole((IResource)sewFile, "Diversity Console");
        try {
            IConsoleView fConsoleView = (IConsoleView)this.fWindow.getActivePage().showView("org.eclipse.ui.console.ConsoleView");
            fConsoleView.display((IConsole)this.mc);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public SewJob(IWorkbenchWindow window, String name, String sewExecutable, IFile sewFile, IResource resource) {
        this(window, name, sewFile, resource);
        this.SEW_EXE = sewExecutable;
    }

    public IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Diversity", -1);
        try {
            block21: {
                if (this.SEW_EXE == null || this.SEW_EXE.isEmpty()) {
                    MessageDialog.openWarning((Shell)this.fWindow.getShell(), (String)"DIVERSITY Symbex (a.k.a AVM) executable", (String)"Unfound exectable!\nSee 'Symbolic Execution Workflow' Preference page.");
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                File execFile = new File(this.SEW_EXE);
                if (!execFile.canExecute()) {
                    String errorMessage = !execFile.exists() ? "doesn't exist!" : (!execFile.isFile() ? "exists but is not a file!" : "is a file but not an executable!");
                    this.mcs.print("error:> The DIVERSITY Symbex (a.k.a AVM) executable << ");
                    this.mcs.print(this.SEW_EXE);
                    this.mcs.print(" >> ");
                    this.mcs.println(errorMessage);
                    MessageDialog.openError((Shell)this.fWindow.getShell(), (String)"DIVERSITY Symbex (a.k.a AVM) executable", (String)("'" + this.SEW_EXE + "'" + "\nThese resource " + errorMessage + "\nSee 'Symbolic Execution Workflow' Preference page."));
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                String[] cmdLine = new String[]{this.SEW_EXE, this.fFileParameterLocation, "--server"};
                File workingDir = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
                this.avmProcessBuilder = new ProcessBuilder(cmdLine);
                this.avmProcessBuilder = this.avmProcessBuilder.redirectErrorStream(true);
                this.avmProcessBuilder.directory(workingDir);
                this.avmProcess = this.avmProcessBuilder.start();
                if (this.avmProcess == null) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                InputStream inputStream = this.avmProcess.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String traceLine = null;
                do {
                    if (bufferedReader.ready()) {
                        traceLine = bufferedReader.readLine();
                        if (traceLine != null) {
                            if (traceLine.indexOf("@cerr:>") >= 0) {
                                traceLine = traceLine.replace("@cerr:>", "");
                                this.mcs.println(traceLine);
                            } else {
                                this.mcs.println(traceLine);
                            }
                            if (!traceLine.contains(":>bye")) {
                                traceLine = null;
                                continue;
                            }
                        }
                        break block21;
                    }
                    try {
                        this.avmProcess.exitValue();
                        break block21;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {}
                } while (!monitor.isCanceled());
                this.avmProcess.destroy();
                this.mcs.println("\n***********************\n* EXECUTION ABORTED ! *\n***********************");
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.avmProcess != null) {
                this.avmProcess.destroy();
            }
            monitor.done();
            this.doRefresh();
        }
        return Status.CANCEL_STATUS;
    }

    private void doRefresh() {
        try {
            if (this.fResource != null) {
                if (this.fResource.getProject().getFolder("OutFiles") == null) {
                    this.fResource.getProject().getFolder("OutFiles").create(true, true, null);
                }
                this.fResource.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            } else {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void createConsole(IResource resource, String prompt) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        this.mc = fTableOfConsole.get(resource);
        if (this.mc == null) {
            StringBuffer bufName = new StringBuffer(prompt);
            bufName.append("#").append(fTableOfConsole.size()).append(":> ").append(resource.getFullPath());
            this.mc = new MessageConsole(bufName.toString(), null);
            fTableOfConsole.put(resource, this.mc);
            conMan.addConsoles(new IConsole[]{this.mc});
            this.mcs = this.mc.newMessageStream();
        } else {
            this.mcs = this.mc.newMessageStream();
            this.mcs.println("=================================================================================");
            this.mcs.println("=================================================================================");
            this.mcs.println("=================================================================================");
        }
    }
}

