/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.core.workflow.coverage;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.efm.execution.core.IWorkflowConfigurationConstants;
import org.eclipse.efm.execution.core.util.PrettyPrintWriter;
import org.eclipse.efm.execution.core.workflow.Director;
import org.eclipse.efm.execution.core.workflow.common.CheckingScopeKind;
import org.eclipse.efm.execution.core.workflow.common.ConsoleLogFormatCustomImpl;
import org.eclipse.efm.execution.core.workflow.common.ManifestCustomImpl;
import org.eclipse.efm.execution.core.workflow.common.TraceSpecificationCustomImpl;
import org.eclipse.efm.execution.core.workflow.coverage.impl.BehaviorCoverageWorkerImpl;

public class BehaviorCoverageWorkerCustomImpl
extends BehaviorCoverageWorkerImpl
implements IWorkflowConfigurationConstants {
    protected BehaviorCoverageWorkerCustomImpl(Director director, String name) {
        this.setDirector(director);
        this.setName(name);
    }

    protected BehaviorCoverageWorkerCustomImpl(Director director, String name, String description) {
        this.setDirector(director);
        this.setName(name);
        this.setDescription(description);
    }

    public static BehaviorCoverageWorkerCustomImpl create(Director director, ILaunchConfiguration configuration) {
        String specification;
        boolean isEnabled;
        BehaviorCoverageWorkerCustomImpl coverageWorker = new BehaviorCoverageWorkerCustomImpl(director, "behavior_coverage");
        try {
            isEnabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_STOP", true);
        }
        catch (CoreException e) {
            e.printStackTrace();
            isEnabled = true;
        }
        coverageWorker.setStopWhenComplete(isEnabled);
        try {
            isEnabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_SLICE", true);
        }
        catch (CoreException e) {
            e.printStackTrace();
            isEnabled = true;
        }
        coverageWorker.setSliceWhenComplete(isEnabled);
        try {
            isEnabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_HEURISTIC", true);
        }
        catch (CoreException e) {
            e.printStackTrace();
            isEnabled = true;
        }
        coverageWorker.setHeuristicEnabled(isEnabled);
        try {
            isEnabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_SEARCH_SCOPE_LOCALLY", false);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
            isEnabled = false;
        }
        coverageWorker.setCheckingScope(isEnabled ? CheckingScopeKind.LOCALLY : CheckingScopeKind.GLOBALLY);
        try {
            isEnabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_SCHEDULER_ORDERED", true);
        }
        catch (CoreException e) {
            e.printStackTrace();
            isEnabled = true;
        }
        coverageWorker.setOrderedTrace(isEnabled);
        try {
            isEnabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_HIT_CONSECUTIVE", true);
        }
        catch (CoreException e) {
            e.printStackTrace();
            isEnabled = true;
        }
        coverageWorker.setHitConsecutive(isEnabled);
        try {
            isEnabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_HIT_FOLDING", true);
        }
        catch (CoreException e) {
            e.printStackTrace();
            isEnabled = true;
        }
        coverageWorker.setHitFolding(isEnabled);
        try {
            isEnabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_HIT_LUCKY", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
            isEnabled = false;
        }
        coverageWorker.setHitLucky(isEnabled);
        try {
            isEnabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_HIT_MAX", true);
        }
        catch (CoreException e) {
            e.printStackTrace();
            isEnabled = true;
        }
        coverageWorker.setHitMax(isEnabled);
        try {
            isEnabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_JUMP_SLICE", true);
        }
        catch (CoreException e) {
            e.printStackTrace();
            isEnabled = true;
        }
        coverageWorker.setJumpSlice(isEnabled);
        coverageWorker.setHeuristicConfiguration(configuration);
        try {
            specification = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_ANALYSIS_ELEMENT_NAME_LIST", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
            specification = null;
        }
        if (specification != null && !specification.isEmpty()) {
            TraceSpecificationCustomImpl trace = TraceSpecificationCustomImpl.create("trace", specification);
            coverageWorker.setTrace(trace);
        }
        ConsoleLogFormatCustomImpl console = ConsoleLogFormatCustomImpl.create(" , coverage: %1% / %2%");
        coverageWorker.setConsole(console);
        return coverageWorker;
    }

    public void setHeuristicConfiguration(ILaunchConfiguration configuration) {
        int intValue;
        try {
            intValue = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_JUMP_HEIGHT", 6);
        }
        catch (CoreException e) {
            e.printStackTrace();
            intValue = 6;
        }
        this.setJumpHeight(intValue);
        try {
            intValue = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_JUMP_TRIALS_LIMIT", -1);
        }
        catch (CoreException e) {
            e.printStackTrace();
            intValue = -1;
        }
        this.setJumpTrialsLimit(intValue);
        try {
            intValue = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_HIT_COUNT", 1);
        }
        catch (CoreException e) {
            e.printStackTrace();
            intValue = 1;
        }
        this.setHitCount(intValue);
        try {
            intValue = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_JUMP_COUNT", 1);
        }
        catch (CoreException e) {
            e.printStackTrace();
            intValue = 1;
        }
        this.setJumpCount(intValue);
    }

    public static BehaviorCoverageWorkerCustomImpl createSecond(Director director, ILaunchConfiguration configuration) {
        String strObjective;
        BehaviorCoverageWorkerCustomImpl coverageWorker = new BehaviorCoverageWorkerCustomImpl(director, "behavior_coverage");
        coverageWorker.setStopWhenComplete(true);
        coverageWorker.setSliceWhenComplete(true);
        coverageWorker.setHeuristicEnabled(true);
        coverageWorker.setCheckingScope(CheckingScopeKind.LOCALLY);
        coverageWorker.setOrderedTrace(true);
        coverageWorker.setHitConsecutive(false);
        coverageWorker.setHitFolding(true);
        coverageWorker.setHitLucky(false);
        coverageWorker.setHitMax(false);
        coverageWorker.setJumpSlice(false);
        coverageWorker.setJumpHeight(5);
        coverageWorker.setJumpTrialsLimit(2);
        coverageWorker.setHitCount(1);
        coverageWorker.setJumpCount(-1);
        try {
            strObjective = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TRACE_EXTENSION_OBJECTIVE", "output#env = [*]\n// See full grammar of [Trace Specification] at the end of this generated file");
        }
        catch (CoreException e) {
            e.printStackTrace();
            strObjective = "output#env = [*]\n// See full grammar of [Trace Specification] at the end of this generated file";
        }
        if (strObjective == null || strObjective.isEmpty()) {
            strObjective = "output#env = [*]\n// See full grammar of [Trace Specification] at the end of this generated file";
        }
        TraceSpecificationCustomImpl trace = TraceSpecificationCustomImpl.create("trace", strObjective);
        coverageWorker.setTrace(trace);
        ConsoleLogFormatCustomImpl console = ConsoleLogFormatCustomImpl.create(" , coverage: %1% / %2%");
        coverageWorker.setConsole(console);
        return coverageWorker;
    }

    public void toWriter(PrettyPrintWriter writer) {
        writer.commentLine(this.getComment());
        writer.appendTab("coverage#behavior");
        String str = this.getName();
        if (str != null) {
            writer.append(' ').append(str);
        }
        if ((str = this.getDescription()) != null) {
            writer.append(" '").append(str).append("'");
        }
        writer.appendEol(" {");
        PrettyPrintWriter writer2 = writer.itab2();
        ManifestCustomImpl manifest = (ManifestCustomImpl)this.getManifest();
        if (manifest != null) {
            manifest.toWriter(writer2);
        }
        writer.appendTab2Eol("property [");
        writer.appendTab3("stop  = ").appendEol(this.isStopWhenComplete());
        writer.appendTab3("slice = ").appendEol(this.isSliceWhenComplete());
        writer.appendTab3("heuristic = ").appendEol(this.isHeuristicEnabled());
        writer.appendTab3("scope = '").append(this.getCheckingScope().getLiteral()).appendEol("'");
        writer.appendTab3("scheduler = ").appendEol(this.isOrderedTrace() ? "'|;|'" : "'|i|'");
        writer.appendTab2Eol("] // end property");
        TraceSpecificationCustomImpl trace = (TraceSpecificationCustomImpl)this.getTrace();
        if (trace != null) {
            trace.toWriter(writer2);
        }
        writer.appendTab2Eol("heuristic [");
        if (this.isOrderedTrace()) {
            writer.appendTab3("hit#consecutive = ").appendEol(this.isHitConsecutive());
        }
        writer.appendTab3("hit#folding = ").appendEol(this.isHitFolding());
        writer.appendTab3("hit#lucky   = ").appendEol(this.isHitLucky());
        writer.appendTab3("hit#max     = ").appendEol(this.isHitMax());
        writer.appendTab3("jump#slice  = ").appendEol(this.isJumpSlice());
        writer.appendTab3("jump#height = ").appendEol(this.getJumpHeight());
        writer.appendTab3("jump#trials#limit = ").appendEol(this.getJumpTrialsLimit());
        writer.appendTab3("hit#count  = ").appendEol(this.getHitCount());
        writer.appendTab3("jump#count = ").appendEol(this.getJumpCount());
        writer.appendTab2Eol("] // end heuristic");
        ConsoleLogFormatCustomImpl console = (ConsoleLogFormatCustomImpl)this.getConsole();
        if (console != null) {
            console.toWriter(writer2);
        }
        writer.appendTabEol("}");
    }
}

