/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.formalml.xtext.scoping;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.efm.ecore.formalml.common.AbstractElement;
import org.eclipse.efm.ecore.formalml.common.NamedElement;
import org.eclipse.efm.ecore.formalml.common.Type;
import org.eclipse.efm.ecore.formalml.common.TypedElement;
import org.eclipse.efm.ecore.formalml.common.VisibilityKind;
import org.eclipse.efm.ecore.formalml.datatype.DataStructuredType;
import org.eclipse.efm.ecore.formalml.datatype.DataSupportedType;
import org.eclipse.efm.ecore.formalml.datatype.DataType;
import org.eclipse.efm.ecore.formalml.datatype.DataTypeReference;
import org.eclipse.efm.ecore.formalml.datatype.DatatypePackage;
import org.eclipse.efm.ecore.formalml.datatype.EnumerationLiteral;
import org.eclipse.efm.ecore.formalml.datatype.EnumerationType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveInstanceKind;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveInstanceType;
import org.eclipse.efm.ecore.formalml.expression.CastExpression;
import org.eclipse.efm.ecore.formalml.expression.Expression;
import org.eclipse.efm.ecore.formalml.expression.ExpressionAsMachine;
import org.eclipse.efm.ecore.formalml.expression.ExpressionPackage;
import org.eclipse.efm.ecore.formalml.expression.InvokeExpression;
import org.eclipse.efm.ecore.formalml.expression.LeftHandSideExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralNullExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralReferenceElement;
import org.eclipse.efm.ecore.formalml.expression.LiteralReferenceExpression;
import org.eclipse.efm.ecore.formalml.expression.QuantifiedLogicalExpression;
import org.eclipse.efm.ecore.formalml.expression.TupleExpression;
import org.eclipse.efm.ecore.formalml.expression.ValueElementSpecification;
import org.eclipse.efm.ecore.formalml.expression.ValueElementSpecificationKind;
import org.eclipse.efm.ecore.formalml.expression.ValueElementSpecificationScheme;
import org.eclipse.efm.ecore.formalml.infrastructure.Behavior;
import org.eclipse.efm.ecore.formalml.infrastructure.Channel;
import org.eclipse.efm.ecore.formalml.infrastructure.ChannelDirection;
import org.eclipse.efm.ecore.formalml.infrastructure.ComPoint;
import org.eclipse.efm.ecore.formalml.infrastructure.ComProtocol;
import org.eclipse.efm.ecore.formalml.infrastructure.InfrastructurePackage;
import org.eclipse.efm.ecore.formalml.infrastructure.InstanceMachine;
import org.eclipse.efm.ecore.formalml.infrastructure.Machine;
import org.eclipse.efm.ecore.formalml.infrastructure.Parameter;
import org.eclipse.efm.ecore.formalml.infrastructure.ParameterSet;
import org.eclipse.efm.ecore.formalml.infrastructure.Port;
import org.eclipse.efm.ecore.formalml.infrastructure.PropertyDefinition;
import org.eclipse.efm.ecore.formalml.infrastructure.Route;
import org.eclipse.efm.ecore.formalml.infrastructure.Routine;
import org.eclipse.efm.ecore.formalml.infrastructure.Signal;
import org.eclipse.efm.ecore.formalml.infrastructure.SlotProperty;
import org.eclipse.efm.ecore.formalml.infrastructure.Variable;
import org.eclipse.efm.ecore.formalml.statemachine.Region;
import org.eclipse.efm.ecore.formalml.statemachine.Statemachine;
import org.eclipse.efm.ecore.formalml.statemachine.StatemachinePackage;
import org.eclipse.efm.ecore.formalml.statemachine.Transition;
import org.eclipse.efm.ecore.formalml.statement.AbstractComStatement;
import org.eclipse.efm.ecore.formalml.statement.ActivityStatement;
import org.eclipse.efm.ecore.formalml.statement.InputComStatement;
import org.eclipse.efm.ecore.formalml.statement.InvokeStatement;
import org.eclipse.efm.ecore.formalml.statement.OutputComStatement;
import org.eclipse.efm.ecore.formalml.statement.StatementPackage;
import org.eclipse.efm.formalml.xtext.scoping.AbstractFormalMLScopeProvider;
import org.eclipse.efm.formalml.xtext.typing.FormalMLTypeProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class FormalMLScopeProvider
extends AbstractFormalMLScopeProvider {
    @Inject
    @Extension
    private FormalMLTypeProvider _formalMLTypeProvider;

    public IScope getScope(EObject context, EReference reference) {
        IScope scope;
        IScope _xblockexpression = null;
        String _name = reference.getEContainingClass().getName();
        String _plus = "scope_" + _name;
        String _plus_1 = String.valueOf(_plus) + "_";
        String _name_1 = reference.getName();
        String _plus_2 = String.valueOf(_plus_1) + _name_1;
        String _plus_3 = String.valueOf(_plus_2) + "(";
        EObject _eContainer = context.eContainer();
        EClass _eClass = null;
        if (_eContainer != null) {
            _eClass = _eContainer.eClass();
        }
        String _name_2 = _eClass.getName();
        String _plus_4 = String.valueOf(_plus_3) + _name_2;
        String _plus_5 = String.valueOf(_plus_4) + ".";
        String _name_3 = context.eClass().getName();
        String _plus_6 = String.valueOf(_plus_5) + _name_3;
        String requiredScoping = String.valueOf(_plus_6) + " context, EReference reference)";
        _xblockexpression = scope = this.getScopeImpl(context, reference, requiredScoping);
        return _xblockexpression;
    }

    public IScope getScopeImpl(EObject context, EReference reference, String requiredScoping) {
        boolean _matched = false;
        if (Objects.equal((Object)reference, (Object)StatemachinePackage.Literals.TRANSITION__TARGET)) {
            _matched = true;
            return this.scope_Transition_target((Transition)context, reference);
        }
        if (!_matched && Objects.equal((Object)reference, (Object)ExpressionPackage.Literals.LITERAL_REFERENCE_ELEMENT__VALUE)) {
            _matched = true;
            return this.scope_LiteralReferenceElement_value((LiteralReferenceElement)context, reference);
        }
        if (!_matched && Objects.equal((Object)reference, (Object)ExpressionPackage.Literals.VALUE_ELEMENT_SPECIFICATION__ELEMENT)) {
            _matched = true;
            return this.scope_ValueElementSpecification_element((ValueElementSpecification)context, reference);
        }
        if (!_matched && Objects.equal((Object)reference, (Object)ExpressionPackage.Literals.CAST_EXPRESSION__DATATYPE)) {
            _matched = true;
            return this.scope_CastExpression_datatype((CastExpression)context, reference);
        }
        if (!_matched && Objects.equal((Object)reference, (Object)StatementPackage.Literals.ABSTRACT_COM_STATEMENT__PORT)) {
            _matched = true;
            return this.scope_AbstractComStatement_port((AbstractComStatement)context, reference);
        }
        if (!_matched && Objects.equal((Object)reference, (Object)StatementPackage.Literals.INVOKE_STATEMENT__INVOKABLE)) {
            _matched = true;
            return this.scope_InvokeStatement_invokable((InvokeStatement)context, reference);
        }
        if (!_matched && Objects.equal((Object)reference, (Object)DatatypePackage.Literals.DATA_TYPE_REFERENCE__TYPEREF)) {
            _matched = true;
            return this.scope_DataTypeReference_typeref((DataTypeReference)context, reference);
        }
        if (!_matched && Objects.equal((Object)reference, (Object)InfrastructurePackage.Literals.INSTANCE_MACHINE__MODEL)) {
            _matched = true;
            return this.scope_InstanceMachine_model((InstanceMachine)context, reference);
        }
        if (!_matched && Objects.equal((Object)reference, (Object)InfrastructurePackage.Literals.ROUTE__SIGNALS)) {
            _matched = true;
            return this.scope_Route_signals((Route)context, reference);
        }
        if (!_matched && Objects.equal((Object)reference, (Object)InfrastructurePackage.Literals.SLOT_PROPERTY__XLIA_PROPERTY)) {
            _matched = true;
            return this.scope_SlotProperty_xliaProperty((SlotProperty)context, reference);
        }
        if (!_matched && Objects.equal((Object)reference, (Object)DatatypePackage.Literals.PRIMITIVE_INSTANCE_TYPE__MODEL)) {
            _matched = true;
            return this.scope_PrimitiveInstanceType_model((PrimitiveInstanceType)context, reference);
        }
        InputOutput.print((Object)"TO DO case: ");
        InputOutput.println((Object)requiredScoping);
        IScope scope = super.getScope(context, reference);
        InputOutput.print((Object)"\tdefault::IScope: ");
        InputOutput.println((Object)scope);
        return scope;
    }

    public IScope scope_Transition_target(Transition context, EReference reference) {
        IScope _xblockexpression = null;
        IScope parentScope = IScope.NULLSCOPE;
        Region region = (Region)EcoreUtil2.getContainerOfType((EObject)context, Region.class);
        Machine thisMachine = (Machine)EcoreUtil2.getContainerOfType((EObject)region, Machine.class);
        _xblockexpression = Scopes.scopeFor(this.selectTypedElement((Iterable<? extends TypedElement>)thisMachine.getProperty(), PrimitiveInstanceKind.VERTEX), (IScope)Scopes.scopeFor((Iterable)region.getVertex(), (IScope)parentScope));
        return _xblockexpression;
    }

    public IScope scope_AbstractComStatement_port(AbstractComStatement context, EReference reference) {
        boolean _matched = false;
        if (context instanceof OutputComStatement) {
            _matched = true;
            return this.scopeForComElement((AbstractElement)context, PrimitiveInstanceKind.COM_POINT, ChannelDirection.OUTPUT);
        }
        if (!_matched && context instanceof InputComStatement) {
            _matched = true;
            return this.scopeForComElement((AbstractElement)context, PrimitiveInstanceKind.COM_POINT, ChannelDirection.INPUT);
        }
        IScope parentScope = IScope.NULLSCOPE;
        return parentScope;
    }

    public Iterable<Port> selectPort(Iterable<Port> elements, ChannelDirection dir) {
        Iterable _xifexpression = null;
        boolean _equals = Objects.equal((Object)dir, (Object)ChannelDirection.INOUT);
        if (_equals) {
            _xifexpression = elements;
        } else {
            Functions.Function1 _function = it -> Objects.equal((Object)it.getDirection(), (Object)dir) || Objects.equal((Object)it.getDirection(), (Object)ChannelDirection.INOUT);
            _xifexpression = IterableExtensions.filter(elements, (Functions.Function1)_function);
        }
        return _xifexpression;
    }

    public Iterable<Signal> selectSignal(Iterable<Signal> elements, ChannelDirection dir) {
        Iterable _xifexpression = null;
        boolean _equals = Objects.equal((Object)dir, (Object)ChannelDirection.INOUT);
        if (_equals) {
            _xifexpression = elements;
        } else {
            Functions.Function1 _function = it -> Objects.equal((Object)it.getDirection(), (Object)dir) || Objects.equal((Object)it.getDirection(), (Object)ChannelDirection.INOUT);
            _xifexpression = IterableExtensions.filter(elements, (Functions.Function1)_function);
        }
        return _xifexpression;
    }

    public IScope scopeForComElement(AbstractElement context, PrimitiveInstanceKind expected, ChannelDirection direction) {
        IScope _xblockexpression = null;
        AbstractElement it = context;
        while (it != null) {
            boolean _matched = false;
            if (it instanceof Routine) {
                _matched = true;
                return this.scopeForHierarchicLeftElement((Routine)it, ValueElementSpecificationScheme.COM_POINT);
            }
            if (!_matched && it instanceof Machine) {
                _matched = true;
                Machine thisMachine = (Machine)EcoreUtil2.getContainerOfType((EObject)context, Machine.class);
                while (thisMachine != null && thisMachine.getPort().isEmpty() && thisMachine.getSignal().isEmpty()) {
                    thisMachine = (Machine)EcoreUtil2.getContainerOfType((EObject)thisMachine.eContainer(), Machine.class);
                }
                IScope parentScope = IScope.NULLSCOPE;
                if (thisMachine != null) {
                    parentScope = Scopes.scopeFor(this.selectTypedElement((Iterable<? extends TypedElement>)thisMachine.getProperty(), expected), (IScope)Scopes.scopeFor(this.selectSignal((Iterable<Signal>)thisMachine.getSignal(), direction), (IScope)Scopes.scopeFor(this.selectPort((Iterable<Port>)thisMachine.getPort(), direction), (IScope)parentScope)));
                }
                return parentScope;
            }
            it = it.eContainer();
        }
        _xblockexpression = IScope.NULLSCOPE;
        return _xblockexpression;
    }

    public IScope scope_LiteralReferenceElement_value(LiteralReferenceElement context, EReference reference) {
        IScope _xblockexpression = null;
        IScope parentScope = IScope.NULLSCOPE;
        EObject container = context.eContainer();
        while (container != null) {
            boolean _matched = false;
            if (container instanceof ValueElementSpecification) {
                _matched = true;
                return this.scopeForThis((ValueElementSpecification)container, context);
            }
            if (!_matched && container instanceof LeftHandSideExpression) {
                _matched = true;
                return this.scopeForThis((LeftHandSideExpression)container, context);
            }
            if (!_matched && container instanceof TupleExpression) {
                _matched = true;
                return this.scopeForThis((TupleExpression)container, context);
            }
            if (!_matched && container instanceof QuantifiedLogicalExpression) {
                _matched = true;
                return this.scopeForThis((QuantifiedLogicalExpression)container, context);
            }
            if (!_matched && container instanceof InvokeExpression) {
                _matched = true;
                return this.scopeForThis((InvokeExpression)container, context);
            }
            if (!_matched && container instanceof InputComStatement) {
                _matched = true;
                return this.scopeForThis((InputComStatement)container, context);
            }
            if (!_matched && container instanceof OutputComStatement) {
                _matched = true;
                return this.scopeForThis((OutputComStatement)container, context);
            }
            if (!_matched && container instanceof ActivityStatement) {
                _matched = true;
                return this.scopeForThis((ActivityStatement)container, context);
            }
            if (!_matched && container instanceof Transition) {
                _matched = true;
                return this.scopeForThis((Transition)container, context);
            }
            if (!_matched && container instanceof ComPoint) {
                _matched = true;
                return this.scopeForThis((ComPoint)container, context);
            }
            if (!_matched && container instanceof Routine) {
                _matched = true;
                return this.scopeForAnyElement((Routine)container, context);
            }
            if (!_matched && container instanceof Machine) {
                _matched = true;
                return this.scopeForAnyElement((Machine)container, context);
            }
            if (!_matched && container instanceof PrimitiveInstanceType) {
                _matched = true;
                return this.scopeForAnyModelElement((PrimitiveInstanceType)container, (AbstractElement)context);
            }
            if (!_matched && container instanceof DataTypeReference) {
                _matched = true;
                return this.scopeForThis((DataTypeReference)container, context);
            }
            container = container.eContainer();
        }
        _xblockexpression = parentScope;
        return _xblockexpression;
    }

    public IScope scope_ValueElementSpecification_element(ValueElementSpecification context, EReference reference) {
        IScope _xblockexpression = null;
        IScope parentScope = IScope.NULLSCOPE;
        Type _elvis = null;
        Type _typeFor = this._formalMLTypeProvider.typeFor(context.getTarget());
        if (_typeFor != null) {
            _elvis = _typeFor;
        } else {
            Machine _containerOfType = (Machine)EcoreUtil2.getContainerOfType((EObject)context, Machine.class);
            _elvis = _containerOfType;
        }
        Type type = _elvis;
        if (type == null || this._formalMLTypeProvider.isPrimitive(type)) {
            return parentScope;
        }
        EObject container = context.eContainer();
        ValueElementSpecificationScheme _expected = context.getExpected();
        boolean _equals = Objects.equal((Object)_expected, (Object)ValueElementSpecificationScheme.ANY);
        if (_equals) {
            boolean _matched = false;
            if (container instanceof ComPoint) {
                _matched = true;
                context.setExpected(ValueElementSpecificationScheme.COM_POINT);
            }
            if (!_matched && container instanceof ComProtocol) {
                _matched = true;
                context.setExpected(ValueElementSpecificationScheme.BUFFER);
            }
            if (!_matched && container instanceof InputComStatement) {
                _matched = true;
                context.setExpected(ValueElementSpecificationScheme.COM_POINT);
            }
            if (!_matched && container instanceof OutputComStatement) {
                _matched = true;
                context.setExpected(ValueElementSpecificationScheme.COM_POINT);
            }
        }
        IScope _xifexpression = null;
        if (type instanceof Machine) {
            IScope _xblockexpression_1 = null;
            Machine typeMachine = (Machine)type;
            IScope _xifexpression_1 = null;
            ValueElementSpecificationScheme _expected_1 = context.getExpected();
            boolean _equals_1 = Objects.equal((Object)_expected_1, (Object)ValueElementSpecificationScheme.BUFFER);
            if (_equals_1) {
                _xifexpression_1 = this.scopeForHierarchicLeftElement(typeMachine, context.getExpected());
            } else {
                IScope _xifexpression_2 = null;
                ValueElementSpecificationScheme _expected_2 = context.getExpected();
                boolean _equals_2 = Objects.equal((Object)_expected_2, (Object)ValueElementSpecificationScheme.COM_POINT);
                if (_equals_2) {
                    IScope _switchResult_1 = null;
                    boolean _matched_1 = false;
                    if (container instanceof ComPoint) {
                        _matched_1 = true;
                        EObject _eContainer = context.eContainer();
                        _switchResult_1 = this.scopeForSelfMachineComPoint(typeMachine, ((ComPoint)_eContainer).getDirection());
                    }
                    if (!_matched_1 && container instanceof InputComStatement) {
                        _matched_1 = true;
                        _switchResult_1 = Scopes.scopeFor(this.selectLeftElements(typeMachine, context), (IScope)parentScope);
                    }
                    if (!_matched_1 && container instanceof OutputComStatement) {
                        _matched_1 = true;
                        _switchResult_1 = Scopes.scopeFor(this.selectRigthElements(typeMachine, context), (IScope)parentScope);
                    }
                    _xifexpression_2 = _switchResult_1;
                } else {
                    IScope _xifexpression_3 = null;
                    if (context.getTarget() instanceof LiteralReferenceExpression && !(context.getTarget() instanceof LiteralReferenceElement)) {
                        _xifexpression_3 = Scopes.scopeFor(this.selectLeftElements(typeMachine, context), (IScope)parentScope);
                    } else {
                        IScope _xifexpression_4 = null;
                        boolean _isAncestorOf = this.isAncestorOf((EObject)typeMachine, (EObject)context);
                        if (_isAncestorOf) {
                            IScope _xblockexpression_2 = null;
                            List<Machine> _reverseMachineHierarchy = this.reverseMachineHierarchy(typeMachine);
                            for (Machine machine : _reverseMachineHierarchy) {
                                parentScope = Scopes.scopeFor(this.selectLeftElements(machine, context), (IScope)parentScope);
                            }
                            _xifexpression_4 = _xblockexpression_2 = Scopes.scopeFor(this.selectLeftElements(typeMachine, context), (IScope)parentScope);
                        } else {
                            IScope _xblockexpression_3 = null;
                            List<Machine> _reverseMachineHierarchy = this.reverseMachineHierarchy(typeMachine);
                            for (Machine machine : _reverseMachineHierarchy) {
                                parentScope = Scopes.scopeFor(this.selectPublicLeftElements(machine, context), (IScope)parentScope);
                            }
                            _xifexpression_4 = _xblockexpression_3 = Scopes.scopeFor(this.selectPublicLeftElements(typeMachine, context), (IScope)parentScope);
                        }
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            IScope _xifexpression_1 = null;
            _xifexpression_1 = type instanceof DataType ? Scopes.scopeFor(this.selectElements((DataType)type, context), (IScope)parentScope) : parentScope;
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public IScope scope_CastExpression_datatype(CastExpression context, EReference reference) {
        return super.getScope((EObject)context, reference);
    }

    public IScope scope_InvokeStatement_invokable(InvokeStatement context, EReference reference) {
        IScope _xblockexpression = null;
        IScope parentScope = IScope.NULLSCOPE;
        Machine thisMachine = (Machine)EcoreUtil2.getContainerOfType((EObject)context, Machine.class);
        boolean _isExecRoutine = context.isExecRoutine();
        if (_isExecRoutine) {
            while (thisMachine != null && thisMachine.getRoutine().isEmpty()) {
                thisMachine = (Machine)EcoreUtil2.getContainerOfType((EObject)thisMachine.eContainer(), Machine.class);
            }
            if (thisMachine != null) {
                Functions.Function1 _function;
                Functions.Function1 machineHasRoutine = _function = m -> {
                    boolean _isEmpty = m.getRoutine().isEmpty();
                    return !_isEmpty;
                };
                List<Machine> _reverseMachineHierarchy = this.reverseMachineHierarchy(thisMachine, (Functions.Function1<Machine, Boolean>)machineHasRoutine);
                for (Machine machine : _reverseMachineHierarchy) {
                    boolean _not;
                    boolean _isEmpty = machine.getRoutine().isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (!_not) continue;
                    parentScope = Scopes.scopeFor(this.selectNonPrivate((Iterable<? extends NamedElement>)machine.getRoutine()), (IScope)parentScope);
                }
                parentScope = Scopes.scopeFor((Iterable)thisMachine.getRoutine(), (IScope)parentScope);
            }
        } else {
            boolean _isCallProcedure = context.isCallProcedure();
            if (_isCallProcedure) {
                while (thisMachine != null && thisMachine.getProcedure().isEmpty()) {
                    thisMachine = (Machine)EcoreUtil2.getContainerOfType((EObject)thisMachine.eContainer(), Machine.class);
                }
                if (thisMachine != null) {
                    Functions.Function1 _function_1;
                    Functions.Function1 machineHasProcedure = _function_1 = m -> {
                        boolean _isEmpty_1 = m.getProcedure().isEmpty();
                        return !_isEmpty_1;
                    };
                    List<Machine> _reverseMachineHierarchy_1 = this.reverseMachineHierarchy(thisMachine, (Functions.Function1<Machine, Boolean>)machineHasProcedure);
                    for (Machine machine_1 : _reverseMachineHierarchy_1) {
                        boolean _not_1;
                        boolean _isEmpty_1 = machine_1.getProcedure().isEmpty();
                        boolean bl = _not_1 = !_isEmpty_1;
                        if (!_not_1) continue;
                        parentScope = Scopes.scopeFor(this.selectNonPrivate((Iterable<? extends NamedElement>)machine_1.getProcedure()), (IScope)parentScope);
                    }
                    parentScope = Scopes.scopeFor((Iterable)thisMachine.getProcedure(), (IScope)parentScope);
                }
            }
        }
        _xblockexpression = parentScope;
        return _xblockexpression;
    }

    public IScope scope_DataTypeReference_typeref(DataTypeReference context, EReference reference) {
        IScope _xblockexpression = null;
        Machine thisMachine = (Machine)EcoreUtil2.getContainerOfType((EObject)context, Machine.class);
        _xblockexpression = this.scopeForHierarchicRigthElement(thisMachine, ValueElementSpecificationScheme.TYPEDEF);
        return _xblockexpression;
    }

    public IScope scope_InstanceMachine_model(InstanceMachine context, EReference reference) {
        return this.scopeForHierarchicLeftElement((EObject)context, ValueElementSpecificationScheme.MODEL);
    }

    public IScope scope_Route_signals(Route context, EReference reference) {
        return this.scopeForComElement((AbstractElement)context, PrimitiveInstanceKind.SIGNAL, ChannelDirection.INPUT);
    }

    public IScope scope_SlotProperty_xliaProperty(SlotProperty context, EReference reference) {
        IScope _xblockexpression = null;
        InstanceMachine instance = (InstanceMachine)EcoreUtil2.getContainerOfType((EObject)context, InstanceMachine.class);
        Machine model = instance.getModel();
        IScope parentScope = Scopes.scopeFor(this.selectNonFinalNorConst((Iterable<? extends PropertyDefinition>)model.getProperty()), (IScope)Scopes.scopeFor((Iterable)model.getBuffer(), (IScope)IScope.NULLSCOPE));
        if (model instanceof Behavior) {
            parentScope = Scopes.scopeFor((Iterable)((Behavior)model).getParameter(), (IScope)parentScope);
        }
        _xblockexpression = parentScope;
        return _xblockexpression;
    }

    public IScope scope_PrimitiveInstanceType_model(PrimitiveInstanceType context, EReference reference) {
        return this.scopeForAnyModelElement(context, (AbstractElement)context);
    }

    public Iterable<? extends NamedElement> selectPublic(Iterable<? extends NamedElement> elements) {
        Functions.Function1 _function = it -> {
            VisibilityKind _visibility = it.getVisibility();
            return Objects.equal((Object)_visibility, (Object)VisibilityKind.PUBLIC);
        };
        return IterableExtensions.filter(elements, (Functions.Function1)_function);
    }

    public Iterable<? extends NamedElement> selectNonPublic(Iterable<? extends NamedElement> elements) {
        Functions.Function1 _function = it -> {
            VisibilityKind _visibility = it.getVisibility();
            return !Objects.equal((Object)_visibility, (Object)VisibilityKind.PUBLIC);
        };
        return IterableExtensions.filter(elements, (Functions.Function1)_function);
    }

    public Iterable<? extends NamedElement> selectNonPrivate(Iterable<? extends NamedElement> elements) {
        Functions.Function1 _function = it -> {
            VisibilityKind _visibility = it.getVisibility();
            return !Objects.equal((Object)_visibility, (Object)VisibilityKind.PRIVATE);
        };
        return IterableExtensions.filter(elements, (Functions.Function1)_function);
    }

    public Iterable<? extends PropertyDefinition> selectNonFinalNorConst(Iterable<? extends PropertyDefinition> elements) {
        Functions.Function1 _function;
        Iterable _xblockexpression = null;
        Functions.Function1 nonFinalNorConstPredicate = _function = P -> !P.getModifier().isFinal() && (!(P instanceof Variable) || !((Variable)P).isConst());
        _xblockexpression = IterableExtensions.filter(elements, (Functions.Function1)nonFinalNorConstPredicate);
        return _xblockexpression;
    }

    public boolean isAncestorOf(EObject container, EObject element) {
        boolean _xblockexpression = false;
        EObject ancestor = element.eContainer();
        while (ancestor != null && !Objects.equal((Object)ancestor, (Object)container)) {
            ancestor = ancestor.eContainer();
        }
        _xblockexpression = ancestor != null;
        return _xblockexpression;
    }

    public Iterable<? extends TypedElement> selectTypedElement(Iterable<? extends TypedElement> elements, PrimitiveInstanceKind expected) {
        Functions.Function1 _function;
        Iterable _xblockexpression = null;
        Functions.Function1 typePredicate = _function = element -> element.getType() instanceof PrimitiveInstanceType && Objects.equal((Object)((PrimitiveInstanceType)element.getType()).getExpected(), (Object)expected);
        _xblockexpression = IterableExtensions.filter(elements, (Functions.Function1)typePredicate);
        return _xblockexpression;
    }

    public List<Machine> reverseMachineHierarchy(Machine machine) {
        List _xblockexpression = null;
        ArrayList hierarchy = CollectionLiterals.newArrayList((Object[])new Machine[0]);
        Machine container = (Machine)EcoreUtil2.getContainerOfType((EObject)machine.eContainer(), Machine.class);
        while (container != null) {
            hierarchy.add(container);
            container = (Machine)EcoreUtil2.getContainerOfType((EObject)container.eContainer(), Machine.class);
        }
        _xblockexpression = ListExtensions.reverseView((List)hierarchy);
        return _xblockexpression;
    }

    public List<Machine> reverseMachineHierarchy(Machine machine, Functions.Function1<Machine, Boolean> predicate) {
        List _xblockexpression = null;
        ArrayList hierarchy = CollectionLiterals.newArrayList((Object[])new Machine[0]);
        Machine container = (Machine)EcoreUtil2.getContainerOfType((EObject)machine.eContainer(), Machine.class);
        while (container != null && ((Boolean)predicate.apply((Object)container)).booleanValue()) {
            hierarchy.add(container);
            container = (Machine)EcoreUtil2.getContainerOfType((EObject)container.eContainer(), Machine.class);
        }
        _xblockexpression = ListExtensions.reverseView((List)hierarchy);
        return _xblockexpression;
    }

    public Iterable<? extends NamedElement> selectLeftElements(Machine machine, ValueElementSpecification ves) {
        Iterable _xifexpression = null;
        ValueElementSpecificationKind _kind = ves.getKind();
        boolean _equals = Objects.equal((Object)_kind, (Object)ValueElementSpecificationKind.PARAMETER);
        if (_equals) {
            EList _routine = machine.getRoutine();
            EList _procedure = machine.getProcedure();
            _xifexpression = Iterables.concat((Iterable)_routine, (Iterable)_procedure);
        } else {
            _xifexpression = this.selectLeftElements(machine, ves.getExpected());
        }
        return _xifexpression;
    }

    public Iterable<? extends NamedElement> selectPublicLeftElements(Machine machine, ValueElementSpecification ves) {
        Iterable _xifexpression = null;
        ValueElementSpecificationKind _kind = ves.getKind();
        boolean _equals = Objects.equal((Object)_kind, (Object)ValueElementSpecificationKind.PARAMETER);
        if (_equals) {
            EList _routine = machine.getRoutine();
            EList _procedure = machine.getProcedure();
            _xifexpression = Iterables.concat((Iterable)_routine, (Iterable)_procedure);
        } else {
            _xifexpression = this.selectPublicLeftElements(machine, ves.getExpected());
        }
        return _xifexpression;
    }

    public Iterable<? extends NamedElement> selectRigthElements(Machine machine, ValueElementSpecification ves) {
        Iterable _xifexpression = null;
        ValueElementSpecificationKind _kind = ves.getKind();
        boolean _equals = Objects.equal((Object)_kind, (Object)ValueElementSpecificationKind.PARAMETER);
        if (_equals) {
            EList _routine = machine.getRoutine();
            EList _procedure = machine.getProcedure();
            _xifexpression = Iterables.concat((Iterable)_routine, (Iterable)_procedure);
        } else {
            _xifexpression = this.selectLeftElements(machine, ves.getExpected());
        }
        return _xifexpression;
    }

    public Iterable<? extends NamedElement> selectElements(DataType type, ValueElementSpecification ves) {
        boolean _notEquals;
        EList _xifexpression = null;
        ValueElementSpecificationKind _kind = ves.getKind();
        boolean bl = _notEquals = !Objects.equal((Object)_kind, (Object)ValueElementSpecificationKind.PARAMETER);
        if (_notEquals) {
            Object _switchResult = null;
            boolean _matched = false;
            if (type instanceof EnumerationType) {
                _matched = true;
                _switchResult = ((EnumerationType)type).getLiteral();
            }
            if (!_matched && type instanceof DataStructuredType) {
                _matched = true;
                _switchResult = ((DataStructuredType)type).getProperty();
            }
            if (!_matched && type instanceof DataSupportedType) {
                _matched = true;
                _switchResult = this.selectElements(((DataSupportedType)type).getSupport(), ves);
            }
            if (!_matched && type instanceof DataTypeReference) {
                boolean _tripleNotEquals;
                _matched = true;
                Iterable<? extends NamedElement> _xifexpression_1 = null;
                DataType _typeref = ((DataTypeReference)type).getTyperef();
                boolean bl2 = _tripleNotEquals = _typeref != null;
                if (_tripleNotEquals) {
                    _xifexpression_1 = this.selectElements(((DataTypeReference)type).getTyperef(), ves);
                } else {
                    boolean _tripleNotEquals_1;
                    Iterable<? extends NamedElement> _xifexpression_2 = null;
                    DataType _support = ((DataTypeReference)type).getSupport();
                    boolean bl3 = _tripleNotEquals_1 = _support != null;
                    if (_tripleNotEquals_1) {
                        _xifexpression_2 = this.selectElements(((DataTypeReference)type).getSupport(), ves);
                    }
                    _xifexpression_1 = _xifexpression_2;
                }
                _switchResult = _xifexpression_1;
            }
            _xifexpression = _switchResult;
        }
        return _xifexpression;
    }

    public Iterable<? extends NamedElement> selectLeftElements(Machine block, ValueElementSpecificationScheme expected) {
        Object _switchResult = null;
        if (expected != null) {
            switch (expected) {
                case ANY: {
                    EList _property = block.getProperty();
                    EList _channel = block.getChannel();
                    Iterable _plus = Iterables.concat((Iterable)_property, (Iterable)_channel);
                    EList _buffer = block.getBuffer();
                    Iterable _plus_1 = Iterables.concat((Iterable)_plus, (Iterable)_buffer);
                    EList _port = block.getPort();
                    Iterable _plus_2 = Iterables.concat((Iterable)_plus_1, (Iterable)_port);
                    EList _signal = block.getSignal();
                    Iterable _plus_3 = Iterables.concat((Iterable)_plus_2, (Iterable)_signal);
                    EList _machine = block.getMachine();
                    Iterable _plus_4 = Iterables.concat((Iterable)_plus_3, (Iterable)_machine);
                    EList _instance = block.getInstance();
                    Iterable _plus_5 = Iterables.concat((Iterable)_plus_4, (Iterable)_instance);
                    EList _behavior = block.getBehavior();
                    Iterable _plus_6 = Iterables.concat((Iterable)_plus_5, (Iterable)_behavior);
                    EList _routine = block.getRoutine();
                    Iterable _plus_7 = Iterables.concat((Iterable)_plus_6, (Iterable)_routine);
                    EList _procedure = block.getProcedure();
                    Iterable _plus_8 = Iterables.concat((Iterable)_plus_7, (Iterable)_procedure);
                    EList _typedef = block.getTypedef();
                    _switchResult = Iterables.concat((Iterable)_plus_8, (Iterable)_typedef);
                    break;
                }
                case VARIABLE: {
                    _switchResult = block.getProperty();
                    break;
                }
                case TYPEDEF: {
                    _switchResult = block.getTypedef();
                    break;
                }
                case PORT: {
                    _switchResult = block.getPort();
                    break;
                }
                case SIGNAL: {
                    _switchResult = block.getSignal();
                    break;
                }
                case MESSAGE: {
                    EList _port_1 = block.getPort();
                    EList _signal_1 = block.getSignal();
                    _switchResult = Iterables.concat((Iterable)_port_1, (Iterable)_signal_1);
                    break;
                }
                case COM_POINT: {
                    EList _port_2 = block.getPort();
                    EList _signal_2 = block.getSignal();
                    _switchResult = Iterables.concat((Iterable)_port_2, (Iterable)_signal_2);
                    break;
                }
                case INSTANCE: {
                    _switchResult = block.getInstance();
                    break;
                }
                case MACHINE: {
                    EList _machine_1 = block.getMachine();
                    EList _instance_1 = block.getInstance();
                    Iterable _plus_9 = Iterables.concat((Iterable)_machine_1, (Iterable)_instance_1);
                    EList _behavior_1 = block.getBehavior();
                    _switchResult = Iterables.concat((Iterable)_plus_9, (Iterable)_behavior_1);
                    break;
                }
                case MODEL: {
                    EList _machine_2 = block.getMachine();
                    EList _behavior_2 = block.getBehavior();
                    _switchResult = Iterables.concat((Iterable)_machine_2, (Iterable)_behavior_2);
                    break;
                }
                case BUFFER: {
                    _switchResult = block.getBuffer();
                    break;
                }
                case CHANNEL: {
                    _switchResult = block.getChannel();
                    break;
                }
                case VERTEX: {
                    _switchResult = null;
                    break;
                }
                case PROCEDURE: {
                    _switchResult = block.getProcedure();
                    break;
                }
                case ROUTINE: {
                    _switchResult = block.getRoutine();
                    break;
                }
            }
        }
        return _switchResult;
    }

    public Iterable<? extends NamedElement> selectPublicLeftElements(Machine block, ValueElementSpecificationScheme expected) {
        return this.selectPublic(this.selectLeftElements(block, expected));
    }

    public Iterable<? extends NamedElement> selectNonPublicLeftElements(Machine block, ValueElementSpecificationScheme expected) {
        return this.selectNonPublic(this.selectLeftElements(block, expected));
    }

    public Iterable<? extends NamedElement> selectRigthElements(Machine block, ValueElementSpecificationScheme expected) {
        Object _switchResult = null;
        if (expected != null) {
            switch (expected) {
                case ANY: {
                    EList _property = block.getProperty();
                    ArrayList<EnumerationLiteral> _enumLiterals = this.enumLiterals(block);
                    Iterable _plus = Iterables.concat((Iterable)_property, _enumLiterals);
                    EList _channel = block.getChannel();
                    Iterable _plus_1 = Iterables.concat((Iterable)_plus, (Iterable)_channel);
                    EList _buffer = block.getBuffer();
                    Iterable _plus_2 = Iterables.concat((Iterable)_plus_1, (Iterable)_buffer);
                    EList _port = block.getPort();
                    Iterable _plus_3 = Iterables.concat((Iterable)_plus_2, (Iterable)_port);
                    EList _signal = block.getSignal();
                    Iterable _plus_4 = Iterables.concat((Iterable)_plus_3, (Iterable)_signal);
                    EList _machine = block.getMachine();
                    Iterable _plus_5 = Iterables.concat((Iterable)_plus_4, (Iterable)_machine);
                    EList _instance = block.getInstance();
                    Iterable _plus_6 = Iterables.concat((Iterable)_plus_5, (Iterable)_instance);
                    EList _behavior = block.getBehavior();
                    Iterable _plus_7 = Iterables.concat((Iterable)_plus_6, (Iterable)_behavior);
                    EList _routine = block.getRoutine();
                    Iterable _plus_8 = Iterables.concat((Iterable)_plus_7, (Iterable)_routine);
                    EList _procedure = block.getProcedure();
                    Iterable _plus_9 = Iterables.concat((Iterable)_plus_8, (Iterable)_procedure);
                    EList _typedef = block.getTypedef();
                    _switchResult = Iterables.concat((Iterable)_plus_9, (Iterable)_typedef);
                    break;
                }
                case VARIABLE: {
                    _switchResult = block.getProperty();
                    break;
                }
                case TYPEDEF: {
                    _switchResult = block.getTypedef();
                    break;
                }
                case PORT: {
                    EList _port_1 = block.getPort();
                    Iterable<? extends PropertyDefinition> _selectProperty = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    _switchResult = Iterables.concat((Iterable)_port_1, _selectProperty);
                    break;
                }
                case SIGNAL: {
                    EList _signal_1 = block.getSignal();
                    Iterable<? extends PropertyDefinition> _selectProperty_1 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    _switchResult = Iterables.concat((Iterable)_signal_1, _selectProperty_1);
                    break;
                }
                case MESSAGE: {
                    EList _port_2 = block.getPort();
                    EList _signal_2 = block.getSignal();
                    Iterable _plus_10 = Iterables.concat((Iterable)_port_2, (Iterable)_signal_2);
                    Iterable<? extends PropertyDefinition> _selectProperty_2 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    _switchResult = Iterables.concat((Iterable)_plus_10, _selectProperty_2);
                    break;
                }
                case COM_POINT: {
                    EList _port_3 = block.getPort();
                    EList _signal_3 = block.getSignal();
                    Iterable _plus_11 = Iterables.concat((Iterable)_port_3, (Iterable)_signal_3);
                    Iterable<? extends PropertyDefinition> _selectProperty_3 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    _switchResult = Iterables.concat((Iterable)_plus_11, _selectProperty_3);
                    break;
                }
                case INSTANCE: {
                    EList _instance_1 = block.getInstance();
                    Iterable<? extends PropertyDefinition> _selectProperty_4 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    _switchResult = Iterables.concat((Iterable)_instance_1, _selectProperty_4);
                    break;
                }
                case MACHINE: {
                    EList _machine_1 = block.getMachine();
                    EList _instance_2 = block.getInstance();
                    Iterable _plus_12 = Iterables.concat((Iterable)_machine_1, (Iterable)_instance_2);
                    EList _behavior_1 = block.getBehavior();
                    Iterable _plus_13 = Iterables.concat((Iterable)_plus_12, (Iterable)_behavior_1);
                    Iterable<? extends PropertyDefinition> _selectProperty_5 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    _switchResult = Iterables.concat((Iterable)_plus_13, _selectProperty_5);
                    break;
                }
                case MODEL: {
                    EList _machine_2 = block.getMachine();
                    EList _behavior_2 = block.getBehavior();
                    _switchResult = Iterables.concat((Iterable)_machine_2, (Iterable)_behavior_2);
                    break;
                }
                case BUFFER: {
                    EList _buffer_1 = block.getBuffer();
                    Iterable<? extends PropertyDefinition> _selectProperty_6 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    _switchResult = Iterables.concat((Iterable)_buffer_1, _selectProperty_6);
                    break;
                }
                case CHANNEL: {
                    EList _channel_1 = block.getChannel();
                    Iterable<? extends PropertyDefinition> _selectProperty_7 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    _switchResult = Iterables.concat((Iterable)_channel_1, _selectProperty_7);
                    break;
                }
                case VERTEX: {
                    _switchResult = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    break;
                }
                case PROCEDURE: {
                    _switchResult = block.getProcedure();
                    break;
                }
                case ROUTINE: {
                    _switchResult = block.getRoutine();
                    break;
                }
            }
        }
        return _switchResult;
    }

    public Iterable<? extends NamedElement> selectPublicRigthElements(Machine block, ValueElementSpecificationScheme expected) {
        return this.selectPublic(this.selectRigthElements(block, expected));
    }

    public Iterable<? extends NamedElement> selectNonPublicRigthElements(Machine block, ValueElementSpecificationScheme expected) {
        return this.selectNonPublic(this.selectRigthElements(block, expected));
    }

    public ArrayList<EnumerationLiteral> enumLiterals(Machine machine) {
        ArrayList _xblockexpression = null;
        ArrayList literals = CollectionLiterals.newArrayList((Object[])new EnumerationLiteral[0]);
        EList _typedef = machine.getTypedef();
        for (DataType it : _typedef) {
            Type type = this._formalMLTypeProvider.typeSpecifier((Type)it);
            if (!(type instanceof EnumerationType)) continue;
            EList _literal = ((EnumerationType)type).getLiteral();
            Iterables.addAll((Collection)literals, (Iterable)_literal);
        }
        _xblockexpression = literals;
        return _xblockexpression;
    }

    public ArrayList<NamedElement> selectStructuredElements(Machine block, ValueElementSpecificationScheme expected) {
        ArrayList _xblockexpression = null;
        ArrayList roots = CollectionLiterals.newArrayList((Object[])new NamedElement[0]);
        if (expected != null) {
            switch (expected) {
                case ANY: {
                    EList _property = block.getProperty();
                    for (PropertyDefinition it : _property) {
                        boolean _isStructured = this._formalMLTypeProvider.isStructured(it.getType());
                        if (!_isStructured) continue;
                        roots.add(it);
                    }
                    EList _typedef = block.getTypedef();
                    for (DataType it_1 : _typedef) {
                        if (!(it_1 instanceof EnumerationType)) continue;
                        roots.add((EnumerationType)it_1);
                    }
                    EList _machine = block.getMachine();
                    EList _instance = block.getInstance();
                    Iterable _plus = Iterables.concat((Iterable)_machine, (Iterable)_instance);
                    EList _behavior = block.getBehavior();
                    Iterable _plus_1 = Iterables.concat((Iterable)_plus, (Iterable)_behavior);
                    Iterables.addAll((Collection)roots, (Iterable)_plus_1);
                    break;
                }
                case VARIABLE: {
                    EList _property_1 = block.getProperty();
                    for (PropertyDefinition it_2 : _property_1) {
                        boolean _isStructured_1 = this._formalMLTypeProvider.isStructured(it_2.getType());
                        if (!_isStructured_1) continue;
                        roots.add(it_2);
                    }
                    break;
                }
                case INSTANCE: {
                    EList _instance_1 = block.getInstance();
                    Iterable<? extends PropertyDefinition> _selectProperty = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    Iterable _plus_2 = Iterables.concat((Iterable)_instance_1, _selectProperty);
                    Iterables.addAll((Collection)roots, (Iterable)_plus_2);
                    break;
                }
                case MACHINE: {
                    EList _machine_1 = block.getMachine();
                    EList _instance_2 = block.getInstance();
                    Iterable _plus_3 = Iterables.concat((Iterable)_machine_1, (Iterable)_instance_2);
                    EList _behavior_1 = block.getBehavior();
                    Iterable _plus_4 = Iterables.concat((Iterable)_plus_3, (Iterable)_behavior_1);
                    Iterable<? extends PropertyDefinition> _selectProperty_1 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    Iterable _plus_5 = Iterables.concat((Iterable)_plus_4, _selectProperty_1);
                    Iterables.addAll((Collection)roots, (Iterable)_plus_5);
                    break;
                }
                case MODEL: {
                    EList _machine_2 = block.getMachine();
                    EList _behavior_2 = block.getBehavior();
                    Iterable _plus_6 = Iterables.concat((Iterable)_machine_2, (Iterable)_behavior_2);
                    Iterables.addAll((Collection)roots, (Iterable)_plus_6);
                    break;
                }
            }
        }
        _xblockexpression = roots;
        return _xblockexpression;
    }

    public Iterable<? extends NamedElement> selectLeftElements(Behavior block, ValueElementSpecificationScheme expected) {
        Object _switchResult = null;
        if (expected != null) {
            switch (expected) {
                case ANY: {
                    EList _property = block.getProperty();
                    EList _parameter = block.getParameter();
                    Iterable _plus = Iterables.concat((Iterable)_property, (Iterable)_parameter);
                    EList _channel = block.getChannel();
                    Iterable _plus_1 = Iterables.concat((Iterable)_plus, (Iterable)_channel);
                    EList _buffer = block.getBuffer();
                    Iterable _plus_2 = Iterables.concat((Iterable)_plus_1, (Iterable)_buffer);
                    EList _port = block.getPort();
                    Iterable _plus_3 = Iterables.concat((Iterable)_plus_2, (Iterable)_port);
                    EList _signal = block.getSignal();
                    Iterable _plus_4 = Iterables.concat((Iterable)_plus_3, (Iterable)_signal);
                    EList _machine = block.getMachine();
                    Iterable _plus_5 = Iterables.concat((Iterable)_plus_4, (Iterable)_machine);
                    EList _instance = block.getInstance();
                    Iterable _plus_6 = Iterables.concat((Iterable)_plus_5, (Iterable)_instance);
                    EList _behavior = block.getBehavior();
                    Iterable _plus_7 = Iterables.concat((Iterable)_plus_6, (Iterable)_behavior);
                    EList _routine = block.getRoutine();
                    Iterable _plus_8 = Iterables.concat((Iterable)_plus_7, (Iterable)_routine);
                    EList _procedure = block.getProcedure();
                    Iterable _plus_9 = Iterables.concat((Iterable)_plus_8, (Iterable)_procedure);
                    EList _typedef = block.getTypedef();
                    _switchResult = Iterables.concat((Iterable)_plus_9, (Iterable)_typedef);
                    break;
                }
                case VARIABLE: {
                    EList _property_1 = block.getProperty();
                    EList _parameter_1 = block.getParameter();
                    _switchResult = Iterables.concat((Iterable)_property_1, (Iterable)_parameter_1);
                    break;
                }
                case TYPEDEF: {
                    _switchResult = block.getTypedef();
                    break;
                }
                case PORT: {
                    _switchResult = block.getPort();
                    break;
                }
                case SIGNAL: {
                    _switchResult = block.getSignal();
                    break;
                }
                case MESSAGE: {
                    EList _port_1 = block.getPort();
                    EList _signal_1 = block.getSignal();
                    _switchResult = Iterables.concat((Iterable)_port_1, (Iterable)_signal_1);
                    break;
                }
                case COM_POINT: {
                    EList _port_2 = block.getPort();
                    EList _signal_2 = block.getSignal();
                    _switchResult = Iterables.concat((Iterable)_port_2, (Iterable)_signal_2);
                    break;
                }
                case INSTANCE: {
                    _switchResult = block.getInstance();
                    break;
                }
                case MACHINE: {
                    EList _machine_1 = block.getMachine();
                    EList _instance_1 = block.getInstance();
                    Iterable _plus_10 = Iterables.concat((Iterable)_machine_1, (Iterable)_instance_1);
                    EList _behavior_1 = block.getBehavior();
                    _switchResult = Iterables.concat((Iterable)_plus_10, (Iterable)_behavior_1);
                    break;
                }
                case MODEL: {
                    EList _machine_2 = block.getMachine();
                    EList _behavior_2 = block.getBehavior();
                    _switchResult = Iterables.concat((Iterable)_machine_2, (Iterable)_behavior_2);
                    break;
                }
                case BUFFER: {
                    _switchResult = block.getBuffer();
                    break;
                }
                case CHANNEL: {
                    _switchResult = block.getChannel();
                    break;
                }
                case VERTEX: {
                    _switchResult = null;
                    break;
                }
                case PROCEDURE: {
                    _switchResult = block.getProcedure();
                    break;
                }
                case ROUTINE: {
                    _switchResult = block.getRoutine();
                    break;
                }
            }
        }
        return _switchResult;
    }

    public Iterable<? extends NamedElement> selectRigthElements(Behavior block, ValueElementSpecificationScheme expected) {
        Object _switchResult = null;
        if (expected != null) {
            switch (expected) {
                case ANY: {
                    EList _property = block.getProperty();
                    EList _parameter = block.getParameter();
                    Iterable _plus = Iterables.concat((Iterable)_property, (Iterable)_parameter);
                    ArrayList<EnumerationLiteral> _enumLiterals = this.enumLiterals((Machine)block);
                    Iterable _plus_1 = Iterables.concat((Iterable)_plus, _enumLiterals);
                    EList _channel = block.getChannel();
                    Iterable _plus_2 = Iterables.concat((Iterable)_plus_1, (Iterable)_channel);
                    EList _buffer = block.getBuffer();
                    Iterable _plus_3 = Iterables.concat((Iterable)_plus_2, (Iterable)_buffer);
                    EList _port = block.getPort();
                    Iterable _plus_4 = Iterables.concat((Iterable)_plus_3, (Iterable)_port);
                    EList _signal = block.getSignal();
                    Iterable _plus_5 = Iterables.concat((Iterable)_plus_4, (Iterable)_signal);
                    EList _machine = block.getMachine();
                    Iterable _plus_6 = Iterables.concat((Iterable)_plus_5, (Iterable)_machine);
                    EList _instance = block.getInstance();
                    Iterable _plus_7 = Iterables.concat((Iterable)_plus_6, (Iterable)_instance);
                    EList _behavior = block.getBehavior();
                    Iterable _plus_8 = Iterables.concat((Iterable)_plus_7, (Iterable)_behavior);
                    EList _routine = block.getRoutine();
                    Iterable _plus_9 = Iterables.concat((Iterable)_plus_8, (Iterable)_routine);
                    EList _procedure = block.getProcedure();
                    Iterable _plus_10 = Iterables.concat((Iterable)_plus_9, (Iterable)_procedure);
                    EList _typedef = block.getTypedef();
                    _switchResult = Iterables.concat((Iterable)_plus_10, (Iterable)_typedef);
                    break;
                }
                case VARIABLE: {
                    EList _property_1 = block.getProperty();
                    EList _parameter_1 = block.getParameter();
                    _switchResult = Iterables.concat((Iterable)_property_1, (Iterable)_parameter_1);
                    break;
                }
                case TYPEDEF: {
                    _switchResult = block.getTypedef();
                    break;
                }
                case PORT: {
                    EList _port_1 = block.getPort();
                    Iterable<? extends PropertyDefinition> _selectProperty = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    Iterable _plus_11 = Iterables.concat((Iterable)_port_1, _selectProperty);
                    Iterable<? extends PropertyDefinition> _selectProperty_1 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getParameter(), expected);
                    _switchResult = Iterables.concat((Iterable)_plus_11, _selectProperty_1);
                    break;
                }
                case SIGNAL: {
                    EList _signal_1 = block.getSignal();
                    Iterable<? extends PropertyDefinition> _selectProperty_2 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    Iterable _plus_12 = Iterables.concat((Iterable)_signal_1, _selectProperty_2);
                    Iterable<? extends PropertyDefinition> _selectProperty_3 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getParameter(), expected);
                    _switchResult = Iterables.concat((Iterable)_plus_12, _selectProperty_3);
                    break;
                }
                case MESSAGE: {
                    EList _port_2 = block.getPort();
                    EList _signal_2 = block.getSignal();
                    Iterable _plus_13 = Iterables.concat((Iterable)_port_2, (Iterable)_signal_2);
                    Iterable<? extends PropertyDefinition> _selectProperty_4 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    Iterable _plus_14 = Iterables.concat((Iterable)_plus_13, _selectProperty_4);
                    Iterable<? extends PropertyDefinition> _selectProperty_5 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getParameter(), expected);
                    _switchResult = Iterables.concat((Iterable)_plus_14, _selectProperty_5);
                    break;
                }
                case COM_POINT: {
                    EList _port_3 = block.getPort();
                    EList _signal_3 = block.getSignal();
                    Iterable _plus_15 = Iterables.concat((Iterable)_port_3, (Iterable)_signal_3);
                    Iterable<? extends PropertyDefinition> _selectProperty_6 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    Iterable _plus_16 = Iterables.concat((Iterable)_plus_15, _selectProperty_6);
                    Iterable<? extends PropertyDefinition> _selectProperty_7 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getParameter(), expected);
                    _switchResult = Iterables.concat((Iterable)_plus_16, _selectProperty_7);
                    break;
                }
                case INSTANCE: {
                    EList _instance_1 = block.getInstance();
                    Iterable<? extends PropertyDefinition> _selectProperty_8 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    Iterable _plus_17 = Iterables.concat((Iterable)_instance_1, _selectProperty_8);
                    Iterable<? extends PropertyDefinition> _selectProperty_9 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getParameter(), expected);
                    _switchResult = Iterables.concat((Iterable)_plus_17, _selectProperty_9);
                    break;
                }
                case MACHINE: {
                    EList _machine_1 = block.getMachine();
                    EList _instance_2 = block.getInstance();
                    Iterable _plus_18 = Iterables.concat((Iterable)_machine_1, (Iterable)_instance_2);
                    EList _behavior_1 = block.getBehavior();
                    Iterable _plus_19 = Iterables.concat((Iterable)_plus_18, (Iterable)_behavior_1);
                    Iterable<? extends PropertyDefinition> _selectProperty_10 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    Iterable _plus_20 = Iterables.concat((Iterable)_plus_19, _selectProperty_10);
                    Iterable<? extends PropertyDefinition> _selectProperty_11 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getParameter(), expected);
                    _switchResult = Iterables.concat((Iterable)_plus_20, _selectProperty_11);
                    break;
                }
                case MODEL: {
                    EList _machine_2 = block.getMachine();
                    EList _behavior_2 = block.getBehavior();
                    _switchResult = Iterables.concat((Iterable)_machine_2, (Iterable)_behavior_2);
                    break;
                }
                case BUFFER: {
                    EList _buffer_1 = block.getBuffer();
                    Iterable<? extends PropertyDefinition> _selectProperty_12 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    Iterable _plus_21 = Iterables.concat((Iterable)_buffer_1, _selectProperty_12);
                    Iterable<? extends PropertyDefinition> _selectProperty_13 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getParameter(), expected);
                    _switchResult = Iterables.concat((Iterable)_plus_21, _selectProperty_13);
                    break;
                }
                case CHANNEL: {
                    EList _channel_1 = block.getChannel();
                    Iterable<? extends PropertyDefinition> _selectProperty_14 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    Iterable _plus_22 = Iterables.concat((Iterable)_channel_1, _selectProperty_14);
                    Iterable<? extends PropertyDefinition> _selectProperty_15 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getParameter(), expected);
                    _switchResult = Iterables.concat((Iterable)_plus_22, _selectProperty_15);
                    break;
                }
                case VERTEX: {
                    Iterable<? extends PropertyDefinition> _selectProperty_16 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getProperty(), expected);
                    Iterable<? extends PropertyDefinition> _selectProperty_17 = this.selectProperty((Iterable<? extends PropertyDefinition>)block.getParameter(), expected);
                    _switchResult = Iterables.concat(_selectProperty_16, _selectProperty_17);
                    break;
                }
                case PROCEDURE: {
                    _switchResult = block.getProcedure();
                    break;
                }
                case ROUTINE: {
                    _switchResult = block.getRoutine();
                    break;
                }
            }
        }
        return _switchResult;
    }

    public Iterable<? extends PropertyDefinition> selectProperty(Iterable<? extends PropertyDefinition> properties, ValueElementSpecificationScheme expected) {
        ArrayList _switchResult = null;
        if (expected != null) {
            switch (expected) {
                case ANY: {
                    _switchResult = properties;
                    break;
                }
                case VARIABLE: {
                    _switchResult = properties;
                    break;
                }
                default: {
                    ArrayList _xblockexpression = null;
                    ArrayList selection = CollectionLiterals.newArrayList((Object[])new PropertyDefinition[0]);
                    block26: for (PropertyDefinition it : properties) {
                        Type type = this._formalMLTypeProvider.typeSpecifier(it.getType());
                        if (!(type instanceof PrimitiveInstanceType) || expected == null) continue;
                        switch (expected) {
                            case PORT: {
                                PrimitiveInstanceKind _expected = ((PrimitiveInstanceType)type).getExpected();
                                boolean _equals = Objects.equal((Object)_expected, (Object)PrimitiveInstanceKind.PORT);
                                if (!_equals) break;
                                selection.add(it);
                                break;
                            }
                            case SIGNAL: {
                                PrimitiveInstanceKind _expected_1 = ((PrimitiveInstanceType)type).getExpected();
                                boolean _equals_1 = Objects.equal((Object)_expected_1, (Object)PrimitiveInstanceKind.SIGNAL);
                                if (!_equals_1) break;
                                selection.add(it);
                                break;
                            }
                            case MESSAGE: {
                                PrimitiveInstanceKind _expected_2 = ((PrimitiveInstanceType)type).getExpected();
                                boolean _equals_2 = Objects.equal((Object)_expected_2, (Object)PrimitiveInstanceKind.MESSAGE);
                                if (!_equals_2) break;
                                selection.add(it);
                                break;
                            }
                            case COM_POINT: {
                                if (!Objects.equal((Object)((PrimitiveInstanceType)type).getExpected(), (Object)PrimitiveInstanceKind.PORT) && !Objects.equal((Object)((PrimitiveInstanceType)type).getExpected(), (Object)PrimitiveInstanceKind.SIGNAL) && !Objects.equal((Object)((PrimitiveInstanceType)type).getExpected(), (Object)PrimitiveInstanceKind.COM_POINT)) continue block26;
                                selection.add(it);
                                break;
                            }
                            case INSTANCE: {
                                PrimitiveInstanceKind _expected_3 = ((PrimitiveInstanceType)type).getExpected();
                                boolean _equals_3 = Objects.equal((Object)_expected_3, (Object)PrimitiveInstanceKind.MACHINE);
                                if (!_equals_3) break;
                                selection.add(it);
                                break;
                            }
                            case MACHINE: {
                                PrimitiveInstanceKind _expected_4 = ((PrimitiveInstanceType)type).getExpected();
                                boolean _equals_4 = Objects.equal((Object)_expected_4, (Object)PrimitiveInstanceKind.MACHINE);
                                if (!_equals_4) break;
                                selection.add(it);
                                break;
                            }
                            case BUFFER: {
                                PrimitiveInstanceKind _expected_5 = ((PrimitiveInstanceType)type).getExpected();
                                boolean _equals_5 = Objects.equal((Object)_expected_5, (Object)PrimitiveInstanceKind.BUFFER);
                                if (!_equals_5) break;
                                selection.add(it);
                                break;
                            }
                            case CHANNEL: {
                                PrimitiveInstanceKind _expected_6 = ((PrimitiveInstanceType)type).getExpected();
                                boolean _equals_6 = Objects.equal((Object)_expected_6, (Object)PrimitiveInstanceKind.CHANNEL);
                                if (!_equals_6) break;
                                selection.add(it);
                                break;
                            }
                            case VERTEX: {
                                PrimitiveInstanceKind _expected_7 = ((PrimitiveInstanceType)type).getExpected();
                                boolean _equals_7 = Objects.equal((Object)_expected_7, (Object)PrimitiveInstanceKind.VERTEX);
                                if (!_equals_7) break;
                                selection.add(it);
                                break;
                            }
                        }
                    }
                    _switchResult = _xblockexpression = selection;
                    break;
                }
            }
        } else {
            ArrayList _xblockexpression = null;
            ArrayList selection = CollectionLiterals.newArrayList((Object[])new PropertyDefinition[0]);
            block27: for (PropertyDefinition it : properties) {
                Type type = this._formalMLTypeProvider.typeSpecifier(it.getType());
                if (!(type instanceof PrimitiveInstanceType) || expected == null) continue;
                switch (expected) {
                    case PORT: {
                        PrimitiveInstanceKind _expected = ((PrimitiveInstanceType)type).getExpected();
                        boolean _equals = Objects.equal((Object)_expected, (Object)PrimitiveInstanceKind.PORT);
                        if (!_equals) break;
                        selection.add(it);
                        break;
                    }
                    case SIGNAL: {
                        PrimitiveInstanceKind _expected_1 = ((PrimitiveInstanceType)type).getExpected();
                        boolean _equals_1 = Objects.equal((Object)_expected_1, (Object)PrimitiveInstanceKind.SIGNAL);
                        if (!_equals_1) break;
                        selection.add(it);
                        break;
                    }
                    case MESSAGE: {
                        PrimitiveInstanceKind _expected_2 = ((PrimitiveInstanceType)type).getExpected();
                        boolean _equals_2 = Objects.equal((Object)_expected_2, (Object)PrimitiveInstanceKind.MESSAGE);
                        if (!_equals_2) break;
                        selection.add(it);
                        break;
                    }
                    case COM_POINT: {
                        if (!Objects.equal((Object)((PrimitiveInstanceType)type).getExpected(), (Object)PrimitiveInstanceKind.PORT) && !Objects.equal((Object)((PrimitiveInstanceType)type).getExpected(), (Object)PrimitiveInstanceKind.SIGNAL) && !Objects.equal((Object)((PrimitiveInstanceType)type).getExpected(), (Object)PrimitiveInstanceKind.COM_POINT)) continue block27;
                        selection.add(it);
                        break;
                    }
                    case INSTANCE: {
                        PrimitiveInstanceKind _expected_3 = ((PrimitiveInstanceType)type).getExpected();
                        boolean _equals_3 = Objects.equal((Object)_expected_3, (Object)PrimitiveInstanceKind.MACHINE);
                        if (!_equals_3) break;
                        selection.add(it);
                        break;
                    }
                    case MACHINE: {
                        PrimitiveInstanceKind _expected_4 = ((PrimitiveInstanceType)type).getExpected();
                        boolean _equals_4 = Objects.equal((Object)_expected_4, (Object)PrimitiveInstanceKind.MACHINE);
                        if (!_equals_4) break;
                        selection.add(it);
                        break;
                    }
                    case BUFFER: {
                        PrimitiveInstanceKind _expected_5 = ((PrimitiveInstanceType)type).getExpected();
                        boolean _equals_5 = Objects.equal((Object)_expected_5, (Object)PrimitiveInstanceKind.BUFFER);
                        if (!_equals_5) break;
                        selection.add(it);
                        break;
                    }
                    case CHANNEL: {
                        PrimitiveInstanceKind _expected_6 = ((PrimitiveInstanceType)type).getExpected();
                        boolean _equals_6 = Objects.equal((Object)_expected_6, (Object)PrimitiveInstanceKind.CHANNEL);
                        if (!_equals_6) break;
                        selection.add(it);
                        break;
                    }
                    case VERTEX: {
                        PrimitiveInstanceKind _expected_7 = ((PrimitiveInstanceType)type).getExpected();
                        boolean _equals_7 = Objects.equal((Object)_expected_7, (Object)PrimitiveInstanceKind.VERTEX);
                        if (!_equals_7) break;
                        selection.add(it);
                        break;
                    }
                }
            }
            _switchResult = _xblockexpression = selection;
        }
        return _switchResult;
    }

    public Iterable<? extends NamedElement> selectLeftElements(Routine routine, ValueElementSpecificationScheme expected) {
        Iterable _switchResult = null;
        if (expected != null) {
            switch (expected) {
                case ANY: {
                    ParameterSet _codomain;
                    boolean _tripleNotEquals_1;
                    boolean _tripleNotEquals;
                    EList _xblockexpression = null;
                    EList lvalue = routine.getParameter();
                    ParameterSet _domain = routine.getDomain();
                    boolean bl = _tripleNotEquals = _domain != null;
                    if (_tripleNotEquals) {
                        EList _parameter = routine.getDomain().getParameter();
                        Iterables.addAll((Collection)lvalue, (Iterable)_parameter);
                    }
                    boolean bl2 = _tripleNotEquals_1 = (_codomain = routine.getCodomain()) != null;
                    if (_tripleNotEquals_1) {
                        EList _parameter_1 = routine.getCodomain().getParameter();
                        Iterables.addAll((Collection)lvalue, (Iterable)_parameter_1);
                    }
                    _xblockexpression = lvalue;
                    _switchResult = _xblockexpression;
                    break;
                }
                case VARIABLE: {
                    ParameterSet _codomain;
                    boolean _tripleNotEquals_1;
                    boolean _tripleNotEquals;
                    EList _xblockexpression_1 = null;
                    EList lvalue = routine.getParameter();
                    ParameterSet _domain = routine.getDomain();
                    boolean bl = _tripleNotEquals = _domain != null;
                    if (_tripleNotEquals) {
                        EList _parameter = routine.getDomain().getParameter();
                        Iterables.addAll((Collection)lvalue, (Iterable)_parameter);
                    }
                    boolean bl3 = _tripleNotEquals_1 = (_codomain = routine.getCodomain()) != null;
                    if (_tripleNotEquals_1) {
                        EList _parameter_1 = routine.getCodomain().getParameter();
                        Iterables.addAll((Collection)lvalue, (Iterable)_parameter_1);
                    }
                    _xblockexpression_1 = lvalue;
                    _switchResult = _xblockexpression_1;
                    break;
                }
                case MACHINE: {
                    Iterable lvalue;
                    Iterable _xblockexpression_2 = null;
                    Machine thisMachine = (Machine)EcoreUtil2.getContainerOfType((EObject)routine, Machine.class);
                    EList _machine = thisMachine.getMachine();
                    EList _instance = thisMachine.getInstance();
                    _switchResult = _xblockexpression_2 = (lvalue = Iterables.concat((Iterable)_machine, (Iterable)_instance));
                    break;
                }
                default: {
                    ParameterSet _codomain;
                    boolean _tripleNotEquals_1;
                    boolean _tripleNotEquals;
                    Iterable _xblockexpression_3 = null;
                    Iterable lvalue = this.selectProperty((Iterable<? extends PropertyDefinition>)routine.getParameter(), expected);
                    ParameterSet _domain = routine.getDomain();
                    boolean bl = _tripleNotEquals = _domain != null;
                    if (_tripleNotEquals) {
                        Iterable _plus;
                        Iterable<? extends PropertyDefinition> _selectProperty = this.selectProperty((Iterable<? extends PropertyDefinition>)routine.getDomain().getParameter(), expected);
                        lvalue = _plus = Iterables.concat(lvalue, _selectProperty);
                    }
                    boolean bl4 = _tripleNotEquals_1 = (_codomain = routine.getCodomain()) != null;
                    if (_tripleNotEquals_1) {
                        Iterable _plus_1;
                        Iterable<? extends PropertyDefinition> _selectProperty_1 = this.selectProperty((Iterable<? extends PropertyDefinition>)routine.getCodomain().getParameter(), expected);
                        lvalue = _plus_1 = Iterables.concat((Iterable)lvalue, _selectProperty_1);
                    }
                    _switchResult = _xblockexpression_3 = lvalue;
                    break;
                }
            }
        } else {
            ParameterSet _codomain;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            Iterable _xblockexpression_3 = null;
            Iterable lvalue = this.selectProperty((Iterable<? extends PropertyDefinition>)routine.getParameter(), expected);
            ParameterSet _domain = routine.getDomain();
            boolean bl = _tripleNotEquals = _domain != null;
            if (_tripleNotEquals) {
                Iterable _plus;
                Iterable<? extends PropertyDefinition> _selectProperty = this.selectProperty((Iterable<? extends PropertyDefinition>)routine.getDomain().getParameter(), expected);
                lvalue = _plus = Iterables.concat(lvalue, _selectProperty);
            }
            boolean bl5 = _tripleNotEquals_1 = (_codomain = routine.getCodomain()) != null;
            if (_tripleNotEquals_1) {
                Iterable _plus_1;
                Iterable<? extends PropertyDefinition> _selectProperty_1 = this.selectProperty((Iterable<? extends PropertyDefinition>)routine.getCodomain().getParameter(), expected);
                lvalue = _plus_1 = Iterables.concat((Iterable)lvalue, _selectProperty_1);
            }
            _switchResult = _xblockexpression_3 = lvalue;
        }
        return _switchResult;
    }

    public Iterable<? extends PropertyDefinition> selectRigthElements(Routine routine, ValueElementSpecificationScheme expected) {
        ParameterSet _codomain;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        Iterable _xblockexpression = null;
        Iterable properties = this.selectProperty((Iterable<? extends PropertyDefinition>)routine.getParameter(), expected);
        ParameterSet _domain = routine.getDomain();
        boolean bl = _tripleNotEquals = _domain != null;
        if (_tripleNotEquals) {
            Iterable _plus;
            Iterable<? extends PropertyDefinition> _selectProperty = this.selectProperty((Iterable<? extends PropertyDefinition>)routine.getDomain().getParameter(), expected);
            properties = _plus = Iterables.concat(properties, _selectProperty);
        }
        boolean bl2 = _tripleNotEquals_1 = (_codomain = routine.getCodomain()) != null;
        if (_tripleNotEquals_1) {
            Iterable _plus_1;
            Iterable<? extends PropertyDefinition> _selectProperty_1 = this.selectProperty((Iterable<? extends PropertyDefinition>)routine.getCodomain().getParameter(), expected);
            properties = _plus_1 = Iterables.concat((Iterable)properties, _selectProperty_1);
        }
        _xblockexpression = properties;
        return _xblockexpression;
    }

    public ArrayList<PropertyDefinition> selectStructuredElements(Routine routine, ValueElementSpecificationScheme expected) {
        ParameterSet _codomain;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        ArrayList _xblockexpression = null;
        ArrayList roots = CollectionLiterals.newArrayList((Object[])new PropertyDefinition[0]);
        EList _parameter = routine.getParameter();
        for (Parameter it : _parameter) {
            boolean _isStructured = this._formalMLTypeProvider.isStructured(it.getType());
            if (!_isStructured) continue;
            roots.add(it);
        }
        ParameterSet _domain = routine.getDomain();
        boolean bl = _tripleNotEquals = _domain != null;
        if (_tripleNotEquals) {
            EList _parameter_1 = routine.getDomain().getParameter();
            for (Parameter it_1 : _parameter_1) {
                boolean _isStructured_1 = this._formalMLTypeProvider.isStructured(it_1.getType());
                if (!_isStructured_1) continue;
                roots.add(it_1);
            }
        }
        boolean bl2 = _tripleNotEquals_1 = (_codomain = routine.getCodomain()) != null;
        if (_tripleNotEquals_1) {
            EList _parameter_2 = routine.getCodomain().getParameter();
            for (Parameter it_2 : _parameter_2) {
                boolean _isStructured_2 = this._formalMLTypeProvider.isStructured(it_2.getType());
                if (!_isStructured_2) continue;
                roots.add(it_2);
            }
        }
        _xblockexpression = roots;
        return _xblockexpression;
    }

    public IScope scopeForSelfMachineInstance(Machine thisMachine, IScope outer) {
        IScope _xblockexpression = null;
        Machine _xifexpression = null;
        if (thisMachine.getName() == null && thisMachine.eContainer() instanceof Machine) {
            EObject _eContainer = thisMachine.eContainer();
            _xifexpression = (Machine)_eContainer;
        } else {
            _xifexpression = thisMachine;
        }
        Machine selfMachine = _xifexpression;
        _xblockexpression = Scopes.scopeFor((Iterable)selfMachine.getInstance(), (IScope)Scopes.scopeFor((Iterable)selfMachine.getMachine(), (IScope)Scopes.scopeFor((Iterable)selfMachine.getBehavior(), (IScope)outer)));
        return _xblockexpression;
    }

    public IScope scopeForSelfMachineComPoint(Machine thisMachine, ChannelDirection direction) {
        EObject _eContainer;
        Machine selfMachine;
        Behavior _main;
        boolean _equals;
        IScope _xblockexpression = null;
        IScope parentScope = Scopes.scopeFor(this.selectPort((Iterable<Port>)thisMachine.getPort(), direction), (IScope)Scopes.scopeFor(this.selectSignal((Iterable<Signal>)thisMachine.getSignal(), direction), (IScope)IScope.NULLSCOPE));
        if (thisMachine.getName() == null && thisMachine.eContainer() instanceof Machine && (_equals = Objects.equal((Object)(_main = (selfMachine = (Machine)(_eContainer = thisMachine.eContainer())).getMain()), (Object)thisMachine))) {
            parentScope = Scopes.scopeFor(this.selectPort((Iterable<Port>)selfMachine.getPort(), direction), (IScope)Scopes.scopeFor(this.selectSignal((Iterable<Signal>)selfMachine.getSignal(), direction), (IScope)parentScope));
        }
        _xblockexpression = parentScope;
        return _xblockexpression;
    }

    public IScope scopeForThis(LeftHandSideExpression container, LiteralReferenceElement context) {
        IScope _xblockexpression = null;
        LeftHandSideExpression it = container;
        while (it != null) {
            boolean _matched = false;
            if (it instanceof Routine) {
                _matched = true;
                return this.scopeForHierarchicLeftElement((Routine)it, ValueElementSpecificationScheme.VARIABLE);
            }
            if (!_matched && it instanceof Machine) {
                _matched = true;
                return this.scopeForHierarchicLeftElement((Machine)it, ValueElementSpecificationScheme.VARIABLE);
            }
            it = it.eContainer();
        }
        _xblockexpression = IScope.NULLSCOPE;
        return _xblockexpression;
    }

    public IScope scopeForThis(InputComStatement container, LiteralReferenceElement context) {
        ExpressionAsMachine _target;
        Channel _route;
        IScope _switchResult = null;
        boolean _matched = false;
        NamedElement _port = container.getPort();
        if (Objects.equal((Object)context, (Object)_port)) {
            _matched = true;
            _switchResult = this.scopeForHierarchicRigthElement((EObject)container, ValueElementSpecificationScheme.COM_POINT);
        }
        if (!_matched && Objects.equal((Object)context, (Object)(_route = container.getRoute()))) {
            _matched = true;
            _switchResult = this.scopeForHierarchicRigthElement((EObject)container, ValueElementSpecificationScheme.CHANNEL);
        }
        if (!_matched && Objects.equal((Object)context, (Object)(_target = container.getTarget()))) {
            _matched = true;
            _switchResult = this.scopeForHierarchicRigthElement((EObject)container, ValueElementSpecificationScheme.MACHINE);
        }
        if (!_matched) {
            _switchResult = this.scopeForHierarchicLeftElement((EObject)container, ValueElementSpecificationScheme.VARIABLE);
        }
        return _switchResult;
    }

    public IScope scopeForThis(OutputComStatement container, LiteralReferenceElement context) {
        ExpressionAsMachine _target;
        Channel _route;
        IScope _switchResult = null;
        boolean _matched = false;
        NamedElement _port = container.getPort();
        if (Objects.equal((Object)context, (Object)_port)) {
            _matched = true;
            _switchResult = this.scopeForHierarchicRigthElement((EObject)container, ValueElementSpecificationScheme.COM_POINT);
        }
        if (!_matched && Objects.equal((Object)context, (Object)(_route = container.getRoute()))) {
            _matched = true;
            _switchResult = this.scopeForHierarchicRigthElement((EObject)container, ValueElementSpecificationScheme.CHANNEL);
        }
        if (!_matched && Objects.equal((Object)context, (Object)(_target = container.getTarget()))) {
            _matched = true;
            _switchResult = this.scopeForHierarchicRigthElement((EObject)container, ValueElementSpecificationScheme.MACHINE);
        }
        if (!_matched) {
            _switchResult = this.scopeForHierarchicRigthElement((EObject)container, ValueElementSpecificationScheme.ANY);
        }
        return _switchResult;
    }

    public IScope scopeForThis(ActivityStatement container, LiteralReferenceElement context) {
        IScope _xifexpression = null;
        Expression _machine = container.getMachine();
        boolean _equals = Objects.equal((Object)context, (Object)_machine);
        _xifexpression = _equals ? this.scopeForHierarchicLeftElement((EObject)container, ValueElementSpecificationScheme.MACHINE) : this.scopeForHierarchicLeftElement((EObject)container, ValueElementSpecificationScheme.ANY);
        return _xifexpression;
    }

    public IScope scopeForThis(Transition container, LiteralReferenceElement context) {
        IScope _xblockexpression = null;
        Region thisRegion = (Region)EcoreUtil2.getContainerOfType((EObject)container, Region.class);
        IScope _xifexpression = null;
        NamedElement _target = container.getTarget();
        boolean _equals = Objects.equal((Object)context, (Object)_target);
        if (_equals) {
            _xifexpression = this.scopeForRigthElement(thisRegion, ValueElementSpecificationScheme.VERTEX);
        } else {
            IScope _xblockexpression_1 = null;
            Machine thisMachine = (Machine)EcoreUtil2.getContainerOfType((EObject)thisRegion, Machine.class);
            _xifexpression = _xblockexpression_1 = this.scopeForHierarchicRigthElement(thisMachine, ValueElementSpecificationScheme.ANY);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public IScope scopeForThis(ComPoint container, LiteralReferenceElement context) {
        IScope _xblockexpression = null;
        Machine thisMachine = (Machine)EcoreUtil2.getContainerOfType((EObject)container, Machine.class);
        _xblockexpression = this.scopeForHierarchicLeftElement(thisMachine, ValueElementSpecificationScheme.COM_POINT);
        return _xblockexpression;
    }

    public IScope scopeForThis(DataTypeReference thisType, LiteralReferenceElement context) {
        IScope _xblockexpression = null;
        Machine thisMachine = (Machine)EcoreUtil2.getContainerOfType((EObject)thisType, Machine.class);
        IScope _xifexpression = null;
        Expression _multiplicity = thisType.getMultiplicity();
        boolean _equals = Objects.equal((Object)_multiplicity, (Object)context);
        _xifexpression = _equals ? this.scopeForHierarchicRigthElement(thisMachine, ValueElementSpecificationScheme.TYPEDEF) : this.scopeForHierarchicRigthElement(thisMachine, ValueElementSpecificationScheme.TYPEDEF);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public IScope scopeForThis(ValueElementSpecification thisElement, LiteralReferenceElement context) {
        IScope _xblockexpression = null;
        LiteralReferenceElement it = context;
        while (it != null) {
            boolean _matched = false;
            if (it instanceof Routine) {
                _matched = true;
                return this.scopeForHierarchicStructuredElement((Routine)it, ValueElementSpecificationScheme.ANY);
            }
            if (!_matched && it instanceof Machine) {
                _matched = true;
                return this.scopeForHierarchicStructuredElement((Machine)it, ValueElementSpecificationScheme.ANY);
            }
            it = it.eContainer();
        }
        _xblockexpression = IScope.NULLSCOPE;
        return _xblockexpression;
    }

    public IScope scopeForThis(TupleExpression thisTuple, LiteralReferenceElement context) {
        return this.scopeForHierarchicRigthElement((EObject)thisTuple, ValueElementSpecificationScheme.ANY);
    }

    public IScope scopeForThis(QuantifiedLogicalExpression thisQExpression, LiteralReferenceElement context) {
        return Scopes.scopeFor((Iterable)thisQExpression.getVariable(), (IScope)this.scopeForHierarchicRigthElement((EObject)thisQExpression, ValueElementSpecificationScheme.VARIABLE));
    }

    public IScope scopeForThis(InvokeExpression thisInvoke, LiteralReferenceElement context) {
        IScope _xifexpression = null;
        if (Objects.equal((Object)context.eContainer(), (Object)thisInvoke) && Objects.equal((Object)context.getKind(), (Object)ValueElementSpecificationKind.PARAMETER)) {
            IScope _xifexpression_1 = null;
            boolean _isCallProcedure = thisInvoke.isCallProcedure();
            _xifexpression_1 = _isCallProcedure ? this.scopeForHierarchicRigthElement((EObject)thisInvoke, ValueElementSpecificationScheme.PROCEDURE) : this.scopeForHierarchicRigthElement((EObject)thisInvoke, ValueElementSpecificationScheme.ROUTINE);
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = this.scopeForHierarchicRigthElement((EObject)thisInvoke, ValueElementSpecificationScheme.ANY);
        }
        return _xifexpression;
    }

    public IScope scopeForAnyElement(Routine thisRoutine, LiteralReferenceElement context) {
        return this.scopeForHierarchicRigthElement(thisRoutine, ValueElementSpecificationScheme.ANY);
    }

    public IScope scopeForAnyElement(Machine thisBlock, LiteralReferenceElement context) {
        return this.scopeForHierarchicRigthElement(thisBlock, ValueElementSpecificationScheme.ANY);
    }

    public IScope scopeForAnyModelElement(PrimitiveInstanceType thisType, AbstractElement context) {
        IScope _xblockexpression = null;
        Machine thisMachine = (Machine)EcoreUtil2.getContainerOfType((EObject)thisType, Machine.class);
        IScope _xifexpression = null;
        EObject _eContainer = context.eContainer();
        if (_eContainer instanceof LiteralNullExpression) {
            _xifexpression = this.scopeForHierarchicLeftElement(thisMachine, ValueElementSpecificationScheme.MODEL);
        } else {
            IScope _switchResult = null;
            PrimitiveInstanceKind _expected = thisType.getExpected();
            if (_expected != null) {
                switch (_expected) {
                    case PORT: {
                        _switchResult = this.scopeForHierarchicLeftElement(thisMachine, ValueElementSpecificationScheme.PORT);
                        break;
                    }
                    case SIGNAL: {
                        _switchResult = this.scopeForHierarchicLeftElement(thisMachine, ValueElementSpecificationScheme.SIGNAL);
                        break;
                    }
                    case MESSAGE: {
                        _switchResult = this.scopeForHierarchicLeftElement(thisMachine, ValueElementSpecificationScheme.MESSAGE);
                        break;
                    }
                    case COM_POINT: {
                        _switchResult = this.scopeForHierarchicLeftElement(thisMachine, ValueElementSpecificationScheme.COM_POINT);
                        break;
                    }
                    case MACHINE: {
                        _switchResult = this.scopeForHierarchicLeftElement(thisMachine, ValueElementSpecificationScheme.MODEL);
                        break;
                    }
                    case BUFFER: {
                        _switchResult = this.scopeForHierarchicLeftElement(thisMachine, ValueElementSpecificationScheme.BUFFER);
                        break;
                    }
                    case CHANNEL: {
                        _switchResult = this.scopeForHierarchicLeftElement(thisMachine, ValueElementSpecificationScheme.CHANNEL);
                        break;
                    }
                    case VERTEX: {
                        _switchResult = this.scopeForHierarchicLeftElement(thisMachine, ValueElementSpecificationScheme.VERTEX);
                        break;
                    }
                    default: {
                        _switchResult = this.scopeForHierarchicLeftElement(thisMachine, ValueElementSpecificationScheme.ANY);
                        break;
                    }
                }
            } else {
                _switchResult = this.scopeForHierarchicLeftElement(thisMachine, ValueElementSpecificationScheme.ANY);
            }
            _xifexpression = _switchResult;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public IScope scopeForLeftElement(Region thisRegion, ValueElementSpecificationScheme expected) {
        IScope _xblockexpression = null;
        boolean _equals = Objects.equal((Object)expected, (Object)ValueElementSpecificationScheme.VERTEX);
        if (_equals) {
            Scopes.scopeFor((Iterable)thisRegion.getVertex(), (IScope)IScope.NULLSCOPE);
        }
        _xblockexpression = IScope.NULLSCOPE;
        return _xblockexpression;
    }

    public IScope scopeForRigthElement(Region thisRegion, ValueElementSpecificationScheme expected) {
        IScope _xblockexpression = null;
        boolean _equals = Objects.equal((Object)expected, (Object)ValueElementSpecificationScheme.VERTEX);
        if (_equals) {
            Statemachine thisStatemachine = (Statemachine)EcoreUtil2.getContainerOfType((EObject)thisRegion, Statemachine.class);
            Scopes.scopeFor((Iterable)thisRegion.getVertex(), (IScope)Scopes.scopeFor(this.selectRigthElements((Behavior)thisStatemachine, expected), (IScope)IScope.NULLSCOPE));
        }
        _xblockexpression = IScope.NULLSCOPE;
        return _xblockexpression;
    }

    public IScope scopeForLeftElement(Machine thisMachine, ValueElementSpecificationScheme expected) {
        EObject _eContainer;
        Machine selfMachine;
        Behavior _main;
        boolean _equals;
        IScope _xblockexpression = null;
        IScope parentScope = IScope.NULLSCOPE;
        if (thisMachine.getName() == null && thisMachine.eContainer() instanceof Machine && (_equals = Objects.equal((Object)(_main = (selfMachine = (Machine)(_eContainer = thisMachine.eContainer())).getMain()), (Object)thisMachine))) {
            parentScope = Scopes.scopeFor(this.selectLeftElements(selfMachine, expected), (IScope)parentScope);
        }
        _xblockexpression = Scopes.scopeFor(this.selectLeftElements(thisMachine, expected), (IScope)parentScope);
        return _xblockexpression;
    }

    public IScope scopeForRigthElement(Machine thisMachine, ValueElementSpecificationScheme expected) {
        EObject _eContainer;
        Machine selfMachine;
        Behavior _main;
        boolean _equals;
        IScope _xblockexpression = null;
        IScope parentScope = IScope.NULLSCOPE;
        if (thisMachine.getName() == null && thisMachine.eContainer() instanceof Machine && (_equals = Objects.equal((Object)(_main = (selfMachine = (Machine)(_eContainer = thisMachine.eContainer())).getMain()), (Object)thisMachine))) {
            parentScope = Scopes.scopeFor(this.selectRigthElements(selfMachine, expected), (IScope)parentScope);
        }
        _xblockexpression = Scopes.scopeFor(this.selectRigthElements(thisMachine, expected), (IScope)parentScope);
        return _xblockexpression;
    }

    public IScope scopeForHierarchicLeftElement(Machine thisMachine, ValueElementSpecificationScheme expected) {
        IScope _xblockexpression = null;
        IScope parentScope = IScope.NULLSCOPE;
        List<Machine> _reverseMachineHierarchy = this.reverseMachineHierarchy(thisMachine);
        for (Machine block : _reverseMachineHierarchy) {
            boolean _matched = false;
            if (block instanceof Behavior) {
                _matched = true;
                parentScope = Scopes.scopeFor(this.selectLeftElements((Behavior)block, expected), (IScope)parentScope);
            }
            if (_matched) continue;
            parentScope = Scopes.scopeFor(this.selectLeftElements(block, expected), (IScope)parentScope);
        }
        IScope _switchResult_1 = null;
        boolean _matched_1 = false;
        if (thisMachine instanceof Behavior) {
            _matched_1 = true;
            _switchResult_1 = Scopes.scopeFor(this.selectLeftElements((Behavior)thisMachine, expected), (IScope)parentScope);
        }
        if (!_matched_1) {
            _switchResult_1 = Scopes.scopeFor(this.selectLeftElements(thisMachine, expected), (IScope)parentScope);
        }
        _xblockexpression = _switchResult_1;
        return _xblockexpression;
    }

    public IScope scopeForHierarchicRigthElement(Machine thisMachine, ValueElementSpecificationScheme expected) {
        IScope _xblockexpression = null;
        IScope parentScope = IScope.NULLSCOPE;
        List<Machine> _reverseMachineHierarchy = this.reverseMachineHierarchy(thisMachine);
        for (Machine block : _reverseMachineHierarchy) {
            boolean _matched = false;
            if (block instanceof Behavior) {
                _matched = true;
                parentScope = Scopes.scopeFor(this.selectRigthElements((Behavior)block, expected), (IScope)parentScope);
            }
            if (_matched) continue;
            parentScope = Scopes.scopeFor(this.selectRigthElements(block, expected), (IScope)parentScope);
        }
        IScope _switchResult_1 = null;
        boolean _matched_1 = false;
        if (thisMachine instanceof Behavior) {
            _matched_1 = true;
            _switchResult_1 = Scopes.scopeFor(this.selectRigthElements((Behavior)thisMachine, expected), (IScope)parentScope);
        }
        if (!_matched_1) {
            _switchResult_1 = Scopes.scopeFor(this.selectRigthElements(thisMachine, expected), (IScope)parentScope);
        }
        _xblockexpression = _switchResult_1;
        return _xblockexpression;
    }

    public IScope scopeForHierarchicStructuredElement(Machine thisMachine, ValueElementSpecificationScheme expected) {
        IScope _xblockexpression = null;
        IScope parentScope = IScope.NULLSCOPE;
        List<Machine> _reverseMachineHierarchy = this.reverseMachineHierarchy(thisMachine);
        for (Machine machine : _reverseMachineHierarchy) {
            boolean _matched = false;
            if (machine instanceof Behavior) {
                _matched = true;
                parentScope = Scopes.scopeFor(this.selectStructuredElements(machine, expected), (IScope)parentScope);
            }
            if (_matched) continue;
            parentScope = Scopes.scopeFor(this.selectStructuredElements(machine, expected), (IScope)parentScope);
        }
        IScope _switchResult_1 = null;
        boolean _matched_1 = false;
        if (thisMachine instanceof Behavior) {
            _matched_1 = true;
            _switchResult_1 = Scopes.scopeFor(this.selectStructuredElements(thisMachine, expected), (IScope)parentScope);
        }
        if (!_matched_1) {
            _switchResult_1 = Scopes.scopeFor(this.selectStructuredElements(thisMachine, expected), (IScope)parentScope);
        }
        _xblockexpression = _switchResult_1;
        return _xblockexpression;
    }

    public IScope scopeForHierarchicStructuredElement(Routine thisRoutine, ValueElementSpecificationScheme expected) {
        IScope _xblockexpression = null;
        Machine thisMachine = (Machine)EcoreUtil2.getContainerOfType((EObject)thisRoutine, Machine.class);
        _xblockexpression = Scopes.scopeFor(this.selectStructuredElements(thisRoutine, expected), (IScope)this.scopeForHierarchicStructuredElement(thisMachine, expected));
        return _xblockexpression;
    }

    public IScope scopeForHierarchicLeftElement(Routine thisRoutine, ValueElementSpecificationScheme expected) {
        IScope _xblockexpression = null;
        Machine thisMachine = (Machine)EcoreUtil2.getContainerOfType((EObject)thisRoutine, Machine.class);
        _xblockexpression = Scopes.scopeFor(this.selectLeftElements(thisRoutine, expected), (IScope)this.scopeForHierarchicLeftElement(thisMachine, expected));
        return _xblockexpression;
    }

    public IScope scopeForHierarchicRigthElement(Routine thisRoutine, ValueElementSpecificationScheme expected) {
        IScope _xblockexpression = null;
        Machine thisMachine = (Machine)EcoreUtil2.getContainerOfType((EObject)thisRoutine, Machine.class);
        _xblockexpression = Scopes.scopeFor(this.selectRigthElements(thisRoutine, expected), (IScope)this.scopeForHierarchicRigthElement(thisMachine, expected));
        return _xblockexpression;
    }

    public IScope scopeForHierarchicLeftElement(EObject context, ValueElementSpecificationScheme expected) {
        IScope _xblockexpression = null;
        EObject it = context;
        while (it != null) {
            boolean _matched = false;
            if (it instanceof Routine) {
                _matched = true;
                return this.scopeForHierarchicLeftElement((Routine)it, expected);
            }
            if (!_matched && it instanceof Machine) {
                _matched = true;
                return this.scopeForHierarchicLeftElement((Machine)it, expected);
            }
            it = it.eContainer();
        }
        _xblockexpression = IScope.NULLSCOPE;
        return _xblockexpression;
    }

    public IScope scopeForHierarchicRigthElement(EObject context, ValueElementSpecificationScheme expected) {
        IScope _xblockexpression = null;
        EObject it = context;
        while (it != null) {
            boolean _matched = false;
            if (it instanceof Routine) {
                _matched = true;
                return this.scopeForHierarchicRigthElement((Routine)it, expected);
            }
            if (!_matched && it instanceof Machine) {
                _matched = true;
                return this.scopeForHierarchicRigthElement((Machine)it, expected);
            }
            it = it.eContainer();
        }
        _xblockexpression = IScope.NULLSCOPE;
        return _xblockexpression;
    }
}

