/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.lens;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.Java2DPainter;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.lens.Lens;
import fr.inria.zvtm.lens.TemporalLens;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.swing.SwingUtilities;

public abstract class FixedSizeLens
extends Lens {
    static final int DEFAULT_LR1 = 100;
    static final int DEFAULT_LR2 = 50;
    protected int LR1 = 100;
    protected int LR2 = 50;
    Color r2Color = null;
    Color r1Color = null;
    Robot robot;
    Point ptRobot = new Point();
    SpeedFunction sf;
    int lensX;
    int lensY;
    boolean first = true;
    short speedBehavior = SPEED_DEPENDENT_LINEAR;
    public static short CONSTANT = 0;
    public static short SPEED_DEPENDENT_LINEAR = 1;
    Java2DPainter actualAfterPortalsPainter;
    Java2DPainter paintCursor = new Java2DPainter(){

        @Override
        public void paint(Graphics2D g2d, int viewWidth, int viewHeight) {
            g2d.setColor(Color.BLACK);
            g2d.drawLine(FixedSizeLens.this.lensX - 10, FixedSizeLens.this.lensY, FixedSizeLens.this.lensX + 10, FixedSizeLens.this.lensY);
            g2d.drawLine(FixedSizeLens.this.lensX, FixedSizeLens.this.lensY - 10, FixedSizeLens.this.lensX, FixedSizeLens.this.lensY + 10);
        }
    };
    int lastX = Integer.MAX_VALUE;
    int lastY = Integer.MAX_VALUE;

    public void setOuterRadius(int r) {
        this.LR1 = r;
        this.updateMagBufferWorkingDimensions();
        this.updateLensRegion();
        this.setMagRasterDimensions(this.mbw, this.mbh);
        this.owningView.parent.repaint();
    }

    public void setInnerRadius(int r) {
        this.LR2 = r;
        this.updateMagBufferWorkingDimensions();
        this.updateLensRegion();
        this.setMagRasterDimensions(this.mbw, this.mbh);
        this.owningView.parent.repaint();
    }

    public void setRadii(int outerRadius, int innerRadius) {
        this.setRadii(outerRadius, innerRadius, true);
    }

    public void setRadii(int outerRadius, int innerRadius, boolean forceRaster) {
        this.LR1 = outerRadius;
        this.LR2 = innerRadius;
        this.updateMagBufferWorkingDimensions();
        this.updateLensRegion();
        if (forceRaster) {
            this.setMagRasterDimensions(this.mbw, this.mbh);
        }
        this.owningView.parent.repaint();
    }

    public void setMMandRadii(float mm, int outerRadius, int innerRadius) {
        this.setMMandRadii(mm, outerRadius, innerRadius, true);
    }

    public void setMMandRadii(float mm, int outerRadius, int innerRadius, boolean forceRaster) {
        this.MM = mm;
        this.LR1 = outerRadius;
        this.LR2 = innerRadius;
        this.updateMagBufferWorkingDimensions();
        this.updateLensRegion();
        if (forceRaster) {
            this.setMagRasterDimensions(this.mbw, this.mbh);
        }
        this.owningView.parent.repaint();
    }

    public int getOuterRadius() {
        return this.LR1;
    }

    @Override
    public int getRadius() {
        return this.LR1;
    }

    public int getInnerRadius() {
        return this.LR2;
    }

    public float getActualRingRadius() {
        return this.LR2;
    }

    @Override
    public void setLensBuffer(ViewPanel p) {
        this.owningView = p;
        Dimension s = p.getComponent().getSize();
        this.w = s.width;
        this.h = s.height;
        this.sw = this.w / 2;
        this.sh = this.h / 2;
        this.lurd[0] = this.lx + this.sw - this.getRadius();
        this.lurd[1] = this.ly + this.sh - this.getRadius();
        this.lurd[2] = this.lx + this.sw + this.getRadius();
        this.lurd[3] = this.ly + this.sh + this.getRadius();
        if (this.lurd[0] < 0) {
            this.lurd[0] = 0;
        }
        if (this.lurd[1] < 0) {
            this.lurd[1] = 0;
        }
        if (this.lurd[2] > this.w) {
            this.lurd[2] = this.w;
        }
        if (this.lurd[3] > this.h) {
            this.lurd[3] = this.h;
        }
        this.lensWidth = this.lurd[2] - this.lurd[0];
        this.lensHeight = this.lurd[3] - this.lurd[1];
        BufferedImage tbi = (BufferedImage)p.getComponent().createImage(1, 1);
        this.imageType = tbi.getType();
        this.transferType = tbi.getRaster().getTransferType();
        this.initBuffers(this.lensWidth * this.lensHeight, this.mbw * this.mbh);
    }

    void updateLensRegion() {
        this.lurd[0] = this.lx + this.sw - this.getRadius();
        this.lurd[1] = this.ly + this.sh - this.getRadius();
        this.lurd[2] = this.lx + this.sw + this.getRadius();
        this.lurd[3] = this.ly + this.sh + this.getRadius();
        if (this.lurd[0] < 0) {
            this.lurd[0] = 0;
        }
        if (this.lurd[1] < 0) {
            this.lurd[1] = 0;
        }
        if (this.lurd[2] > this.w) {
            this.lurd[2] = this.w;
        }
        if (this.lurd[3] > this.h) {
            this.lurd[3] = this.h;
        }
        this.lensWidth = this.lurd[2] - this.lurd[0];
        this.lensHeight = this.lurd[3] - this.lurd[1];
    }

    @Override
    void transformI(WritableRaster iwr, WritableRaster ewr) {
        int eox = 0;
        int eoy = 0;
        if (this.ly + this.sh < this.LR1) {
            eoy = Math.round(this.LR1 - (this.ly + this.sh));
        }
        if (this.lx + this.sw < this.LR1) {
            eox = Math.round(this.LR1 - (this.lx + this.sw));
        }
        iwr.getDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.oPixelsI);
        ewr.getDataElements(eox, eoy, this.mbw - eox, this.mbh - eoy, this.mPixelsI);
        for (int x = this.lurd[0]; x < this.lurd[2]; ++x) {
            for (int y = this.lurd[1]; y < this.lurd[3]; ++y) {
                this.gf(x, y, this.gain);
                this.tPixelsI[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])] = this.gain[0] > this.mSwitchThreshold || this.gain[1] > this.mSwitchThreshold ? this.mPixelsI[Math.round(((float)(y - this.lurd[1]) * this.MM - this.hmbh) / this.gain[1] + this.hmbh + (float)this.dy) * (this.mbw - eox) + Math.round(((float)(x - this.lurd[0]) * this.MM - this.hmbw) / this.gain[0] + this.hmbw + (float)this.dx)] : this.oPixelsI[(Math.round(((float)y - (float)this.sh - (float)this.ly) / this.gain[1] + (float)this.sh + (float)this.ly) - this.lurd[1]) * this.lensWidth + (Math.round(((float)x - (float)this.sw - (float)this.lx) / this.gain[0] + (float)this.sw + (float)this.lx) - this.lurd[0])];
            }
        }
        iwr.setDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.tPixelsI);
    }

    @Override
    void transformS(WritableRaster iwr, WritableRaster ewr) {
        int eox = 0;
        int eoy = 0;
        if (this.ly + this.sh < this.LR1) {
            eoy = Math.round(this.LR1 - (this.ly + this.sh));
        }
        if (this.lx + this.sw < this.LR1) {
            eox = Math.round(this.LR1 - (this.lx + this.sw));
        }
        iwr.getDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.oPixelsS);
        ewr.getDataElements(eox, eoy, this.mbw - eox, this.mbh - eoy, this.mPixelsS);
        for (int x = this.lurd[0]; x < this.lurd[2]; ++x) {
            for (int y = this.lurd[1]; y < this.lurd[3]; ++y) {
                this.gf(x, y, this.gain);
                this.tPixelsS[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])] = this.gain[0] > this.mSwitchThreshold || this.gain[1] > this.mSwitchThreshold ? this.mPixelsS[Math.round(((float)(y - this.lurd[1]) * this.MM - this.hmbh) / this.gain[1] + this.hmbh + (float)this.dy) * (this.mbw - eox) + Math.round(((float)(x - this.lurd[0]) * this.MM - this.hmbw) / this.gain[0] + this.hmbw + (float)this.dx)] : this.oPixelsS[(Math.round(((float)y - (float)this.sh - (float)this.ly) / this.gain[1] + (float)this.sh + (float)this.ly) - this.lurd[1]) * this.lensWidth + (Math.round(((float)x - (float)this.sw - (float)this.lx) / this.gain[0] + (float)this.sw + (float)this.lx) - this.lurd[0])];
            }
        }
        iwr.setDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.tPixelsS);
    }

    @Override
    void transformB(WritableRaster iwr, WritableRaster ewr) {
        int eox = 0;
        int eoy = 0;
        if (this.ly + this.sh < this.LR1) {
            eoy = Math.round(this.LR1 - (this.ly + this.sh));
        }
        if (this.lx + this.sw < this.LR1) {
            eox = Math.round(this.LR1 - (this.lx + this.sw));
        }
        iwr.getDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.oPixelsB);
        ewr.getDataElements(eox, eoy, this.mbw - eox, this.mbh - eoy, this.mPixelsB);
        for (int x = this.lurd[0]; x < this.lurd[2]; ++x) {
            for (int y = this.lurd[1]; y < this.lurd[3]; ++y) {
                this.gf(x, y, this.gain);
                this.tPixelsB[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])] = this.gain[0] > this.mSwitchThreshold || this.gain[1] > this.mSwitchThreshold ? this.mPixelsB[Math.round(((float)(y - this.lurd[1]) * this.MM - this.hmbh) / this.gain[1] + this.hmbh + (float)this.dy) * (this.mbw - eox) + Math.round(((float)(x - this.lurd[0]) * this.MM - this.hmbw) / this.gain[0] + this.hmbw + (float)this.dx)] : this.oPixelsB[(Math.round(((float)y - (float)this.sh - (float)this.ly) / this.gain[1] + (float)this.sh + (float)this.ly) - this.lurd[1]) * this.lensWidth + (Math.round(((float)x - (float)this.sw - (float)this.lx) / this.gain[0] + (float)this.sw + (float)this.lx) - this.lurd[0])];
            }
        }
        iwr.setDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.tPixelsB);
    }

    @Override
    public void setAbsolutePosition(int ax, int ay) {
        this.lx = ax - this.sw;
        this.ly = ay - this.sh;
        this.lurd[0] = this.lx + this.sw - this.getRadius();
        this.lurd[1] = this.ly + this.sh - this.getRadius();
        this.lurd[2] = this.lx + this.sw + this.getRadius();
        this.lurd[3] = this.ly + this.sh + this.getRadius();
        if (this.lurd[0] < 0) {
            this.lurd[0] = 0;
        }
        if (this.lurd[1] < 0) {
            this.lurd[1] = 0;
        }
        if (this.lurd[2] > this.w) {
            this.lurd[2] = this.w;
        }
        if (this.lurd[3] > this.h) {
            this.lurd[3] = this.h;
        }
        this.lensWidth = this.lurd[2] - this.lurd[0];
        this.lensHeight = this.lurd[3] - this.lurd[1];
    }

    @Override
    public void setFocusControlled(boolean isFocusControlled, short speedBehavior) {
        this.speedBehavior = speedBehavior;
        this.activateFocusControlled(isFocusControlled, speedBehavior);
    }

    @Override
    public void setFocusControlled(boolean isFocusControlled) {
        this.setFocusControlled(isFocusControlled, this.speedBehavior);
    }

    void activateFocusControlled(boolean isFocusControlled, short speedBehavior) {
        if (isFocusControlled) {
            if (this.robot == null) {
                this.actualAfterPortalsPainter = this.owningView.parent.getJava2DPainter((short)3);
                this.owningView.parent.setJava2DPainter(this.paintCursor, (short)3);
                try {
                    this.robot = new Robot();
                }
                catch (AWTException e) {
                    e.printStackTrace();
                }
            }
            if (speedBehavior == SPEED_DEPENDENT_LINEAR) {
                this.sf = new LSpeedFunction();
            } else if (speedBehavior == CONSTANT) {
                this.sf = new SpeedFunction(){

                    @Override
                    public double getSpeedCoeff(long currentTime, int x, int y) {
                        return 0.0;
                    }
                };
            }
        } else {
            this.setXfocusOffset(0);
            this.setYfocusOffset(0);
            this.owningView.parent.setJava2DPainter(this.actualAfterPortalsPainter, (short)3);
            this.robot = null;
        }
        this.first = false;
        this.owningView.setDrawCursor(!isFocusControlled);
        this.lensX = this.lx + (int)this.owningView.getComponent().getSize().getWidth() / 2;
        this.lensY = this.ly + (int)this.owningView.getComponent().getSize().getHeight() / 2;
        this.owningView.parent.repaint();
    }

    private void doFocusControledOffsets(int deltaX, int deltaY, double magFactor, long currentTime) {
        if (this.robot != null) {
            this.ptRobot.setLocation(this.lensX, this.lensY);
            SwingUtilities.convertPointToScreen(this.ptRobot, this.owningView.getComponent());
            this.robot.mouseMove((int)this.ptRobot.getX(), (int)this.ptRobot.getY());
        }
        if (deltaX % (int)magFactor == this.getXfocusOffset() && deltaY % (int)magFactor == this.getYfocusOffset() && deltaX / (int)magFactor == 0 && deltaY / (int)magFactor == 0) {
            return;
        }
        this.setXfocusOffset(deltaX % (int)magFactor);
        this.setYfocusOffset(deltaY % (int)magFactor);
        if (this instanceof TemporalLens) {
            ((TemporalLens)((Object)this)).setAbsolutePosition(this.lensX, this.lensY, currentTime);
        } else {
            this.setAbsolutePosition(this.lensX, this.lensY);
        }
        this.owningView.parent.repaint();
    }

    @Override
    public void moveLensBy(int dx, int dy, long currentTime) {
        this.lensX = this.lx + (int)this.owningView.getComponent().getSize().getWidth() / 2;
        this.lensY = this.ly + (int)this.owningView.getComponent().getSize().getHeight() / 2;
        if (this.lastX == Integer.MAX_VALUE && this.lastY == Integer.MAX_VALUE) {
            this.lastX = this.lensX;
            this.lastY = this.lensY;
        }
        this.lastX += dx;
        this.lastY += dy;
        if (this.robot != null) {
            int deltaX = this.getXfocusOffset() + dx;
            int deltaY = this.getYfocusOffset() + dy;
            double speed = this.sf.getSpeedCoeff(currentTime, this.lastX, this.lastY);
            double magFactor = 1.0 + (1.0 - speed) * (double)(this.getActualMaximumMagnification() - 1.0f);
            this.lensX += deltaX / (int)magFactor;
            this.lensY += deltaY / (int)magFactor;
            if (magFactor > 1.0) {
                this.doFocusControledOffsets(deltaX, deltaY, magFactor, currentTime);
            } else {
                this.doFocusControledOffsets(deltaX, deltaY, magFactor, currentTime);
            }
        } else {
            this.lensX += dx;
            this.lensY += dy;
            if (this instanceof TemporalLens) {
                ((TemporalLens)((Object)this)).setAbsolutePosition(this.lensX, this.lensY, currentTime);
            } else {
                this.setAbsolutePosition(this.lensX, this.lensY);
            }
            this.owningView.parent.repaint();
        }
    }

    public void setInnerRadiusColor(Color c) {
        this.r2Color = c;
    }

    public void setOuterRadiusColor(Color c) {
        this.r1Color = c;
    }

    public Color getInnerRadiusColor() {
        return this.r2Color;
    }

    public Color getOuterRadiusColor() {
        return this.r1Color;
    }

    @Override
    public void drawBoundary(Graphics2D g2d) {
        if (this.r1Color != null) {
            g2d.setColor(this.r1Color);
            g2d.drawOval(this.lx + this.w / 2 - this.LR1, this.ly + this.h / 2 - this.LR1, 2 * this.LR1, 2 * this.LR1);
        }
        if (this.r2Color != null) {
            g2d.setColor(this.r2Color);
            g2d.drawOval(this.lx + this.w / 2 - this.LR2, this.ly + this.h / 2 - this.LR2, 2 * this.LR2, 2 * this.LR2);
        }
    }

    public long[] getVisibleRegionInFocus(Camera c, long[] res) {
        float uncoef = (float)((c.focal + c.altitude) / c.focal);
        res[0] = (long)(c.vx + (double)(((float)this.lx - (float)this.LR2 / this.MM) * uncoef));
        res[1] = (long)(c.vy + (double)(((float)(-this.ly) + (float)this.LR2 / this.MM) * uncoef));
        res[2] = (long)(c.vx + (double)(((float)this.lx + (float)this.LR2 / this.MM) * uncoef));
        res[3] = (long)(c.vy + (double)(((float)(-this.ly) - (float)this.LR2 / this.MM) * uncoef));
        return res;
    }

    class LSpeedFunction
    implements SpeedFunction {
        static final int NB_SPEED_POINTS = 4;
        static final int MIN_SPEED = 25;
        static final int MAX_SPEED = 400;
        long[] cursor_time = new long[4];
        int[] cursor_x = new int[4];
        int[] cursor_y = new int[4];
        float[] speeds = new float[3];
        float mean_speed = 0.0f;

        public void getSpeed(long currentTime, int x, int y) {
            int i;
            for (i = 1; i < 4; ++i) {
                this.cursor_time[i - 1] = this.cursor_time[i];
                this.cursor_x[i - 1] = this.cursor_x[i];
                this.cursor_y[i - 1] = this.cursor_y[i];
            }
            this.cursor_time[3] = currentTime;
            this.cursor_x[3] = x;
            this.cursor_y[3] = y;
            for (i = 0; i < this.speeds.length; ++i) {
                this.speeds[i] = this.cursor_time[i + 1] != this.cursor_time[i] ? (float)Math.sqrt((this.cursor_x[i + 1] - this.cursor_x[i]) * (this.cursor_x[i + 1] - this.cursor_x[i]) + (this.cursor_y[i + 1] - this.cursor_y[i]) * (this.cursor_y[i + 1] - this.cursor_y[i])) / (float)(this.cursor_time[i + 1] - this.cursor_time[i]) : 0.0f;
            }
            this.mean_speed = 0.0f;
            for (i = 0; i < this.speeds.length; ++i) {
                this.mean_speed += this.speeds[i];
            }
            this.mean_speed = this.mean_speed / (float)this.speeds.length * 1000.0f;
        }

        @Override
        public double getSpeedCoeff(long currentTime, int x, int y) {
            this.getSpeed(currentTime, x, y);
            if (this.mean_speed <= 25.0f) {
                return 0.0;
            }
            if (this.mean_speed >= 400.0f) {
                return 1.0;
            }
            return (this.mean_speed - 25.0f) / 375.0f;
        }
    }

    static interface SpeedFunction {
        public double getSpeedCoeff(long var1, int var3, int var4);
    }
}

