/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.Person;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskGroup;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.actions.ActionFactory;

public class SynchronizeSelectedAction
extends ActionDelegate
implements IViewActionDelegate {
    private IAction action;

    public void run(IAction action) {
        TaskListView taskListView = TaskListView.getFromActivePerspective();
        if (taskListView != null) {
            ISelection selection = taskListView.getViewer().getSelection();
            if (selection.isEmpty()) {
                TasksUiInternal.synchronizeAllRepositories(true);
            } else if (selection instanceof IStructuredSelection) {
                this.synchronizeSelected((IStructuredSelection)selection);
            }
        }
    }

    private void synchronizeSelected(IStructuredSelection selection) {
        LinkedHashMap queriesToSyncMap = new LinkedHashMap();
        LinkedHashMap<AbstractRepositoryConnector, List<ITask>> tasksToSyncMap = new LinkedHashMap<AbstractRepositoryConnector, List<ITask>>();
        for (Object obj : selection.toList()) {
            Object client;
            if (obj instanceof IRepositoryQuery) {
                RepositoryQuery repositoryQuery = (RepositoryQuery)obj;
                AbstractRepositoryConnector client2 = TasksUi.getRepositoryManager().getRepositoryConnector(repositoryQuery.getConnectorKind());
                if (client2 == null) continue;
                Object queriesToSync = (List)queriesToSyncMap.get(client2);
                if (queriesToSync == null) {
                    queriesToSync = new ArrayList();
                    queriesToSyncMap.put(client2, queriesToSync);
                }
                queriesToSync.add((RepositoryQuery)repositoryQuery);
                continue;
            }
            if (obj instanceof TaskCategory) {
                TaskCategory cat = (TaskCategory)obj;
                for (ITask task : cat.getChildren()) {
                    client = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
                    this.addTaskToSync((AbstractRepositoryConnector)client, task, tasksToSyncMap);
                }
                continue;
            }
            if (obj instanceof ITask) {
                AbstractTask repositoryTask = (AbstractTask)obj;
                AbstractRepositoryConnector client2 = TasksUi.getRepositoryManager().getRepositoryConnector(repositoryTask.getConnectorKind());
                this.addTaskToSync(client2, (ITask)repositoryTask, tasksToSyncMap);
                continue;
            }
            if (obj instanceof ScheduledTaskContainer) {
                ScheduledTaskContainer scheduledContainer = (ScheduledTaskContainer)obj;
                for (ITask task : scheduledContainer.getChildren()) {
                    client = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
                    this.addTaskToSync((AbstractRepositoryConnector)client, task, tasksToSyncMap);
                }
                continue;
            }
            if (obj instanceof Person) {
                Person person = (Person)obj;
                for (ITask task : person.getChildren()) {
                    client = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
                    this.addTaskToSync((AbstractRepositoryConnector)client, task, tasksToSyncMap);
                }
                continue;
            }
            if (!(obj instanceof TaskGroup)) continue;
            Iterator<Object> group = (TaskGroup)obj;
            for (ITask task : group.getChildren()) {
                client = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
                this.addTaskToSync((AbstractRepositoryConnector)client, task, tasksToSyncMap);
            }
        }
        if (!queriesToSyncMap.isEmpty()) {
            HashMap<TaskRepository, HashSet<RepositoryQuery>> repositoriesToSync = new HashMap<TaskRepository, HashSet<RepositoryQuery>>();
            for (AbstractRepositoryConnector abstractRepositoryConnector : queriesToSyncMap.keySet()) {
                List queriesToSync = (List)queriesToSyncMap.get(abstractRepositoryConnector);
                if (queriesToSync == null || queriesToSync.isEmpty()) continue;
                for (RepositoryQuery query : queriesToSync) {
                    TaskRepository repos = TasksUi.getRepositoryManager().getRepository(query.getConnectorKind(), query.getRepositoryUrl());
                    if (repos == null) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to synchronize query \"" + query.getUrl() + "\" because Repository is null"));
                        continue;
                    }
                    HashSet<RepositoryQuery> queries = (HashSet<RepositoryQuery>)repositoriesToSync.get(repos);
                    if (queries == null) {
                        queries = new HashSet<RepositoryQuery>();
                        repositoriesToSync.put(repos, queries);
                    }
                    queries.add(query);
                }
            }
            for (Map.Entry entry : repositoriesToSync.entrySet()) {
                TaskRepository repository = (TaskRepository)entry.getKey();
                AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
                Set queries = (Set)entry.getValue();
                TasksUiInternal.synchronizeQueries(connector, repository, queries, null, true);
            }
        }
        if (!tasksToSyncMap.isEmpty()) {
            for (AbstractRepositoryConnector connector : tasksToSyncMap.keySet()) {
                List tasksToSync = (List)tasksToSyncMap.get(connector);
                if (tasksToSync == null || tasksToSync.size() <= 0) continue;
                TasksUiInternal.synchronizeTasks(connector, new HashSet<ITask>(tasksToSync), true, null);
            }
        }
    }

    private void addTaskToSync(AbstractRepositoryConnector connector, ITask task, Map<AbstractRepositoryConnector, List<ITask>> tasksToSyncMap) {
        if (connector == null || task instanceof LocalTask || task.getSynchronizationState() == ITask.SynchronizationState.OUTGOING_NEW) {
            return;
        }
        List<ITask> tasksToSync = tasksToSyncMap.get(connector);
        if (tasksToSync == null) {
            tasksToSync = new ArrayList<ITask>();
            tasksToSyncMap.put(connector, tasksToSync);
        }
        tasksToSync.add(task);
    }

    public void init(IAction action) {
        this.action = action;
    }

    public void init(IViewPart view) {
        IActionBars actionBars = view.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), this.action);
        actionBars.updateActionBars();
    }
}

