/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.parsers.cfg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.cfg.CfgAnalyzer;
import org.eclipse.titan.common.parsers.cfg.CfgDefinitionInformation;
import org.eclipse.titan.common.parsers.cfg.CfgParseResult;
import org.eclipse.titan.common.parsers.cfg.CfgParseTreePrinter;
import org.eclipse.titan.common.path.PathConverter;

public final class ConfigFileHandler {
    private LinkedHashMap<Path, CfgParseResult> originalASTs = new LinkedHashMap();
    private final Map<String, CfgDefinitionInformation> definesMap = new HashMap<String, CfgDefinitionInformation>();
    private final List<Path> processedFiles = new ArrayList<Path>();
    private final List<Path> toBeProcessedFiles = new ArrayList<Path>();
    private int tcpPort = 0;
    private String localAddress = null;
    private double killTimer = 10.0;
    private int numHCs = 0;
    private boolean unixDomainSocket = false;
    private final Map<String, String[]> groups = new HashMap<String, String[]>();
    private final Map<String, String> components = new HashMap<String, String>();
    private final List<String> executeElements = new ArrayList<String>();
    private final List<Throwable> exceptions = new ArrayList<Throwable>();
    private boolean processingErrorsDetected = false;
    private List<Integer> disallowedNodes;
    private Map<String, String> environmentalVariables;
    private boolean logFileNameDefined = false;
    private String mLogFileName = null;

    public boolean isLogFileNameDefined() {
        return this.logFileNameDefined;
    }

    public String getLogFileName() {
        return this.mLogFileName;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public int getNumHCs() {
        return this.numHCs;
    }

    public boolean unixDomainSocketEnabled() {
        return this.unixDomainSocket;
    }

    public double getKillTimer() {
        return this.killTimer;
    }

    public Map<String, String[]> getGroups() {
        return this.groups;
    }

    public Map<String, String> getComponents() {
        return this.components;
    }

    public List<String> getExecuteElements() {
        return this.executeElements;
    }

    public void setEnvMap(Map<String, String> envMap) {
        this.environmentalVariables = envMap;
    }

    public boolean isErroneous() {
        return this.processingErrorsDetected || !this.exceptions.isEmpty();
    }

    public List<Throwable> parseExceptions() {
        return this.exceptions;
    }

    public void readFromFile(String first) {
        this.originalASTs.clear();
        this.toBeProcessedFiles.add(new Path(first));
        while (!this.toBeProcessedFiles.isEmpty()) {
            Path actualFile = this.toBeProcessedFiles.get(0);
            if (!this.isAlreadyProcessed(actualFile)) {
                this.processFile(actualFile);
                this.processedFiles.add(actualFile);
            }
            this.toBeProcessedFiles.remove(0);
        }
    }

    private boolean isAlreadyProcessed(Path actualFile) {
        for (Path processedFile : this.processedFiles) {
            if (!processedFile.equals((Object)actualFile)) continue;
            return true;
        }
        return false;
    }

    private void processFile(Path actualFile) {
        CfgAnalyzer analyzer = new CfgAnalyzer();
        IWorkspaceRoot wroot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = wroot.findFilesForLocationURI(URIUtil.toURI((IPath)actualFile));
        if (files.length == 0) {
            ErrorReporter.logError("The file " + actualFile.toOSString() + " can not be mapped to a file resource in eclipse, and so is not accessible");
            this.processingErrorsDetected = true;
        } else if (files[0].isAccessible()) {
            this.parseFile(actualFile, analyzer, files[0]);
        } else {
            ErrorReporter.logError("The file " + files[0].getLocationURI() + " can not be found");
            this.processingErrorsDetected = true;
        }
    }

    public void processASTs() {
    }

    public StringBuilder toStringResolved(List<Integer> disallowedNodes) {
        StringBuilder sb = new StringBuilder();
        CfgParseTreePrinter.printResolved(this.originalASTs, sb, disallowedNodes, CfgParseTreePrinter.ResolveMode.IN_ROW, this.definesMap, this.environmentalVariables);
        return sb;
    }

    private void parseFile(Path actualFile, CfgAnalyzer analyzer, IFile file) {
        ParserRuleContext rootNode;
        analyzer.directParse(file, actualFile.toOSString(), null);
        CfgParseResult cfgParseResult = analyzer.getCfgParseResult();
        if (cfgParseResult.isLogFileDefined()) {
            this.logFileNameDefined = true;
            this.mLogFileName = cfgParseResult.getLogFileName();
            this.localAddress = cfgParseResult.getLocalAddress();
        }
        if (cfgParseResult.getTcpPort() != null) {
            this.tcpPort = cfgParseResult.getTcpPort();
        }
        if (cfgParseResult.getLocalAddress() != null) {
            this.localAddress = cfgParseResult.getLocalAddress();
        }
        if (cfgParseResult.getKillTimer() != null) {
            this.killTimer = cfgParseResult.getKillTimer();
        }
        if (cfgParseResult.getNumHcs() != null) {
            this.numHCs = cfgParseResult.getNumHcs();
        }
        if (cfgParseResult.isUnixDomainSocket() != null) {
            this.unixDomainSocket = cfgParseResult.isUnixDomainSocket();
        }
        if ((rootNode = cfgParseResult.getParseTreeRoot()) != null) {
            this.originalASTs.put(actualFile, cfgParseResult);
            List<String> includeFiles = cfgParseResult.getIncludeFiles();
            for (String filename : includeFiles) {
                Path filePath;
                filename = PathConverter.getAbsolutePath(actualFile.toOSString(), filename);
                if (filename == null || this.processedFiles.contains(filePath = new Path(filename)) || this.toBeProcessedFiles.contains(filePath)) continue;
                this.toBeProcessedFiles.add(filePath);
            }
            this.definesMap.putAll(cfgParseResult.getDefinitions());
            this.groups.putAll(cfgParseResult.getGroups());
            this.components.putAll(cfgParseResult.getComponents());
            this.executeElements.addAll(cfgParseResult.getExecuteElements());
        }
    }
}

