/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public abstract class TitanLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new Launch(configuration, mode, null);
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IResource[] resources = configuration.getMappedResources();
        if (resources == null) {
            return null;
        }
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (IResource resource : resources) {
            if (!(resource instanceof IProject)) continue;
            result.add((IProject)resource);
        }
        return this.computeReferencedBuildOrder(result.toArray(new IProject[result.size()]));
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.getBuildOrder(configuration, mode);
    }

    protected void showExecutionPerspective() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        try {
            workbench.showPerspective("org.eclipse.titan.executor.perspectives.ExecutingPerspective", workbench.getActiveWorkbenchWindow());
        }
        catch (WorkbenchException e) {
            ErrorDialog.openError(null, (String)"Selecting Titan Executor Perspective failed", (String)e.getMessage(), (IStatus)e.getStatus());
        }
    }
}

