/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.preferences.pages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.properties.PropertyStore;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.utils.ResourcePropertyHandler;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;

public abstract class LogViewerPreferenceRootPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage,
IWorkbenchPreferencePage {
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    public static final String USEPROJECTSETTINGS = "useProjectSettings";
    private List<FieldEditor> editors = new ArrayList<FieldEditor>();
    private IAdaptable element;
    private IPreferenceStore overlayStore;
    private String pageId;
    private Button useProjectSettingsButton;
    private Button useWorkspaceSettingsButton;
    private Button okButton;
    private Button importButton;
    private Button exportButton;
    private Button selectAll;
    private Button deselectAll;
    private Map<String, String> oldPreferences;
    private boolean enableSelectDeselectButtons;

    public LogViewerPreferenceRootPage(int style, boolean enableSelectDeselectButtons) {
        super(style);
        this.enableSelectDeselectButtons = enableSelectDeselectButtons;
    }

    protected void addField(FieldEditor editor) {
        this.editors.add(editor);
        super.addField(editor);
    }

    protected void contributeButtons(Composite parent) {
        this.importButton = new Button(parent, 8);
        this.importButton.setText(Messages.getString("LogViewerPreferenceRootPage.0"));
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LogViewerPreferenceRootPage.this.importPreferences();
                LogViewerPreferenceRootPage.this.updatePage();
            }
        });
        this.exportButton = new Button(parent, 8);
        this.exportButton.setText(Messages.getString("LogViewerPreferenceRootPage.1"));
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LogViewerPreferenceRootPage.this.exportPreferences();
            }
        });
        ((GridLayout)parent.getLayout()).numColumns += 2;
        if (this.enableSelectDeselectButtons) {
            this.selectAll = new Button(parent, 8);
            this.selectAll.setText(Messages.getString("FilteredSilentEventPrefPage.0"));
            this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    LogViewerPreferenceRootPage.this.performSelectAll();
                }
            });
            this.deselectAll = new Button(parent, 8);
            this.deselectAll.setText(Messages.getString("FilteredSilentEventPrefPage.1"));
            this.deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    LogViewerPreferenceRootPage.this.performDeselectAll();
                }
            });
            ((GridLayout)parent.getLayout()).numColumns += 2;
        }
    }

    protected Control createContents(Composite parent) {
        if (this.isPropertyPage()) {
            this.createSelectionGroup(parent);
        }
        return super.createContents(parent);
    }

    public void createControl(Composite parent) {
        if (this.isPropertyPage()) {
            this.pageId = this.getPageId();
            this.overlayStore = new PropertyStore((IResource)this.getElement(), super.getPreferenceStore(), this.pageId);
        }
        super.createControl(parent);
        if (this.isPropertyPage()) {
            this.updateFieldEditors();
        }
        this.getApplyButton().setEnabled(false);
        this.okButton = parent.getShell().getDefaultButton();
    }

    protected abstract void createFieldEditors();

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result && this.isPropertyPage()) {
            this.writeProperty();
        }
        return result;
    }

    public boolean performCancel() {
        if (this.oldPreferences != null) {
            this.setProperties(this.oldPreferences);
            this.oldPreferences.clear();
        }
        return super.performCancel();
    }

    protected void performApply() {
        this.getApplyButton().setEnabled(false);
        super.performApply();
        this.oldPreferences = null;
        if (this.isPropertyPage()) {
            try {
                ((PropertyStore)this.overlayStore).save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.okButton.setFocus();
    }

    protected void performDefaults() {
        if (this.isPropertyPage()) {
            this.useWorkspaceSettingsButton.setSelection(true);
            this.useProjectSettingsButton.setSelection(false);
            this.updateFieldEditors();
        } else {
            super.performDefaults();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof FieldEditor) {
            this.getApplyButton().setEnabled(true);
        }
        super.propertyChange(event);
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.isPropertyPage()) {
            return this.overlayStore;
        }
        return super.getPreferenceStore();
    }

    private Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogViewerPreferenceRootPage.this.updateFieldEditors();
            }
        });
        return button;
    }

    private void createSelectionGroup(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        Composite radioGroup = new Composite(comp, 0);
        radioGroup.setLayout((Layout)new GridLayout());
        radioGroup.setLayoutData((Object)new GridData(768));
        this.useWorkspaceSettingsButton = this.createRadioButton(radioGroup, Messages.getString("FieldEditorOverlayPage.0"));
        this.useProjectSettingsButton = this.createRadioButton(radioGroup, Messages.getString("FieldEditorOverlayPage.1"));
        try {
            String use = ((IResource)this.getElement()).getPersistentProperty(new QualifiedName(this.pageId, USEPROJECTSETTINGS));
            if (TRUE.equals(use)) {
                this.useProjectSettingsButton.setSelection(true);
            } else {
                this.useWorkspaceSettingsButton.setSelection(true);
            }
        }
        catch (CoreException e) {
            this.useWorkspaceSettingsButton.setSelection(true);
        }
    }

    protected abstract void exportPreferences();

    protected abstract void importPreferences();

    protected void performSelectAll() {
        this.getApplyButton().setEnabled(true);
    }

    protected void performDeselectAll() {
        this.getApplyButton().setEnabled(true);
    }

    protected abstract String getPageId();

    protected String getProperty(String key) {
        if (this.isPropertyPage()) {
            return this.getPreferenceStore().getString(key);
        }
        return Activator.getDefault().getPreferenceStore().getString(key);
    }

    protected void setProperties(Map<String, String> prop) {
        Set<String> set = prop.keySet();
        if (this.isPropertyPage()) {
            IPreferenceStore preferenceStore = this.getPreferenceStore();
            for (String key : set) {
                preferenceStore.setValue(key, prop.get(key));
            }
        } else {
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            for (String key : set) {
                preferenceStore.setValue(key, prop.get(key));
            }
        }
    }

    private void updateFieldEditors() {
        boolean enabled = this.useProjectSettingsButton.getSelection();
        this.updateFieldEditors(enabled);
        this.getApplyButton().setEnabled(true);
        this.importButton.setEnabled(enabled);
        this.exportButton.setEnabled(enabled);
        if (this.enableSelectDeselectButtons) {
            this.selectAll.setEnabled(enabled);
            this.deselectAll.setEnabled(enabled);
        }
    }

    protected void updateFieldEditors(boolean enabled) {
        Composite parent = this.getFieldEditorParent();
        for (FieldEditor editor : this.editors) {
            editor.setEnabled(enabled, parent);
        }
    }

    protected abstract void updatePage();

    private boolean isPropertyPage() {
        return this.getElement() != null;
    }

    private void writeProperty() {
        IResource resource = (IResource)this.getElement();
        String value = this.useProjectSettingsButton.getSelection() ? TRUE : FALSE;
        try {
            ResourcePropertyHandler.setProperty(resource, this.pageId, USEPROJECTSETTINGS, value);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void setOldPreferences(Map<String, String> oldPreferences) {
        this.oldPreferences = oldPreferences;
    }

    public void setUseProjectSetting(boolean enabled) {
        this.useProjectSettingsButton.setSelection(enabled);
        this.useWorkspaceSettingsButton.setSelection(!enabled);
        this.updateFieldEditors();
    }
}

