/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.details;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.titan.log.viewer.views.details.DetailData;
import org.eclipse.titan.log.viewer.views.details.DetailsViewContentProvider;
import org.eclipse.titan.log.viewer.views.details.DetailsViewLabelProvider;
import org.eclipse.ui.IViewSite;

public class TreeViewComposite
extends Composite {
    private TreeViewer viewer = new TreeViewer((Composite)this, 768);
    private DetailData currentData;

    public TreeViewComposite(Composite parent, IViewSite site) {
        super(parent, 262144);
        this.viewer.setContentProvider((IContentProvider)new DetailsViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DetailsViewLabelProvider());
        this.viewer.setInput((Object)site);
        this.currentData = null;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void inputChanged(DetailData newInput) {
        String oldMessage = null;
        if (newInput == null) {
            this.viewer.getContentProvider().inputChanged((Viewer)this.viewer, null, null);
            this.currentData = null;
            return;
        }
        if (this.currentData != null && this.currentData.isEqualTo(newInput)) {
            return;
        }
        this.currentData = newInput;
        String message = this.currentData.getLine();
        if (message.contains("{") && message.indexOf("{") != 0) {
            oldMessage = message;
            message = "{ " + message + " }";
            this.currentData.setLine(message);
        }
        this.viewer.getContentProvider().inputChanged((Viewer)this.viewer, (Object)newInput, (Object)newInput);
        Tree tree = this.viewer.getTree();
        tree.setVisible(false);
        if (tree.getItemCount() > 0) {
            this.viewer.setSelection((ISelection)new StructuredSelection(tree.getItem(0).getData()));
        }
        if (oldMessage != null) {
            this.currentData.setLine(oldMessage);
        }
        this.viewer.expandAll();
        tree.setVisible(true);
    }
}

