/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections15.Closure;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ChainedTransformer;
import org.apache.commons.collections15.functors.CloneTransformer;
import org.apache.commons.collections15.functors.ClosureTransformer;
import org.apache.commons.collections15.functors.ConstantTransformer;
import org.apache.commons.collections15.functors.EqualPredicate;
import org.apache.commons.collections15.functors.ExceptionTransformer;
import org.apache.commons.collections15.functors.FactoryTransformer;
import org.apache.commons.collections15.functors.InstantiateTransformer;
import org.apache.commons.collections15.functors.InvokerTransformer;
import org.apache.commons.collections15.functors.MapTransformer;
import org.apache.commons.collections15.functors.NOPTransformer;
import org.apache.commons.collections15.functors.PredicateTransformer;
import org.apache.commons.collections15.functors.StringValueTransformer;
import org.apache.commons.collections15.functors.SwitchTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerUtils {
    public static Transformer exceptionTransformer() {
        return ExceptionTransformer.INSTANCE;
    }

    public static Transformer nullTransformer() {
        return ConstantTransformer.NULL_INSTANCE;
    }

    public static Transformer nopTransformer() {
        return NOPTransformer.INSTANCE;
    }

    public static Transformer cloneTransformer() {
        return CloneTransformer.INSTANCE;
    }

    public static <T> Transformer<Object, T> constantTransformer(T constantToReturn) {
        return ConstantTransformer.getInstance(constantToReturn);
    }

    public static <T> Transformer<T, T> asTransformer(Closure<T> closure) {
        return ClosureTransformer.getInstance(closure);
    }

    public static <T> Transformer<T, Boolean> asTransformer(Predicate<T> predicate) {
        return PredicateTransformer.getInstance(predicate);
    }

    public static <T> Transformer<Object, T> asTransformer(Factory<T> factory) {
        return FactoryTransformer.getInstance(factory);
    }

    public static <I, M, O> Transformer<I, O> chainedTransformer(Transformer<I, ? extends M> transformer1, Transformer<? super M, O> transformer2) {
        return ChainedTransformer.getInstance(transformer1, transformer2);
    }

    public static <I, O> Transformer<I, O> chainedTransformer(Transformer[] transformers) {
        return ChainedTransformer.getInstance(transformers);
    }

    public static <I, O> Transformer<I, O> chainedTransformer(Collection transformers) {
        return ChainedTransformer.getInstance(transformers);
    }

    public static <I, O> Transformer<I, O> switchTransformer(Predicate<I> predicate, Transformer<? super I, ? extends O> trueTransformer, Transformer<? super I, ? extends O> falseTransformer) {
        return SwitchTransformer.getInstance(new Predicate[]{predicate}, new Transformer[]{trueTransformer}, falseTransformer);
    }

    public static <I, O> Transformer<I, O> switchTransformer(Predicate<? super I>[] predicates, Transformer<? super I, ? extends O>[] transformers) {
        return SwitchTransformer.getInstance(predicates, transformers, null);
    }

    public static <I, O> Transformer<I, O> switchTransformer(Predicate<? super I>[] predicates, Transformer<? super I, ? extends O>[] transformers, Transformer<? super I, ? extends O> defaultTransformer) {
        return SwitchTransformer.getInstance(predicates, transformers, defaultTransformer);
    }

    public static <I, O> Transformer<I, O> switchTransformer(Map<Predicate<? super I>, Transformer<? super I, ? extends O>> predicatesAndTransformers) {
        return SwitchTransformer.getInstance(predicatesAndTransformers);
    }

    public static <I, O> Transformer<I, O> switchMapTransformer(Map<I, Transformer<? super I, ? extends O>> objectsAndTransformers) {
        Transformer[] trs = null;
        Predicate[] preds = null;
        if (objectsAndTransformers == null) {
            throw new IllegalArgumentException("The object and transformer map must not be null");
        }
        Transformer<? super I, ? extends O> def = objectsAndTransformers.remove(null);
        int size = objectsAndTransformers.size();
        trs = new Transformer[size];
        preds = new Predicate[size];
        int i = 0;
        for (Map.Entry<I, Transformer<I, O>> entry : objectsAndTransformers.entrySet()) {
            preds[i] = EqualPredicate.getInstance(entry.getKey());
            trs[i] = entry.getValue();
            ++i;
        }
        return TransformerUtils.switchTransformer(preds, trs, def);
    }

    public static Transformer<Class, Object> instantiateTransformer() {
        return InstantiateTransformer.NO_ARG_INSTANCE;
    }

    public static Transformer<Class, Object> instantiateTransformer(Class[] paramTypes, Object[] args) {
        return InstantiateTransformer.getInstance(paramTypes, args);
    }

    public static <I, O> Transformer<I, O> mapTransformer(Map<I, O> map) {
        return MapTransformer.getInstance(map);
    }

    public static Transformer invokerTransformer(String methodName) {
        return InvokerTransformer.getInstance(methodName, null, null);
    }

    public static Transformer invokerTransformer(String methodName, Class[] paramTypes, Object[] args) {
        return InvokerTransformer.getInstance(methodName, paramTypes, args);
    }

    public static <T> Transformer<T, String> stringValueTransformer() {
        return StringValueTransformer.getInstance();
    }
}

