/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.sew.launcher.Activator;
import org.eclipse.efm.sew.launcher.LaunchConfigurationTabGroup;
import org.eclipse.efm.sew.launcher.ui.AbstractSewLaunchConfigurationTab;
import org.eclipse.efm.sew.launcher.ui.internal.SWTFactory;
import org.eclipse.efm.sew.launcher.ui.internal.fieldeditor.BooleanFieldEditor;
import org.eclipse.efm.sew.launcher.ui.internal.fieldeditor.IntegerFieldEditor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;

public class ExpertTab
extends AbstractSewLaunchConfigurationTab {
    private String fTabName;
    private Group groupExplorationPage;
    private IntegerFieldEditor fHoJBeginStep;
    private BooleanFieldEditor fHoJHeuristic;
    private BooleanFieldEditor fHoJStop;
    private BooleanFieldEditor fHoJSlice;
    private static final String SEARCH_SCOPE_GLOBALLY = "GLOBALLY";
    private static final String SEARCH_SCOPE_LOCALLY = "LOCALLY";
    private String fHoJSearchScope = "LOCALLY";
    private Button fScopeGloballyButton = null;
    private Button fScopeLocallyButton = null;
    private BooleanFieldEditor fHoJSchedulerOrdered;
    private BooleanFieldEditor fHoJHitConsecutive;
    private BooleanFieldEditor fHoJHitFolding;
    private BooleanFieldEditor fHoJHitLucky;
    private BooleanFieldEditor fHoJHitMax;
    private BooleanFieldEditor fHoJJumpSlice;
    private IntegerFieldEditor fHoJJumpHeight;
    private IntegerFieldEditor fHoJJumpLimit;
    private IntegerFieldEditor fHoJHitCount;
    private IntegerFieldEditor fHoJJumpCount;
    private Group groupHOJPage;
    private static final String SCOPE_COMBO_ITEM_INSTANCE = "INSTANCE";
    private static final String SCOPE_COMBO_ITEM_MODEL = "MODEL";
    private static final String SCOPE_COMBO_ITEM_DETAILS = "DETAILS";
    private static final String[] SCOPE_COMBO_ITEMS = new String[]{"INSTANCE", "MODEL", "DETAILS"};
    private static final String HEURISTIC_START_COMBO_ITEM_BASIC = "BASIC";
    private static final String HEURISTIC_START_COMBO_ITEM_NAIVE = "NAIVE";
    private static final String HEURISTIC_START_COMBO_ITEM_SMART = "SMART";
    private static final String HEURISTIC_START_COMBO_ITEM_AGRESSIVE = "AGRESSIVE";
    private static final String[] HEURISTIC_START_COMBO_ITEMS = new String[]{"BASIC", "NAIVE", "SMART", "AGRESSIVE"};
    private static final String DIRECTIVE_TRACE_HEURISTIC_COMBO_ITEM_BASIC = "BASIC";
    private static final String DIRECTIVE_TRACE_HEURISTIC_COMBO_ITEM_NAIVE = "NAIVE";
    private static final String DIRECTIVE_TRACE_HEURISTIC_COMBO_ITEM_SMART = "SMART";
    private static final String DIRECTIVE_TRACE_HEURISTIC_COMBO_ITEM_AGRESSIVE = "AGRESSIVE";
    private static final String[] DIRECTIVE_TRACE_HEURISTIC_COMBO_ITEMS = new String[]{"BASIC", "NAIVE", "SMART", "AGRESSIVE"};
    private IntegerFieldEditor fTCBeginStep;
    private BooleanFieldEditor fTCStop;
    private BooleanFieldEditor fTCMinimize;
    private BooleanFieldEditor fTCSlice;
    private BooleanFieldEditor fTCHeuristic;
    private Combo fTCScopeCombo = null;
    private String fTCScope = "MODEL";
    private Combo fTCHeuristicStartCombo = null;
    private String fTCHeuristicStart = "BASIC";
    private IntegerFieldEditor fTCHeuristicTrials;
    private IntegerFieldEditor fTCObjectiveRate;
    private IntegerFieldEditor fTCObjectiveRest;
    private Combo fTCDirectiveTraceHeuristicCombo = null;
    private String fTCDirectiveTraceHeuristic = "SMART";
    private IntegerFieldEditor fTCDirectiveTraceCountLimit;
    private IntegerFieldEditor fTCDirectiveTraceSizeLimit;
    private IntegerFieldEditor fTCCoverageHeight;
    private IntegerFieldEditor fTCCoverageHeightReachedLimit;
    private BooleanFieldEditor fTCHitStronglyRandom;
    private IntegerFieldEditor fTCHitStronglyCount;
    private BooleanFieldEditor fTCHitWeaklyRandom;
    private IntegerFieldEditor fTCHitWeaklyCount;
    private BooleanFieldEditor fTCHitOtherRandom;
    private IntegerFieldEditor fTCHitOtherCount;
    private Group groupTCPage;
    private Composite simpleComposite;
    private TabListener fListener = new TabListener();

    public ExpertTab(LaunchConfigurationTabGroup groupTab) {
        super(groupTab);
        this.setHelpContextId("org.eclipse.efm.sew.launcher.efm_runconf_expert_tab");
        this.fTabName = "Expert";
    }

    public void createControl(Composite parent) {
        this.simpleComposite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 1808, 0, 0);
        this.setControl((Control)this.simpleComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
        this.createExplorationPage(this.simpleComposite);
        this.createHitOrJumpPage(this.simpleComposite);
        this.createTransitionCoveragePage(this.simpleComposite);
    }

    private void setEnableGroupExplorationPage(ILaunchConfiguration configuration) {
        try {
            String fAnalysisProfile = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYSIS_PROFILE", "");
            String fModelAnalysis = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_ANALYSIS", "");
            this.visibleAndExclude((Control)this.groupExplorationPage, fAnalysisProfile.equals(SCOPE_COMBO_ITEM_MODEL) && fModelAnalysis.equals("Exploration") || fAnalysisProfile.equals("TESTOFFLINE"));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void setEnableGroupHOJPage(ILaunchConfiguration configuration) {
        try {
            String fAnalysisProfile = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYSIS_PROFILE", "");
            String fModelAnalysis = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_ANALYSIS", "");
            this.visibleAndExclude((Control)this.groupHOJPage, fAnalysisProfile.equals(SCOPE_COMBO_ITEM_MODEL) && fModelAnalysis.equals("Behavior Selection"));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void setEnableGroupTCPage(ILaunchConfiguration configuration) {
        try {
            String fAnalysisProfile = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYSIS_PROFILE", "");
            String fModelAnalysis = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_ANALYSIS", "");
            this.visibleAndExclude((Control)this.groupTCPage, fAnalysisProfile.equals(SCOPE_COMBO_ITEM_MODEL) && fModelAnalysis.equals("Transition Coverage"));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void createExplorationPage(Composite parent) {
        this.groupExplorationPage = SWTFactory.createGroup(parent, "Exploration Page", 1, 2, 768);
        Composite comp = SWTFactory.createComposite((Composite)this.groupExplorationPage, 1, 1, 768);
        SWTFactory.createLabel(comp, "&No expert mode for Exploration of Model Analysis and Test Verdict Computation !", 1);
    }

    public void createHitOrJumpPage(Composite parent) {
        this.groupHOJPage = SWTFactory.createGroup(parent, "Behavior Selection Page", 1, 2, 768);
        Group groupHoJProperty = SWTFactory.createGroup((Composite)this.groupHOJPage, "Section PROPERTY", 1, 1, 768);
        Composite comp1 = SWTFactory.createComposite((Composite)groupHoJProperty, 1, 1, 768);
        this.fHoJBeginStep = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_HOJ_BEGIN_STEP", "&Begin Step:", comp1, 0);
        this.fHoJBeginStep.setToolTipText("Number of \"cumulated\" steps before begining the research of the behavior");
        Group groupCommon = SWTFactory.createGroup((Composite)groupHoJProperty, "&Common", 3, 2, 768);
        Composite compCommon = SWTFactory.createComposite((Composite)groupCommon, 1, 1, 768);
        this.fHoJHeuristic = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_HOJ_HEURISTIC", "&Heuristic", compCommon, true);
        this.fHoJHeuristic.setToolTipText("Activate the use of heuristics");
        compCommon = SWTFactory.createComposite((Composite)groupCommon, 1, 1, 768);
        this.fHoJStop = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_HOJ_STOP", "&Stop", compCommon, true);
        this.fHoJStop.setToolTipText("Stop the symbolic excution as soon as the behavior is covered");
        compCommon = SWTFactory.createComposite((Composite)groupCommon, 1, 1, 768);
        this.fHoJSlice = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_HOJ_SLICE", "&Slice", compCommon, true);
        this.fHoJSlice.setToolTipText("Pruning the symbolic execution graph at the end of the analysis");
        Group groupScope = SWTFactory.createGroup((Composite)groupHoJProperty, "&Search Scope", 2, 2, 768);
        this.fScopeGloballyButton = SWTFactory.createRadioButton((Composite)groupScope, "&Globally");
        this.fScopeGloballyButton.addSelectionListener((SelectionListener)this.fListener);
        this.fScopeGloballyButton.setToolTipText("Globally Search Scope");
        this.fScopeLocallyButton = SWTFactory.createRadioButton((Composite)groupScope, "&Locally");
        this.fScopeLocallyButton.addSelectionListener((SelectionListener)this.fListener);
        this.fScopeLocallyButton.setToolTipText("Locally Search Scope");
        Group groupScheduler = SWTFactory.createGroup((Composite)groupHoJProperty, "&Scheduler", 2, 2, 768);
        Composite compScheduler = SWTFactory.createComposite((Composite)groupScheduler, 1, 1, 768);
        this.fHoJSchedulerOrdered = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_HOJ_SCHEDULER_ORDERED", "&Ordered", compScheduler, false);
        this.fHoJSchedulerOrdered.setToolTipText("Search ordered traces");
        compScheduler = SWTFactory.createComposite((Composite)groupScheduler, 1, 1, 768);
        this.fHoJHitConsecutive = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_HOJ_HIT_CONSECUTIVE", "&Consecutive", compScheduler, false);
        this.fHoJHitConsecutive.setToolTipText("Search ordered traces with consecutive observables");
        Group groupOption = SWTFactory.createGroup((Composite)groupHoJProperty, "&Options", 4, 2, 768);
        Composite compOption = SWTFactory.createComposite((Composite)groupOption, 1, 1, 768);
        this.fHoJHitFolding = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_HIT_FOLDING", "&Folding", compOption, true);
        this.fHoJHitFolding.setToolTipText("Enabled checking many trace point in one context");
        compOption = SWTFactory.createComposite((Composite)groupOption, 1, 1, 768);
        this.fHoJHitLucky = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_HOJ_HIT_LUCKY", "&Lucky", compOption, false);
        this.fHoJHitLucky.setToolTipText("Search one trace in a lucky way - no backtracking");
        compOption = SWTFactory.createComposite((Composite)groupOption, 1, 1, 768);
        this.fHoJHitMax = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_HOJ_HIT_MAX", "&Maximun Trace", compOption, false);
        this.fHoJHitMax.setToolTipText("Search a maximun trace");
        compOption = SWTFactory.createComposite((Composite)groupOption, 1, 1, 768);
        this.fHoJJumpSlice = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_HOJ_JUMP_SLICE", "&Jump Slice", compOption, false);
        this.fHoJJumpSlice.setToolTipText("Pruning intermediate at the end of hit or jump");
        Group groupHoJHeuristic = SWTFactory.createGroup((Composite)this.groupHOJPage, "Section HEURISTIC", 1, 1, 768);
        Composite compHeuristic = SWTFactory.createComposite((Composite)groupHoJHeuristic, 1, 1, 768);
        this.fHoJJumpHeight = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_HOJ_JUMP_HEIGHT", "&Jump Height:", compHeuristic, 6);
        this.fHoJJumpLimit = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_HOJ_JUMP_TRIALS_LIMIT", "&Jump Trials Limit:", compHeuristic, -1);
        this.fHoJHitCount = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_HOJ_HIT_COUNT", "&Hit Count:", compHeuristic, 1);
        this.fHoJJumpCount = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_HOJ_JUMP_COUNT", "&Jump Count:", compHeuristic, 1);
    }

    public void createTransitionCoveragePage(Composite parent) {
        this.groupTCPage = SWTFactory.createGroup(parent, "Transition Coverage Page", 1, 2, 768);
        Group groupTCProperty = SWTFactory.createGroup((Composite)this.groupTCPage, "Section PROPERTY", 1, 1, 768);
        Composite comp = SWTFactory.createComposite((Composite)groupTCProperty, 1, 1, 768);
        this.fTCBeginStep = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_TC_BEGIN_STEP", "&Begin Step:", comp, 0);
        this.fTCBeginStep.setToolTipText("Number of \"cumulated\" steps before begining the verification cover");
        this.fTCBeginStep.setEnabled(false);
        Group groupCommon = SWTFactory.createGroup((Composite)groupTCProperty, "&Common Coverage Configuration", 4, 2, 768);
        Composite compCommon = SWTFactory.createComposite((Composite)groupCommon, 1, 1, 768);
        this.fTCHeuristic = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_TC_HEURISTIC", "&Heuristic", compCommon, true);
        this.fTCHeuristic.setToolTipText("Activate the use of heuristics");
        compCommon = SWTFactory.createComposite((Composite)groupCommon, 1, 1, 768);
        this.fTCStop = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_TC_STOP", "&Stop", compCommon, true);
        this.fTCStop.setToolTipText("Stop the symbolic excution as soon as the coverage is completed");
        compCommon = SWTFactory.createComposite((Composite)groupCommon, 1, 1, 768);
        this.fTCSlice = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_TC_SLICE", "&Slice", compCommon, true);
        this.fTCSlice.setToolTipText("Pruning symbolic execution graph at the end of the analysis");
        compCommon = SWTFactory.createComposite((Composite)groupCommon, 1, 1, 768);
        this.fTCMinimize = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_TC_MINIMIZE", "&Minimize", compCommon, true);
        this.fTCMinimize.setToolTipText("Stop the symbolic execution at the earliest");
        Composite comp3 = SWTFactory.createComposite((Composite)groupTCProperty, 2, 1, 768);
        SWTFactory.createLabel(comp3, "&Scope:", 1);
        this.fTCScopeCombo = SWTFactory.createCombo(comp3, 12, 1, SCOPE_COMBO_ITEMS);
        this.fTCScopeCombo.addSelectionListener((SelectionListener)this.fListener);
        Group groupTCHeuristic = SWTFactory.createGroup((Composite)this.groupTCPage, "First Heuristic Configuration", 2, 1, 768);
        Group group = SWTFactory.createGroup((Composite)groupTCHeuristic, "&Configuration", 1, 1, 768);
        comp = SWTFactory.createComposite((Composite)group, 2, 1, 768);
        SWTFactory.createLabel(comp, "&Start:", 1);
        this.fTCHeuristicStartCombo = SWTFactory.createCombo(comp, 12, 1, HEURISTIC_START_COMBO_ITEMS);
        this.fTCHeuristicStartCombo.addSelectionListener((SelectionListener)this.fListener);
        this.fTCHeuristicTrials = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_TC_HEURISTIC_TRIALS", "&Trials:", comp, -1);
        this.fTCHeuristicTrials.widthInChars = 10;
        group = SWTFactory.createGroup((Composite)groupTCHeuristic, "&Target Objective", 1, 1, 768);
        comp = SWTFactory.createComposite((Composite)group, 2, 1, 768);
        this.fTCObjectiveRate = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_TC_OBJECTIVE_RATE", "&Rate:", comp, 100);
        this.fTCObjectiveRate.setTextLimit(3);
        this.fTCObjectiveRest = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_TC_OBJECTIVE_REST", "&Rest:", comp, 0);
        this.fTCObjectiveRest.setTextLimit(3);
        group = SWTFactory.createGroup((Composite)groupTCHeuristic, "&Lookahead Scope", 1, 2, 768);
        comp = SWTFactory.createComposite((Composite)group, 2, 1, 768);
        this.fTCCoverageHeight = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_TC_LOOKAHEAD_DEPTH", "&Depth:", comp, 7);
        this.fTCCoverageHeightReachedLimit = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_TC_LOOKAHEAD_WIDTH", "&Width:", comp, 42);
        Group groupStrategy = SWTFactory.createGroup((Composite)groupTCHeuristic, "Strategy of Selection of Contexts in the Queue w.r.t. the number of Fireable transitions", 3, 2, 768);
        group = SWTFactory.createGroup((Composite)groupStrategy, "&Strongly Fireable Transition Selection", 1, 1, 768);
        Composite compGroup = SWTFactory.createComposite((Composite)group, 2, 1, 768);
        comp = SWTFactory.createComposite(compGroup, 1, 2, 768);
        this.fTCHitStronglyRandom = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_TC_HIT_STRONGLY_RANDOM", "&Hit Random", comp, false);
        this.fTCHitStronglyCount = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_TC_HIT_STRONGLY_COUNT", "&Hit Count:", compGroup, 1);
        group = SWTFactory.createGroup((Composite)groupStrategy, "&Weakly Fireable Transition Selection", 1, 1, 768);
        compGroup = SWTFactory.createComposite((Composite)group, 2, 1, 768);
        comp = SWTFactory.createComposite(compGroup, 1, 2, 768);
        this.fTCHitWeaklyRandom = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_TC_HIT_WEAKLY_RANDOM", "&Hit Random", comp, false);
        this.fTCHitWeaklyCount = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_TC_HIT_WEAKLY_COUNT", "&Hit Count:", compGroup, 1);
        group = SWTFactory.createGroup((Composite)groupStrategy, "&Other Fireable Transition Selection", 1, 1, 768);
        compGroup = SWTFactory.createComposite((Composite)group, 2, 1, 768);
        comp = SWTFactory.createComposite(compGroup, 1, 2, 768);
        this.fTCHitOtherRandom = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_TC_HIT_OTHER_RANDOM", "&Hit Random", comp, false);
        this.fTCHitOtherCount = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_TC_HIT_OTHER_COUNT", "&Hit Count:", compGroup, 1);
        groupTCHeuristic = SWTFactory.createGroup((Composite)this.groupTCPage, "Second Heuristic Configuration", 2, 1, 768);
        group = SWTFactory.createGroup((Composite)groupTCHeuristic, "&Directive Trace: Strategy & Limit", 1, 1, 768);
        comp = SWTFactory.createComposite((Composite)group, 1, 1, 768);
        SWTFactory.createLabel(comp, "&Heuristic:", 1);
        this.fTCDirectiveTraceHeuristicCombo = SWTFactory.createCombo(comp, 12, 1, DIRECTIVE_TRACE_HEURISTIC_COMBO_ITEMS);
        this.fTCDirectiveTraceHeuristicCombo.addSelectionListener((SelectionListener)this.fListener);
        this.fTCDirectiveTraceCountLimit = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_TC_DIRECTIVE_TRACE_COUNT_LIMIT", "&Count:", comp, 8);
        this.fTCDirectiveTraceSizeLimit = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_TC_DIRECTIVE_TRACE_SIZE_LIMIT", "&Size:", comp, 8);
    }

    IDialogSettings getDialogBoundsSettings(String id) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(id);
        if (section == null) {
            section = settings.addNewSection(id);
        }
        return section;
    }

    private void handleSearchScopeSelectionChange() {
        if (this.fScopeGloballyButton.getSelection()) {
            this.fHoJSearchScope = SEARCH_SCOPE_GLOBALLY;
        } else if (this.fScopeLocallyButton.getSelection()) {
            this.fHoJSearchScope = SEARCH_SCOPE_LOCALLY;
        }
        this.updateLaunchConfigurationDialog();
    }

    private void handleScopeSelectionChange() {
        this.fTCScope = this.fTCScopeCombo.getText();
        this.updateLaunchConfigurationDialog();
    }

    private void handleHeuristicStartSelectionChange() {
        this.fTCHeuristicStart = this.fTCHeuristicStartCombo.getText();
        this.updateLaunchConfigurationDialog();
    }

    private void handleDirectiveTraceHeuristicSelectionChange() {
        this.fTCDirectiveTraceHeuristic = this.fTCDirectiveTraceHeuristicCombo.getText();
        this.updateLaunchConfigurationDialog();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (!this.fHoJBeginStep.isValid()) {
            this.setErrorMessage("Begin Step is not a valid integer");
            return false;
        }
        if (!this.fHoJJumpHeight.isValid()) {
            this.setErrorMessage("Jump Height is not a valid integer");
            return false;
        }
        if (!this.fHoJJumpLimit.isValid()) {
            this.setErrorMessage("Jump Limit is not a valid integer");
            return false;
        }
        if (!this.fHoJHitCount.isValid()) {
            this.setErrorMessage("Hit Count is not a valid integer");
            return false;
        }
        if (!this.fHoJJumpCount.isValid()) {
            this.setErrorMessage("Jump Count is not a valid integer");
            return false;
        }
        if (!this.fTCBeginStep.isValid()) {
            this.setErrorMessage("Begin Step is not a valid integer");
            return false;
        }
        if (!this.fTCHeuristicTrials.isValid()) {
            this.setErrorMessage("Heuristic Trials is not a valid integer");
            return false;
        }
        if (!this.fTCObjectiveRate.isValid()) {
            this.setErrorMessage("Objective Rate is not a valid integer");
            return false;
        }
        if (!this.fTCObjectiveRest.isValid()) {
            this.setErrorMessage("Objective Rest is not a valid integer");
            return false;
        }
        if (!this.fTCDirectiveTraceCountLimit.isValid()) {
            this.setErrorMessage("Directive Trace Count Limit is not a valid integer");
            return false;
        }
        if (!this.fTCDirectiveTraceSizeLimit.isValid()) {
            this.setErrorMessage("Directive Trace Size Limit is not a valid integer");
            return false;
        }
        if (!this.fTCCoverageHeight.isValid()) {
            this.setErrorMessage("Coverage Height is not a valid integer");
            return false;
        }
        if (!this.fTCCoverageHeightReachedLimit.isValid()) {
            this.setErrorMessage("Coverage Height Reached Limit is not a valid integer");
            return false;
        }
        if (!this.fTCHitStronglyCount.isValid()) {
            this.setErrorMessage("Hit Strongly Count is not a valid integer");
            return false;
        }
        if (!this.fTCHitWeaklyCount.isValid()) {
            this.setErrorMessage("Hit Weakly Count is not a valid integer");
            return false;
        }
        if (!this.fTCHitOtherCount.isValid()) {
            this.setErrorMessage("Hit Other Count is not a valid integer");
            return false;
        }
        return true;
    }

    public void setDefaultsHOJ(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_BEGIN_STEP", 0);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_HEURISTIC", true);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_STOP", true);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_SLICE", true);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_SEARCH_SCOPE", SEARCH_SCOPE_GLOBALLY);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_JUMP_HEIGHT", 6);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_JUMP_TRIALS_LIMIT", -1);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_HIT_COUNT", 1);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_HIT_CONSECUTIVE", false);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_HIT_MAX", false);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_JUMP_COUNT", 1);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_JUMP_SLICE", false);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_SCHEDULER_ORDERED", true);
    }

    public void setDefaultsTC(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_BEGIN_STEP", 0);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_STOP", true);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_MINIMIZE", true);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_SLICE", true);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HEURISTIC", true);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_SCOPE", SCOPE_COMBO_ITEM_MODEL);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HEURISTIC_START", "BASIC");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HEURISTIC_TRIALS", -1);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_OBJECTIVE_RATE", 100);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_OBJECTIVE_REST", 0);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_DIRECTIVE_TRACE_HEURISTIC", "SMART");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_DIRECTIVE_TRACE_COUNT_LIMIT", 8);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_DIRECTIVE_TRACE_SIZE_LIMIT", 8);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_LOOKAHEAD_DEPTH", 7);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_LOOKAHEAD_WIDTH", 42);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_STRONGLY_RANDOM", false);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_STRONGLY_COUNT", 1);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_WEAKLY_RANDOM", false);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_WEAKLY_COUNT", 1);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_OTHER_RANDOM", false);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_OTHER_COUNT", 1);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.setDefaultsHOJ(configuration);
        this.setDefaultsTC(configuration);
    }

    public void initializeFromExploration(ILaunchConfiguration configuration) {
        this.setEnableGroupExplorationPage(configuration);
    }

    public void initializeFromHoJ(ILaunchConfiguration configuration) {
        this.setEnableGroupHOJPage(configuration);
        this.fHoJBeginStep.initializeFrom(configuration);
        this.fHoJHeuristic.initializeFrom(configuration);
        this.fHoJStop.initializeFrom(configuration);
        this.fHoJSlice.initializeFrom(configuration);
        try {
            this.fHoJSearchScope = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_SEARCH_SCOPE", SEARCH_SCOPE_GLOBALLY);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.initializeHoJSearchScope();
        this.fHoJSchedulerOrdered.initializeFrom(configuration);
        this.fHoJHitConsecutive.initializeFrom(configuration);
        this.fHoJHitFolding.initializeFrom(configuration);
        this.fHoJHitLucky.initializeFrom(configuration);
        this.fHoJHitMax.initializeFrom(configuration);
        this.fHoJJumpSlice.initializeFrom(configuration);
        this.fHoJJumpHeight.initializeFrom(configuration);
        this.fHoJJumpLimit.initializeFrom(configuration);
        this.fHoJHitCount.initializeFrom(configuration);
        this.fHoJJumpCount.initializeFrom(configuration);
    }

    public void initializeFromTC(ILaunchConfiguration configuration) {
        this.setEnableGroupTCPage(configuration);
        this.fTCBeginStep.initializeFrom(configuration);
        this.fTCStop.initializeFrom(configuration);
        this.fTCMinimize.initializeFrom(configuration);
        this.fTCSlice.initializeFrom(configuration);
        this.fTCHeuristic.initializeFrom(configuration);
        try {
            this.fTCScope = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_SCOPE", SCOPE_COMBO_ITEM_MODEL);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.initializeTCScope();
        try {
            this.fTCHeuristicStart = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HEURISTIC_START", "BASIC");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.initializeTCHeuristicStart();
        this.fTCHeuristicTrials.initializeFrom(configuration);
        this.fTCObjectiveRate.initializeFrom(configuration);
        this.fTCObjectiveRest.initializeFrom(configuration);
        try {
            this.fTCDirectiveTraceHeuristic = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_DIRECTIVE_TRACE_HEURISTIC", "SMART");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.initializeTCDirectiveTraceHeuristic();
        this.fTCDirectiveTraceCountLimit.initializeFrom(configuration);
        this.fTCDirectiveTraceSizeLimit.initializeFrom(configuration);
        this.fTCCoverageHeight.initializeFrom(configuration);
        this.fTCCoverageHeightReachedLimit.initializeFrom(configuration);
        this.fTCHitStronglyRandom.initializeFrom(configuration);
        this.fTCHitStronglyCount.initializeFrom(configuration);
        this.fTCHitWeaklyRandom.initializeFrom(configuration);
        this.fTCHitWeaklyCount.initializeFrom(configuration);
        this.fTCHitOtherRandom.initializeFrom(configuration);
        this.fTCHitOtherCount.initializeFrom(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initializeFromExploration(configuration);
        this.initializeFromHoJ(configuration);
        this.initializeFromTC(configuration);
    }

    private void initializeHoJSearchScope() {
        switch (this.fHoJSearchScope) {
            case "GLOBALLY": {
                this.fScopeGloballyButton.setSelection(true);
                break;
            }
            case "LOCALLY": {
                this.fScopeLocallyButton.setSelection(true);
                break;
            }
            default: {
                this.fScopeGloballyButton.setSelection(true);
            }
        }
    }

    private void initializeTCScope() {
        switch (this.fTCScope) {
            case "INSTANCE": {
                this.fTCScopeCombo.select(0);
                break;
            }
            case "MODEL": {
                this.fTCScopeCombo.select(1);
                break;
            }
            default: {
                this.fTCScopeCombo.select(0);
            }
        }
    }

    private void initializeTCHeuristicStart() {
        switch (this.fTCHeuristicStart) {
            case "BASIC": {
                this.fTCHeuristicStartCombo.select(0);
                break;
            }
            case "NAIVE": {
                this.fTCHeuristicStartCombo.select(1);
                break;
            }
            case "SMART": {
                this.fTCHeuristicStartCombo.select(2);
                break;
            }
            case "AGRESSIVE": {
                this.fTCHeuristicStartCombo.select(3);
                break;
            }
            default: {
                this.fTCHeuristicStartCombo.select(0);
            }
        }
    }

    private void initializeTCDirectiveTraceHeuristic() {
        switch (this.fTCDirectiveTraceHeuristic) {
            case "BASIC": {
                this.fTCDirectiveTraceHeuristicCombo.select(0);
                break;
            }
            case "NAIVE": {
                this.fTCDirectiveTraceHeuristicCombo.select(1);
                break;
            }
            case "SMART": {
                this.fTCDirectiveTraceHeuristicCombo.select(2);
                break;
            }
            case "AGRESSIVE": {
                this.fTCDirectiveTraceHeuristicCombo.select(3);
                break;
            }
            default: {
                this.fTCDirectiveTraceHeuristicCombo.select(0);
            }
        }
    }

    public void performApplyExploration(ILaunchConfigurationWorkingCopy configuration) {
        this.setEnableGroupExplorationPage((ILaunchConfiguration)configuration);
    }

    public void performApplyHoJ(ILaunchConfigurationWorkingCopy configuration) {
        this.setEnableGroupHOJPage((ILaunchConfiguration)configuration);
        this.fHoJBeginStep.performApply(configuration);
        this.fHoJHeuristic.performApply(configuration);
        this.fHoJStop.performApply(configuration);
        this.fHoJSlice.performApply(configuration);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_SEARCH_SCOPE", this.fHoJSearchScope);
        this.fHoJSchedulerOrdered.performApply(configuration);
        this.fHoJHitConsecutive.performApply(configuration);
        this.fHoJHitFolding.performApply(configuration);
        this.fHoJHitLucky.performApply(configuration);
        this.fHoJHitMax.performApply(configuration);
        this.fHoJJumpSlice.performApply(configuration);
        this.fHoJJumpHeight.performApply(configuration);
        this.fHoJJumpLimit.performApply(configuration);
        this.fHoJHitCount.performApply(configuration);
        this.fHoJJumpCount.performApply(configuration);
    }

    public void performApplyTC(ILaunchConfigurationWorkingCopy configuration) {
        this.setEnableGroupTCPage((ILaunchConfiguration)configuration);
        this.fTCBeginStep.performApply(configuration);
        this.fTCStop.performApply(configuration);
        this.fTCMinimize.performApply(configuration);
        this.fTCSlice.performApply(configuration);
        this.fTCHeuristic.performApply(configuration);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_SCOPE", this.fTCScope);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HEURISTIC_START", this.fTCHeuristicStart);
        this.fTCHeuristicTrials.performApply(configuration);
        this.fTCObjectiveRate.performApply(configuration);
        this.fTCObjectiveRest.performApply(configuration);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_DIRECTIVE_TRACE_HEURISTIC", this.fTCDirectiveTraceHeuristic);
        this.fTCDirectiveTraceCountLimit.performApply(configuration);
        this.fTCDirectiveTraceSizeLimit.performApply(configuration);
        this.fTCCoverageHeight.performApply(configuration);
        this.fTCCoverageHeightReachedLimit.performApply(configuration);
        this.fTCHitStronglyRandom.performApply(configuration);
        this.fTCHitStronglyCount.performApply(configuration);
        this.fTCHitWeaklyRandom.performApply(configuration);
        this.fTCHitWeaklyCount.performApply(configuration);
        this.fTCHitOtherRandom.performApply(configuration);
        this.fTCHitOtherCount.performApply(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.performApplyExploration(configuration);
        this.performApplyHoJ(configuration);
        this.performApplyTC(configuration);
    }

    public String getName() {
        return this.fTabName;
    }

    public void setTabName(String tabName) {
        this.fTabName = tabName;
    }

    private class TabListener
    extends SelectionAdapter
    implements ModifyListener {
        private TabListener() {
        }

        public void modifyText(ModifyEvent e) {
            ExpertTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == ExpertTab.this.fScopeGloballyButton) {
                ExpertTab.this.handleSearchScopeSelectionChange();
            } else if (e.getSource() == ExpertTab.this.fScopeLocallyButton) {
                ExpertTab.this.handleSearchScopeSelectionChange();
            } else if (e.getSource() == ExpertTab.this.fTCScopeCombo) {
                ExpertTab.this.handleScopeSelectionChange();
            } else if (e.getSource() == ExpertTab.this.fTCHeuristicStartCombo) {
                ExpertTab.this.handleHeuristicStartSelectionChange();
            } else if (e.getSource() == ExpertTab.this.fTCDirectiveTraceHeuristicCombo) {
                ExpertTab.this.handleDirectiveTraceHeuristicSelectionChange();
            }
        }
    }
}

