/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.designer.AST.ASN1.Ass_pard;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public abstract class ASN1Assignment
extends Assignment {
    private static final String NOTPARAMETERIZEDASSIGNMENT = "`{0}'' is not a parameterized assignment";
    public static final String UNREACHABLE = "The identifier `{0}'' is not reachable from TTCN-3";
    private static boolean markOccurrences;
    protected final Ass_pard assPard;

    protected ASN1Assignment(Identifier id, Ass_pard assPard) {
        super(id);
        this.assPard = assPard;
    }

    public final Ass_pard getAssPard() {
        return this.assPard;
    }

    protected abstract ASN1Assignment internalNewInstance(Identifier var1);

    public abstract void setRightScope(Scope var1);

    public final ASN1Assignment newInstance(Module module) {
        if (null == this.assPard) {
            if (null != this.location) {
                this.location.reportSemanticError(MessageFormat.format(NOTPARAMETERIZEDASSIGNMENT, this.getFullName()));
            }
            return null;
        }
        String newName = this.getIdentifier().getAsnName() + "." + module.getIdentifier().getAsnName() + ".inst";
        newName = newName + this.assPard.newInstanceNumber(module);
        return this.internalNewInstance(new Identifier(Identifier.Identifier_type.ID_ASN, newName));
    }

    public final void checkTTCNIdentifier() {
        if (null == this.myScope || null == this.getIdentifier()) {
            return;
        }
        Module myModule = this.myScope.getModuleScope();
        if (!this.getIdentifier().getHasValid(Identifier.Identifier_type.ID_TTCN) && this.myScope.getParentScope().equals(myModule) && null != myModule.getIdentifier() && '<' != myModule.getIdentifier().getDisplayName().charAt(0)) {
            this.location.reportSemanticWarning(MessageFormat.format(UNREACHABLE, this.getIdentifier().getDisplayName()));
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (null != this.assPard) {
            this.assPard.check(timestamp);
            this.lastTimeChecked = timestamp;
        }
    }

    public boolean isAssignmentType(CompilationTimeStamp timestamp, Assignment.Assignment_type assignmentType, IReferenceChain referenceChain) {
        return this.getAssignmentType().equals(assignmentType);
    }

    public Location getLikelyLocation() {
        return this.getLocation();
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.assPard == null) {
            return;
        }
        this.assPard.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    public boolean shouldMarkOccurrences() {
        return markOccurrences;
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.identifier != null && !this.identifier.accept(v)) {
            return false;
        }
        return this.assPard == null || this.assPard.accept(v);
    }

    static {
        final IPreferencesService prefService = Platform.getPreferencesService();
        markOccurrences = prefService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.markOccurrencesAsn1Assignments", false, null);
        Activator activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if ("org.eclipse.titan.designer.markOccurrencesAsn1Assignments".equals(property)) {
                        markOccurrences = prefService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.markOccurrencesAsn1Assignments", false, null);
                    }
                }
            });
        }
    }
}

