/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClass_Definition;
import org.eclipse.titan.designer.AST.ASN1.TableConstraint;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.CompFieldMap;
import org.eclipse.titan.designer.AST.TTCN3.values.Choice_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Open_Type
extends ASN1Type {
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for union type `{1}''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for union type `{0}''";
    private static final String ONEFIELDEXPECTED = "A template for union type must contain exactly one selected field";
    private static final String REFERENCETONONEXISTENTFIELD = "Reference to non-existent field `{0}'' in union template for type `{1}''";
    private static final String CHOICEEXPECTED = "CHOICE value was expected for type `{0}''";
    private static final String UNIONEXPECTED = "Union value was expected for type `{0}''";
    private static final String NONEXISTENTCHOICE = "Reference to a non-existent alternative `{0}'' in CHOICE value for type `{1}''";
    private static final String NONEXISTENTUNION = "Reference to a non-existent field `{0}'' in union value for type `{1}''";
    private CompFieldMap compFieldMap = new CompFieldMap();
    private final ObjectClass_Definition objectClass;
    private final Identifier fieldName;
    private TableConstraint myTableConstraint;

    public Open_Type(ObjectClass_Definition objectClass, Identifier identifier) {
        this.objectClass = objectClass;
        this.fieldName = identifier;
        this.compFieldMap.setMyType(this);
        this.compFieldMap.setFullNameParent(this);
        if (null != objectClass) {
            objectClass.setFullNameParent(this);
        }
        this.isErroneous = true;
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_OPENTYPE;
    }

    @Override
    public IASN1Type newInstance() {
        return new Open_Type(this.objectClass, this.fieldName);
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_TTCN3_CHOICE;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.compFieldMap) {
            this.compFieldMap.setMyScope(scope);
        }
    }

    public ObjectClass_Definition getMyObjectClass() {
        return this.objectClass;
    }

    public Identifier getObjectClassFieldName() {
        return this.fieldName;
    }

    public void setMyTableConstraint(TableConstraint constraint) {
        this.myTableConstraint = constraint;
    }

    public void addComponent(CompField field) {
        if (null != field && null != this.compFieldMap) {
            this.compFieldMap.addComp(field);
        }
    }

    public boolean hasComponentWithName(Identifier identifier) {
        return null != this.compFieldMap && null != this.compFieldMap.getCompWithName(identifier);
    }

    public CompField getComponentByName(Identifier identifier) {
        if (null != this.compFieldMap) {
            return this.compFieldMap.getCompWithName(identifier);
        }
        return null;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == otherType;
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType temp = type.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == temp;
    }

    @Override
    public String getTypename() {
        return "open type";
    }

    @Override
    public String getFullName() {
        if (null == this.getNameParent()) {
            return this.getTypename();
        }
        return super.getFullName();
    }

    @Override
    public String getOutlineIcon() {
        return "asn1_opentype.gif";
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        Map<String, CompField> map = this.compFieldMap.getComponentFieldMap(timestamp);
        if (referenceChain.add(this) && 1 == map.size()) {
            for (CompField compField : map.values()) {
                Type type = compField.getType();
                if (null == type) continue;
                referenceChain.markState();
                type.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    public void clear() {
        this.lastTimeChecked = null;
        this.compFieldMap = new CompFieldMap();
        this.compFieldMap.setMyType(this);
        this.compFieldMap.setFullNameParent(this);
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isErroneous = true;
        this.compFieldMap.check(timestamp);
        if (null != this.constraints) {
            this.constraints.check(timestamp);
        }
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (null == last || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case SEQUENCE_VALUE: {
                if (value.isAsn()) {
                    value.getLocation().reportSemanticError(MessageFormat.format(CHOICEEXPECTED, this.getFullName()));
                    value.setIsErroneous(true);
                    break;
                }
                if ((last = last.setValuetype(timestamp, IValue.Value_type.CHOICE_VALUE)).getIsErroneous(timestamp)) break;
                this.checkThisValueChoice(timestamp, (Choice_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.str_elem);
                break;
            }
            case CHOICE_VALUE: {
                this.checkThisValueChoice(timestamp, (Choice_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.str_elem);
                break;
            }
            default: {
                if (value.isAsn()) {
                    value.getLocation().reportSemanticError(MessageFormat.format(CHOICEEXPECTED, this.getFullName()));
                } else {
                    value.getLocation().reportSemanticError(MessageFormat.format(UNIONEXPECTED, this.getFullName()));
                }
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
    }

    private void checkThisValueChoice(CompilationTimeStamp timestamp, Choice_Value value, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean strElem) {
        CompField field;
        Identifier name = value.getName();
        if (!this.hasComponentWithName(name)) {
            if (value.isAsn()) {
                value.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTCHOICE, name.getDisplayName(), this.getFullName()));
                this.setIsErroneous(true);
            } else {
                value.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTUNION, name.getDisplayName(), this.getFullName()));
                this.setIsErroneous(true);
            }
        }
        if (null != (field = this.getComponentByName(name))) {
            Type alternativeType = field.getType();
            IValue alternativeValue = value.getValue();
            if (null == alternativeValue) {
                return;
            }
            alternativeValue.setMyGovernor(alternativeType);
            alternativeValue = alternativeType.checkThisValueRef(timestamp, alternativeValue);
            alternativeType.checkThisValue(timestamp, alternativeValue, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, false, true, false, strElem));
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        if (ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST.equals((Object)template.getTemplatetype())) {
            Named_Template_List namedTemplateList = (Named_Template_List)template;
            int nofTemplates = namedTemplateList.getNofTemplates();
            if (nofTemplates != 1) {
                template.getLocation().reportSemanticError(ONEFIELDEXPECTED);
            }
            for (int i = 0; i < nofTemplates; ++i) {
                Type fieldType;
                NamedTemplate namedTemplate = namedTemplateList.getTemplateByIndex(i);
                Identifier name = namedTemplate.getName();
                CompField field = this.compFieldMap.getCompWithName(name);
                if (field == null || (fieldType = field.getType()) == null || fieldType.getIsErroneous(timestamp)) continue;
                ITTCN3Template namedTemplateTemplate = namedTemplate.getTemplate();
                namedTemplateTemplate.setMyGovernor(fieldType);
                namedTemplateTemplate = fieldType.checkThisTemplateRef(timestamp, namedTemplateTemplate);
                ITTCN3Template.Completeness_type completeness = namedTemplateList.getCompletenessConditionChoice(timestamp, isModified, name);
                namedTemplateTemplate.checkThisTemplateGeneric(timestamp, fieldType, ITTCN3Template.Completeness_type.MAY_INCOMPLETE.equals((Object)completeness), false, false, true, implicitOmit);
            }
        } else {
            template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(MessageFormat.format(LENGTHRESTRICTIONNOTALLOWED, this.getTypename()));
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                Expected_Value_type internalExpectation;
                Identifier id = subreference.getId();
                CompField compField = this.compFieldMap.getCompWithName(id);
                if (compField == null) {
                    reference.setIsErroneous(true);
                    return this;
                }
                Expected_Value_type expected_Value_type = internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
                if (interruptIfOptional && compField.isOptional()) {
                    return null;
                }
                return compField.getType().getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("open type");
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                CompField compField = this.compFieldMap.getCompWithName(subreference.getId());
                if (compField == null) {
                    return;
                }
                Type type = compField.getType();
                if (type != null) {
                    type.addProposal(propCollector, i + 1);
                }
            } else {
                List<CompField> compFields = this.compFieldMap.getComponentsWithPrefix(subreference.getId().getName());
                for (CompField compField : compFields) {
                    String proposalKind = compField.getType().getProposalDescription(new StringBuilder()).toString();
                    propCollector.addProposal(compField.getIdentifier(), " - " + proposalKind, ImageCache.getImage(compField.getOutlineIcon()), proposalKind);
                }
            }
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                CompField compField = this.compFieldMap.getCompWithName(subreference.getId());
                if (compField == null) {
                    return;
                }
                Type type = compField.getType();
                if (type != null) {
                    type.addDeclaration(declarationCollector, i + 1);
                }
            } else {
                List<CompField> compFields = this.compFieldMap.getComponentsWithPrefix(subreference.getId().getName());
                for (CompField compField : compFields) {
                    declarationCollector.addDeclaration(compField.getIdentifier().getDisplayName(), compField.getIdentifier().getLocation(), this);
                }
            }
        }
    }

    @Override
    public void getEnclosingField(int offset, ReferenceFinder rf) {
        if (this.compFieldMap == null) {
            return;
        }
        this.compFieldMap.getEnclosingField(offset, rf);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.compFieldMap != null) {
            this.compFieldMap.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.objectClass != null) {
            // empty if block
        }
        if (this.myTableConstraint != null) {
            // empty if block
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.compFieldMap != null && !this.compFieldMap.accept(v)) {
            return false;
        }
        if (this.objectClass != null && !this.objectClass.accept(v)) {
            return false;
        }
        if (this.fieldName != null && !this.fieldName.accept(v)) {
            return false;
        }
        return this.myTableConstraint == null || this.myTableConstraint.accept(v);
    }
}

