/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.TableConstraint;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Constraint;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Constraints
extends ASTNode {
    private List<Constraint> constraints;

    public Constraints newInstance() {
        Constraints temp = new Constraints();
        if (null != this.constraints) {
            for (Constraint constraint : this.constraints) {
                temp.constraints.add(constraint.newInstance());
            }
        }
        return temp;
    }

    public void addConstraint(Constraint constraint) {
        if (null == constraint) {
            return;
        }
        if (null == this.constraints) {
            this.constraints = new ArrayList<Constraint>(1);
        }
        this.constraints.add(constraint);
    }

    public int getNofConstraints() {
        if (null == this.constraints) {
            return 0;
        }
        return this.constraints.size();
    }

    public Constraint getConstraintByIndex(int index) {
        if (null == this.constraints) {
            return null;
        }
        return this.constraints.get(index);
    }

    public TableConstraint getTableConstraint() {
        if (null == this.constraints) {
            return null;
        }
        int size = this.constraints.size();
        for (int i = 0; i < size; ++i) {
            Constraint constraint = this.constraints.get(i);
            if (!Constraint.Constraint_type.CT_TABLE.equals((Object)constraint.getConstraintType())) continue;
            return (TableConstraint)constraint;
        }
        return null;
    }

    public void setMyType(Type type) {
        if (null == this.constraints) {
            return;
        }
        int size = this.constraints.size();
        for (int i = 0; i < size; ++i) {
            this.constraints.get(i).setMyType(type);
        }
    }

    public void check(CompilationTimeStamp timestamp) {
        if (null == this.constraints) {
            return;
        }
        int size = this.constraints.size();
        for (int i = 0; i < size; ++i) {
            this.constraints.get(i).check(timestamp);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.constraints == null) {
            return;
        }
        for (Constraint c : this.constraints) {
            c.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.constraints != null) {
            for (Constraint c : this.constraints) {
                if (c.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

