/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.attributes.FunctionTypeMappingTarget;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TypeMappingTarget;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TypeMappingTargets;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class TypeMapping
extends ASTNode
implements ILocateableNode {
    private static final String FULLNAMEPART = ".<source_type>";
    private final Type source_type;
    private final TypeMappingTargets mappingTargets;
    private CompilationTimeStamp lastTimeChecked;
    private Location location = NULL_Location.INSTANCE;

    public TypeMapping(Type type, TypeMappingTargets mappingTargets) {
        this.source_type = type;
        this.mappingTargets = mappingTargets;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public Type getSourceType() {
        return this.source_type;
    }

    public int getNofTargets() {
        return this.mappingTargets.getNofTargets();
    }

    public TypeMappingTarget getTargetByIndex(int index) {
        return this.mappingTargets.getTargetByIndex(index);
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.source_type == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.source_type != null) {
            this.source_type.setMyScope(scope);
        }
        this.mappingTargets.setMyScope(scope);
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.source_type != null) {
            this.source_type.check(timestamp);
        }
        int nofTargets = this.mappingTargets.getNofTargets();
        boolean hasSliding = false;
        boolean hasNonSliding = false;
        int size = nofTargets;
        block10: for (int i = 0; i < size; ++i) {
            TypeMappingTarget target = this.mappingTargets.getTargetByIndex(i);
            target.check(timestamp, this.source_type);
            if (nofTargets <= 1) continue;
            switch (target.getTypeMappingType()) {
                case DISCARD: {
                    if (hasSliding) {
                        target.getLocation().reportSemanticError("Mapping `discard' cannot be used if functions with `prototype(sliding)' are referred from the same source type");
                        continue block10;
                    }
                    if (i >= nofTargets - 1) continue block10;
                    target.getLocation().reportSemanticError("Mapping `discard' must be the last target of the source type");
                    continue block10;
                }
                case FUNCTION: {
                    String message;
                    Def_Function function = ((FunctionTypeMappingTarget)target).getFunction();
                    Def_Extfunction externalFunction = ((FunctionTypeMappingTarget)target).getExternalFunction();
                    Def_Function.EncodingPrototype_type prototype = Def_Function.EncodingPrototype_type.NONE;
                    if (function != null) {
                        prototype = function.getPrototype();
                    } else {
                        if (externalFunction == null) continue block10;
                        prototype = externalFunction.getPrototype();
                    }
                    switch (prototype) {
                        case NONE: {
                            continue block10;
                        }
                        case BACKTRACK: {
                            hasNonSliding = true;
                            continue block10;
                        }
                        case SLIDING: {
                            hasSliding = true;
                            continue block10;
                        }
                    }
                    if (function != null) {
                        message = MessageFormat.format("The referenced {0} must have the attribute `prototype(backtrack)'' or `prototype(sliding)'' when more than one targets are present", function.getDescription());
                        target.getLocation().reportSemanticError(message);
                        continue block10;
                    }
                    if (externalFunction == null) continue block10;
                    message = MessageFormat.format("The referenced {0} must have the attribute `prototype(backtrack)'' or `prototype(sliding)'' when more than one targets are present", externalFunction.getDescription());
                    target.getLocation().reportSemanticError(message);
                    continue block10;
                }
                case DECODE: {
                    continue block10;
                }
                default: {
                    target.getLocation().reportSemanticError(MessageFormat.format("The type of the mapping must be `function', `decode', or `discard' instead of {0} when more than one targets are present", target.getMappingName()));
                }
            }
        }
        if (hasSliding && hasNonSliding) {
            this.location.reportSemanticError("If one of the mappings refers to a function with attribute `prototype(sliding)'then mappings of this source type cannot refer to functions with attribute `prototype(backtrack)'");
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.source_type != null) {
            this.source_type.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.mappingTargets != null) {
            this.mappingTargets.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.source_type != null && !this.source_type.accept(v)) {
            return false;
        }
        return this.mappingTargets == null || this.mappingTargets.accept(v);
    }
}

