/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.common.parsers.TITANMarker;
import org.eclipse.titan.common.parsers.TitanListener;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IAppendableSyntax;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErroneousAttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErroneousAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifier;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3CharstringLexer;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Lexer;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;

public abstract class Definition
extends Assignment
implements IAppendableSyntax,
IIncrementallyUpdateable {
    private static final String SHOULD_BE_PRIVATE = "{0} is referenced only locally, it should be private";
    protected WithAttributesPath withAttributesPath = null;
    protected ErroneousAttributes erroneousAttributes = null;
    private VisibilityModifier visibilityModifier;
    private Location commentLocation = null;
    private Location cumulativeDefinitionLocation = null;
    public List<String> referingHere = new ArrayList<String>();
    private static boolean markOccurrences;
    private static String unusedLocalDefinitionSeverity;
    private static String unusedGlobalDefinitionSeverity;
    private static String nonPrivatePrivateSeverity;

    protected static String getUnusedLocalDefinitionSeverity() {
        return unusedLocalDefinitionSeverity;
    }

    protected Definition(Identifier identifier) {
        super(identifier);
    }

    public final void setVisibility(VisibilityModifier modifier) {
        this.visibilityModifier = modifier;
    }

    public final VisibilityModifier getVisibilityModifier() {
        if (this.visibilityModifier == null) {
            return VisibilityModifier.Public;
        }
        return this.visibilityModifier;
    }

    public void setWithAttributes(MultipleWithAttributes attributes) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        if (attributes != null) {
            this.withAttributesPath.setWithAttributes(attributes);
            for (int i = 0; i < attributes.getNofElements(); ++i) {
                Qualifiers qs = attributes.getAttribute(i).getQualifiers();
                if (qs == null) continue;
                for (int j = 0; j < qs.getNofQualifiers(); ++j) {
                    qs.getQualifierByIndex(j).setDefinition(this);
                }
            }
        }
    }

    public Location getCumulativeDefinitionLocation() {
        if (this.cumulativeDefinitionLocation != null) {
            return this.cumulativeDefinitionLocation;
        }
        return this.getLocation();
    }

    public void setCumulativeDefinitionLocation(Location location) {
        this.cumulativeDefinitionLocation = location;
    }

    public WithAttributesPath getAttributePath() {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        return this.withAttributesPath;
    }

    public void setAttributeParentPath(WithAttributesPath parent) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        this.withAttributesPath.setAttributeParent(parent);
    }

    public boolean hasImplicitOmitAttribute(CompilationTimeStamp timestamp) {
        if (this.withAttributesPath == null) {
            return false;
        }
        List<SingleWithAttribute> realAttributes = this.withAttributesPath.getRealAttributes(timestamp);
        for (int i = realAttributes.size() - 1; i >= 0; --i) {
            SingleWithAttribute tempAttribute = realAttributes.get(i);
            if (tempAttribute == null || !SingleWithAttribute.Attribute_Type.Optional_Attribute.equals((Object)tempAttribute.getAttributeType())) continue;
            String tempSpecification = tempAttribute.getAttributeSpecification().getSpecification();
            if ("implicit omit".equals(tempSpecification)) {
                return true;
            }
            if (!"explicit omit".equals(tempSpecification)) continue;
            return false;
        }
        return false;
    }

    @Override
    public Location getCommentLocation() {
        return this.commentLocation;
    }

    public void setCommentLocation(Location commentLocation) {
        this.commentLocation = commentLocation;
    }

    public abstract String getProposalKind();

    @Override
    public String getProposalDescription() {
        return this.getProposalKind();
    }

    protected void checkErroneousAttributes(CompilationTimeStamp timestamp) {
        this.erroneousAttributes = null;
        if (this.withAttributesPath != null) {
            MultipleWithAttributes attribs = this.withAttributesPath.getAttributes();
            if (attribs == null) {
                return;
            }
            for (int i = 0; i < attribs.getNofElements(); ++i) {
                SingleWithAttribute actualAttribute = attribs.getAttribute(i);
                if (actualAttribute.getAttributeType() != SingleWithAttribute.Attribute_Type.Erroneous_Attribute) continue;
                int nofQualifiers = actualAttribute.getQualifiers() == null ? 0 : actualAttribute.getQualifiers().getNofQualifiers();
                ArrayList<IType> referencedTypeArray = new ArrayList<IType>(nofQualifiers);
                ArrayList<ArrayList<Integer>> subrefsArrayArray = new ArrayList<ArrayList<Integer>>(nofQualifiers);
                ArrayList<ArrayList<IType>> typeArrayArray = new ArrayList<ArrayList<IType>>(nofQualifiers);
                if (nofQualifiers == 0) {
                    actualAttribute.getLocation().reportSemanticError("At least one qualifier must be specified for the `erroneous' attribute");
                } else {
                    for (int qi = 0; qi < nofQualifiers; ++qi) {
                        Qualifier actualQualifier = actualAttribute.getQualifiers().getQualifierByIndex(qi);
                        IType definitionType = this.getType(timestamp);
                        Reference reference = new Reference(null);
                        reference.addSubReference(new FieldSubReference(this.identifier));
                        for (int ri = 0; ri < actualQualifier.getNofSubReferences(); ++ri) {
                            reference.addSubReference(actualQualifier.getSubReferenceByIndex(ri));
                        }
                        reference.setLocation(actualQualifier.getLocation());
                        reference.setMyScope(this.getMyScope());
                        IType fieldType = definitionType.getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_CONSTANT, false);
                        ArrayList<Integer> subrefsArray = null;
                        ArrayList<IType> typeArray = null;
                        if (fieldType != null) {
                            subrefsArray = new ArrayList<Integer>();
                            typeArray = new ArrayList<IType>();
                            boolean validIndexes = definitionType.getSubrefsAsArray(timestamp, reference, 1, subrefsArray, typeArray);
                            if (!validIndexes) {
                                fieldType = null;
                                subrefsArray = null;
                                typeArray = null;
                            }
                            if (reference.refersToStringElement()) {
                                actualQualifier.getLocation().reportSemanticError("Reference to a string element cannot be used in this context");
                                fieldType = null;
                                subrefsArray = null;
                                typeArray = null;
                            }
                        }
                        referencedTypeArray.add(fieldType);
                        subrefsArrayArray.add(subrefsArray);
                        typeArrayArray.add(typeArray);
                    }
                }
                ErroneousAttributeSpecification errAttributeSpecification = Definition.parseErrAttrSpecString(actualAttribute.getAttributeSpecification());
                if (errAttributeSpecification == null) continue;
                if (this.erroneousAttributes == null) {
                    this.erroneousAttributes = new ErroneousAttributes(this.getType(timestamp));
                }
                this.erroneousAttributes.addSpecification(errAttributeSpecification);
                errAttributeSpecification.check(timestamp, this.getMyScope());
                for (int qi = 0; qi < nofQualifiers; ++qi) {
                    if (referencedTypeArray.get(qi) == null || errAttributeSpecification.getIndicator() == ErroneousAttributeSpecification.Indicator_Type.Invalid_Indicator) continue;
                    Qualifier actualQualifier = actualAttribute.getQualifiers().getQualifierByIndex(qi);
                    this.erroneousAttributes.addFieldErr(actualQualifier, errAttributeSpecification, (List)subrefsArrayArray.get(qi), (List)typeArrayArray.get(qi));
                }
            }
            if (this.erroneousAttributes != null) {
                this.erroneousAttributes.check(timestamp);
            }
        }
    }

    public boolean checkIdentical(CompilationTimeStamp timestamp, Definition definition) {
        return false;
    }

    protected final void postCheckPrivateness() {
        if (this.isUsed && this.referingHere.size() == 1 && !VisibilityModifier.Private.equals((Object)this.visibilityModifier) && !this.isLocal()) {
            String moduleName = this.getMyScope().getModuleScope().getName();
            if (this.referingHere.get(0).equals(moduleName)) {
                this.identifier.getLocation().reportConfigurableSemanticProblem(nonPrivatePrivateSeverity, MessageFormat.format(SHOULD_BE_PRIVATE, this.identifier.getDisplayName()));
            }
        }
    }

    @Override
    public void postCheck() {
        if (!this.isUsed) {
            if (this.isLocal()) {
                this.identifier.getLocation().reportConfigurableSemanticProblem(unusedLocalDefinitionSeverity, MessageFormat.format("The {0} seems to be never used locally", this.getDescription()));
            } else {
                this.identifier.getLocation().reportConfigurableSemanticProblem(unusedGlobalDefinitionSeverity, MessageFormat.format("The {0} seems to be never used globally", this.getDescription()));
            }
        }
    }

    @Override
    public boolean isLocal() {
        if (this.myScope == null) {
            return false;
        }
        for (Scope scope = this.myScope; scope != null; scope = scope.getParentScope()) {
            if (!(scope instanceof StatementBlock)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        String proposalKind = this.getProposalKind();
        propCollector.addProposal(this.identifier, " - " + proposalKind, ImageCache.getImage(this.getOutlineIcon()), proposalKind);
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
    }

    public TemplateRestriction.Restriction_type getTemplateRestriction() {
        return TemplateRestriction.Restriction_type.TR_NONE;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (this.isLocal()) {
            return result;
        }
        if (this.withAttributesPath == null || this.withAttributesPath.getAttributes() == null) {
            result.add(155);
        }
        return result;
    }

    @Override
    public List<Integer> getPossiblePrefixTokens() {
        if (this.isLocal()) {
            ArrayList<Integer> result = new ArrayList<Integer>(2);
            result.add(26);
            result.add(151);
            return result;
        }
        if (this.visibilityModifier == null) {
            ArrayList<Integer> result = new ArrayList<Integer>(3);
            result.add(110);
            result.add(53);
            result.add(112);
            return result;
        }
        return new ArrayList<Integer>(0);
    }

    @Override
    public abstract void updateSyntax(TTCN3ReparseUpdater var1, boolean var2) throws ReParseException;

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.withAttributesPath != null) {
            this.withAttributesPath.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.erroneousAttributes != null) {
            this.erroneousAttributes.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.identifier != null && !this.identifier.accept(v)) {
            return false;
        }
        if (this.withAttributesPath != null && !this.withAttributesPath.accept(v)) {
            return false;
        }
        return this.erroneousAttributes == null || this.erroneousAttributes.accept(v);
    }

    @Override
    public boolean shouldMarkOccurrences() {
        return markOccurrences;
    }

    private static ErroneousAttributeSpecification parseErrAttrSpecString(AttributeSpecification aAttrSpec) {
        Location loc;
        ErroneousAttributeSpecification returnValue = null;
        Location location = aAttrSpec.getLocation();
        String code = aAttrSpec.getSpecification();
        if (code == null) {
            return null;
        }
        code = Ttcn3CharstringLexer.parseCharstringValue(code, location);
        StringReader reader = new StringReader(code);
        UnbufferedCharStream charStream = new UnbufferedCharStream((Reader)reader);
        Ttcn3Lexer lexer = new Ttcn3Lexer((CharStream)charStream);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        lexer.setCharPositionInLine(0);
        TitanListener parserListener = new TitanListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)parserListener);
        BufferedTokenStream tokens = new BufferedTokenStream((TokenSource)lexer);
        Ttcn3Reparser parser = new Ttcn3Reparser((TokenStream)tokens);
        IFile file = (IFile)location.getFile();
        parser.setActualFile(file);
        parser.setOffset(location.getOffset() + 1);
        parser.setLine(location.getLine());
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)parserListener);
        MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflySyntacticMarker", location.getFile(), location.getOffset(), location.getEndOffset());
        returnValue = parser.pr_ErroneousAttributeSpec().errAttrSpec;
        List<SyntacticErrorStorage> errors = parser.getErrors();
        List<TITANMarker> warnings = parser.getWarnings();
        ArrayList<TITANMarker> unsupportedConstructs = parser.getUnsupportedConstructs();
        if (errors != null) {
            for (int i = 0; i < errors.size(); ++i) {
                Location temp = new Location(location);
                temp.setOffset(temp.getOffset() + 1);
                ParserMarkerSupport.createOnTheFlySyntacticMarker(file, errors.get(i), 2, temp);
            }
        }
        if (warnings != null) {
            for (TITANMarker marker : warnings) {
                if (!file.isAccessible()) continue;
                loc = new Location((IResource)file, marker.getLine(), marker.getOffset(), marker.getEndOffset());
                loc.reportExternalProblem(marker.getMessage(), marker.getSeverity(), "org.eclipse.titan.designer.ontheflySyntacticMarker");
            }
        }
        if (unsupportedConstructs != null) {
            for (TITANMarker marker : unsupportedConstructs) {
                if (!file.isAccessible()) continue;
                loc = new Location((IResource)file, marker.getLine(), marker.getOffset(), marker.getEndOffset());
                loc.reportExternalProblem(marker.getMessage(), marker.getSeverity(), "org.eclipse.titan.designer.ontheflySyntacticMarker");
            }
        }
        return returnValue;
    }

    static {
        final IPreferencesService ps = Platform.getPreferencesService();
        if (ps != null) {
            markOccurrences = ps.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.markOccurrencesTtcn3Assignments", false, null);
            unusedLocalDefinitionSeverity = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportUnusedLocalDefinition", "warning", null);
            unusedGlobalDefinitionSeverity = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportUnusedGlobalDefinition", "warning", null);
            nonPrivatePrivateSeverity = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportNonPrivatePrivate", "ignore", null);
            Activator activator = Activator.getDefault();
            if (activator != null) {
                activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        String property = event.getProperty();
                        if ("org.eclipse.titan.designer.markOccurrencesTtcn3Assignments".equals(property)) {
                            markOccurrences = ps.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.markOccurrencesTtcn3Assignments", false, null);
                            return;
                        }
                        if ("org.eclipse.titan.designer.reportUnusedLocalDefinition".equals(property)) {
                            unusedLocalDefinitionSeverity = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportUnusedLocalDefinition", "warning", null);
                        }
                        if ("org.eclipse.titan.designer.reportUnusedGlobalDefinition".equals(property)) {
                            unusedGlobalDefinitionSeverity = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportUnusedGlobalDefinition", "warning", null);
                        }
                        if ("org.eclipse.titan.designer.reportNonPrivatePrivate".equals(property)) {
                            nonPrivatePrivateSeverity = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportNonPrivatePrivate", "ignore", null);
                        }
                    }
                });
            }
        }
    }
}

