/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCases;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SelectCase_Statement
extends Statement {
    private static final String UNDETERMINABLETYPE = "Cannot determine the type of the expression";
    private static final String FULLNAMEPART1 = ".expression";
    private static final String FULLNAMEPART2 = ".selectcases";
    private static final String STATEMENT_NAME = "select-case";
    private final Value expression;
    private final SelectCases selectcases;

    public SelectCase_Statement(Value expression, SelectCases selectcases) {
        this.expression = expression;
        this.selectcases = selectcases;
        if (expression != null) {
            expression.setFullNameParent(this);
        }
        selectcases.setFullNameParent(this);
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_SELECT;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.expression == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.selectcases == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.expression != null) {
            this.expression.setMyScope(scope);
        }
        this.selectcases.setMyScope(scope);
    }

    @Override
    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        super.setMyStatementBlock(statementBlock, index);
        this.selectcases.setMyStatementBlock(statementBlock, index);
    }

    @Override
    public void setMyDefinition(Definition definition) {
        this.selectcases.setMyDefinition(definition);
    }

    @Override
    public void setMyAltguards(AltGuards altGuards) {
        this.selectcases.setMyAltguards(altGuards);
    }

    @Override
    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        return this.selectcases.hasReturn(timestamp);
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.expression == null) {
            return;
        }
        IValue temp = this.expression.setLoweridToReference(timestamp);
        IType governor = temp.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        if (governor == null) {
            if (!temp.getIsErroneous(timestamp)) {
                this.expression.getLocation().reportSemanticError(UNDETERMINABLETYPE);
            }
        } else {
            temp = governor.checkThisValueRef(timestamp, this.expression);
            governor.checkThisValue(timestamp, temp, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, true, false, false));
        }
        this.selectcases.check(timestamp, governor);
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void checkAllowedInterleave() {
        this.selectcases.checkAllowedInterleave();
    }

    @Override
    public void postCheck() {
        this.selectcases.postCheck();
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.expression != null) {
            this.expression.updateSyntax(reparser, false);
            reparser.updateLocation(this.expression.getLocation());
        }
        if (this.selectcases != null) {
            this.selectcases.updateSyntax(reparser, false);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.expression != null) {
            this.expression.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.selectcases != null) {
            this.selectcases.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.expression != null && !this.expression.accept(v)) {
            return false;
        }
        return this.selectcases == null || this.selectcases.accept(v);
    }

    public Value getExpression() {
        return this.expression;
    }

    public SelectCases getSelectCases() {
        return this.selectcases;
    }
}

