/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.templates.AllElementsFrom;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITemplateListItem;
import org.eclipse.titan.designer.AST.TTCN3.templates.ListOfTemplates;
import org.eclipse.titan.designer.AST.TTCN3.templates.PermutationMatch_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateBody;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public abstract class CompositeTemplate
extends TTCN3Template {
    private static final String FULLNAMEPART = ".list_item(";
    protected final ListOfTemplates templates;

    public CompositeTemplate(ListOfTemplates templates) {
        this.templates = templates;
        int size = templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            templates.getTemplateByIndex(i).setFullNameParent(this);
        }
    }

    public ITemplateListItem getTemplateByIndex(int index) {
        return this.templates.getTemplateByIndex(index);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.templates.setMyScope(scope);
    }

    public int getNofTemplates() {
        return this.templates.getNofTemplates();
    }

    public int getNofTemplatesNotAnyornone(CompilationTimeStamp timestamp) {
        int result = 0;
        int size = this.templates.getNofTemplates();
        block5: for (int i = 0; i < size; ++i) {
            ITTCN3Template template = this.templates.getTemplateByIndex(i);
            ITTCN3Template.Template_type ttype = template.getTemplatetype();
            switch (ttype) {
                case ANY_OR_OMIT: {
                    continue block5;
                }
                case PERMUTATION_MATCH: {
                    if (template instanceof TemplateBody) {
                        template = ((TemplateBody)template).getTemplate();
                    }
                    result += ((PermutationMatch_Template)template).getNofTemplatesNotAnyornone(timestamp);
                    continue block5;
                }
                case ALLELEMENTSFROM: {
                    result += ((AllElementsFrom)template).getNofTemplatesNotAnyornone(timestamp);
                    continue block5;
                }
                default: {
                    ++result;
                }
            }
        }
        return result;
    }

    public boolean templateContainsAnyornone() {
        int size = this.templates.getNofTemplates();
        block4: for (int i = 0; i < size; ++i) {
            ITTCN3Template template = this.templates.getTemplateByIndex(i);
            switch (template.getTemplatetype()) {
                case ANY_OR_OMIT: {
                    return true;
                }
                case PERMUTATION_MATCH: {
                    if (template instanceof TemplateBody) {
                        template = ((TemplateBody)template).getTemplate();
                    }
                    if (!((PermutationMatch_Template)template).templateContainsAnyornone()) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean containsAnyornoneOrPermutation() {
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            ITemplateListItem template = this.templates.getTemplateByIndex(i);
            switch (template.getTemplatetype()) {
                case ANY_OR_OMIT: 
                case PERMUTATION_MATCH: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (this.templates.getTemplateByIndex(i) != child) continue;
            return builder.append(FULLNAMEPART).append(String.valueOf(i)).append(")");
        }
        return builder;
    }

    protected abstract String getNameForStringRep();

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getNameForStringRep() + "( ");
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            ITemplateListItem template = this.templates.getTemplateByIndex(i);
            builder.append(template.createStringRepresentation());
        }
        builder.append(" )");
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            int size = this.templates.getNofTemplates();
            for (int i = 0; i < size; ++i) {
                ITemplateListItem template = this.templates.getTemplateByIndex(i);
                if (template == null) continue;
                referenceChain.markState();
                template.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.updateSyntax(reparser, false);
            reparser.updateLocation(this.lengthRestriction.getLocation());
        }
        if (this.baseTemplate instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.baseTemplate)).updateSyntax(reparser, false);
            reparser.updateLocation(this.baseTemplate.getLocation());
        } else if (this.baseTemplate != null) {
            throw new ReParseException();
        }
        this.templates.updateSyntax(reparser, false);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.templates == null) {
            return;
        }
        this.templates.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.templates == null || this.templates.accept(v);
    }

    protected final boolean allowOmitInValueList(boolean allowOmit) {
        if (!allowOmit) {
            return false;
        }
        Location loc = this.getLocation();
        if (loc == null || loc instanceof NULL_Location) {
            return true;
        }
        IResource f = loc.getFile();
        if (f == null) {
            return true;
        }
        IProject project = f.getProject();
        if (project == null) {
            return true;
        }
        QualifiedName qn = new QualifiedName("org.eclipse.titan.designer.Properties.Project", "omitInValueList");
        try {
            String s = project.getPersistentProperty(qn);
            return "true".equals(s);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return true;
        }
    }
}

