/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.PatternString;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class UnivCharString_Pattern_Template
extends TTCN3Template {
    private PatternString patternstring;

    public UnivCharString_Pattern_Template() {
        this.patternstring = new PatternString(PatternString.PatternType.UNIVCHARSTRING_PATTERN);
    }

    public UnivCharString_Pattern_Template(PatternString ps) {
        this.patternstring = ps;
    }

    public PatternString getPatternstring() {
        return this.patternstring;
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.USTR_PATTERN;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous universal character string pattern";
        }
        return "universal character string pattern";
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("pattern \"");
        builder.append(this.patternstring.getFullString());
        builder.append('\"');
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    public boolean patternContainsAnyornoneSymbol() {
        return true;
    }

    public int getMinLengthOfPattern() {
        return 0;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return IType.Type_type.TYPE_UCHARSTRING;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        this.getLocation().reportSemanticError("A specific value expected instead of a universal charstring pattern");
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.patternstring != null) {
            this.patternstring.checkRecursions(timestamp, referenceChain);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.patternstring == null || this.patternstring.accept(v);
    }
}

