/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ITypeWithComponents;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.EnumItem;
import org.eclipse.titan.designer.AST.TTCN3.types.EnumerationItems;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class TTCN3_Enumerated_Type
extends Type
implements ITypeWithComponents {
    public static final String DUPLICATEENUMERATIONIDENTIFIERFIRST = "Duplicate enumeration identifier `{0}'' was first declared here";
    public static final String DUPLICATEENUMERATIONIDENTIFIERREPEATED = "Duplicate enumeration identifier `{0}'' was declared here again";
    public static final String DUPLICATEDENUMERATIONVALUEFIRST = "Value {0} is already assigned to `{1}''";
    public static final String DUPLICATEDENUMERATIONVALUEREPEATED = "Duplicate numeric value {0} for enumeration `{1}''";
    private static final String TTCN3ENUMERATEDVALUEEXPECTED = "Enumerated value was expected";
    private static final String ASN1ENUMERATEDVALUEEXPECTED = "ENUMERATED value was expected";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for enumerated type";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for enumerated type";
    private static final String LARGEINTEGERERROR = "Using a large integer value ({0}) as an ENUMERATED/enumerated value is not supported";
    private final EnumerationItems items;
    private Map<String, EnumItem> nameMap;

    public TTCN3_Enumerated_Type(EnumerationItems items) {
        this.items = items;
        if (items != null) {
            items.setFullNameParent(this);
        }
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_TTCN3_ENUMERATED;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.items != null) {
            this.items.setMyScope(scope);
        }
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == temp;
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        return this.isCompatible(timestamp, type, null, null, null);
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    @Override
    public String getOutlineIcon() {
        return "enumeration.gif";
    }

    public boolean hasEnumItemWithName(Identifier identifier) {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.nameMap.containsKey(identifier.getName());
    }

    public EnumItem getEnumItemWithName(Identifier identifier) {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.nameMap.get(identifier.getName());
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        Object item;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.parseAttributes(timestamp);
        this.nameMap = new HashMap<String, EnumItem>(this.items.getItems().size());
        HashMap<Long, Object> valueMap = new HashMap<Long, Object>(this.items.getItems().size());
        List<EnumItem> enumItems = this.items.getItems();
        int size2 = enumItems.size();
        for (int i = 0; i < size2; ++i) {
            item = enumItems.get(i);
            Identifier id = ((EnumItem)item).getId();
            String fieldName = id.getName();
            if (this.nameMap.containsKey(fieldName)) {
                this.nameMap.get(fieldName).getId().getLocation().reportSingularSemanticError(MessageFormat.format(DUPLICATEENUMERATIONIDENTIFIERFIRST, id.getDisplayName()));
                id.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEENUMERATIONIDENTIFIERREPEATED, id.getDisplayName()));
            } else {
                this.nameMap.put(fieldName, (EnumItem)item);
            }
            Value value = ((EnumItem)item).getValue();
            if (value == null || !((EnumItem)item).isOriginal()) continue;
            if (value.getIsErroneous(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)value.getValuetype())) {
                value.getLocation().reportSemanticError(MessageFormat.format("INTEGER value was expected for enumeration `{0}''", id.getDisplayName()));
                this.setIsErroneous(true);
                continue;
            }
            Integer_Value enumValue = (Integer_Value)value;
            if (!enumValue.isNative()) {
                enumValue.getLocation().reportSemanticError(MessageFormat.format(LARGEINTEGERERROR, value));
                this.setIsErroneous(true);
                continue;
            }
            Long enumLong = enumValue.getValue();
            if (valueMap.containsKey(enumLong)) {
                ((EnumItem)valueMap.get(enumLong)).getLocation().reportSingularSemanticError(MessageFormat.format(DUPLICATEDENUMERATIONVALUEFIRST, enumLong, ((EnumItem)valueMap.get(enumLong)).getId().getDisplayName()));
                value.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEDENUMERATIONVALUEREPEATED, enumLong, id.getDisplayName()));
                this.setIsErroneous(true);
                continue;
            }
            valueMap.put(enumLong, item);
        }
        if (!this.getIsErroneous(timestamp) && this.lastTimeChecked == null) {
            Long firstUnused = 0L;
            while (valueMap.containsKey(firstUnused)) {
                Long size2 = firstUnused;
                firstUnused = firstUnused + 1L;
                item = firstUnused;
            }
            int size3 = enumItems.size();
            for (int i = 0; i < size3; ++i) {
                EnumItem item2 = enumItems.get(i);
                if (item2.isOriginal()) continue;
                Value value = item2.getValue();
                if (value == null || ((Integer_Value)value).getValue() != firstUnused.longValue()) {
                    Integer_Value tempValue = new Integer_Value(firstUnused);
                    tempValue.setLocation(item2.getLocation());
                    item2.setValue(tempValue);
                }
                valueMap.put(firstUnused, item2);
                firstUnused = firstUnused + 1L;
                while (valueMap.containsKey(firstUnused)) {
                    Long l = firstUnused;
                    Long l2 = firstUnused = Long.valueOf(firstUnused + 1L);
                }
            }
        }
        valueMap.clear();
        this.lastTimeChecked = timestamp;
        this.checkSubtypeRestrictions(timestamp);
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_ENUM;
    }

    @Override
    public IValue checkThisValueRef(CompilationTimeStamp timestamp, IValue value) {
        if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)value.getValuetype()) && this.hasEnumItemWithName(((Undefined_LowerIdentifier_Value)value).getIdentifier())) {
            IValue temp = value.setValuetype(timestamp, IValue.Value_type.ENUMERATED_VALUE);
            temp.setMyGovernor(this);
            return temp;
        }
        return super.checkThisValueRef(timestamp, value);
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case ENUMERATED_VALUE: {
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(value.isAsn() ? ASN1ENUMERATEDVALUEEXPECTED : TTCN3ENUMERATEDVALUEEXPECTED);
                value.setIsErroneous(true);
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        if (!ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)template.getTemplatetype())) {
            template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName()));
            template.setIsErroneous(true);
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(LENGTHRESTRICTIONNOTALLOWED);
            template.setIsErroneous(true);
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("enumerated");
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
        if (subreferences.size() != 1 || propCollector.getReference().getModuleIdentifier() != null) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType()) && this.items != null) {
            this.items.addProposal(propCollector);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (i != 0 || subreferences.size() != 1 || declarationCollector.getReference().getModuleIdentifier() != null) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType()) && this.items != null) {
            this.items.addDeclaration(declarationCollector, i);
        }
    }

    public void addDeclaration(DeclarationCollector declarationCollector, int i, Location commentLocation) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (i != 0 || subreferences.size() != 1 || declarationCollector.getReference().getModuleIdentifier() != null) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType()) && this.items != null && commentLocation != null) {
            this.items.addDeclaration(declarationCollector, i, commentLocation);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean handled = false;
            if (this.items != null && reparser.envelopsDamage(this.items.getLocation())) {
                this.items.updateSyntax(reparser, true);
                reparser.updateLocation(this.items.getLocation());
                handled = true;
            }
            if (this.subType != null) {
                this.subType.updateSyntax(reparser, false);
                handled = true;
            }
            if (handled) {
                return;
            }
            throw new ReParseException();
        }
        if (this.items != null) {
            this.items.updateSyntax(reparser, false);
            reparser.updateLocation(this.items.getLocation());
        }
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void getEnclosingField(int offset, ReferenceFinder rf) {
        if (this.items == null) {
            return;
        }
        for (EnumItem enumItem : this.items.getItems()) {
            if (!enumItem.getLocation().containsOffset(offset)) continue;
            rf.type = this;
            rf.fieldId = enumItem.getId();
            return;
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.items != null) {
            this.items.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.items == null || this.items.accept(v);
    }

    @Override
    public Identifier getComponentIdentifierByName(Identifier identifier) {
        EnumItem enumItem = this.getEnumItemWithName(identifier);
        return enumItem == null ? null : enumItem.getId();
    }
}

