/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.OmitValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.CompFieldMap;
import org.eclipse.titan.designer.AST.TTCN3.types.SetOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.Omit_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Set_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class TTCN3_Set_Type
extends TTCN3_Set_Seq_Choice_BaseType {
    public static final String INCOMPLETEPRESENTERROR = "Not used symbol `-' is not allowed in this context";
    private static final String UNSUPPERTED_FIELDNAME = "Sorry, but it is not supported for set types to have a field with a name (`{0}'') which exactly matches the name of the type definition.";
    private static final String NONEMPTYEXPECTED = "A non-empty value was expected for type `{0}''";
    private static final String VALUELISTNOTATIONERRORASN1 = "Value list notation cannot be used for SET type `{0}''";
    private static final String SETVALUEXPECTEDASN1 = "SET value was expected for type `{0}''";
    private static final String NONEXISTENTFIELDASN1 = "Reference to a non-existent component `{0}'' of SET type `{1}''";
    private static final String DUPLICATEFIELDFIRSTASN1 = "Component `{0}'' is already given here";
    private static final String DUPLICATEFIELDAGAINASN1 = "Duplicated SET component `{0}''";
    private static final String MISSINGFIELDASN1 = "Mandatory component `{0}'' is missing from SET value";
    private static final String VALUELISTNOTATIONERRORTTCN3 = "Value list notation cannot be used for set type `{0}''";
    private static final String SETVALUEXPECTEDTTCN3 = "set value was expected for type `{0}''";
    private static final String NONEXISTENTFIELDTTCN3 = "Reference to a non-existent field `{0}'' in set value for type `{1}''";
    private static final String DUPLICATEFIELDFIRSTTTCN3 = "Field `{0}'' is already given here";
    private static final String DUPLICATEFIELDAGAINTTCN3 = "Duplicated set field `{0}''";
    private static final String MISSINGFIELDTTCN3 = "Field `{0}'' is missing from set value";
    private static final String VALUELISTNOTATIONNOTALLOWED = "Value list notation is not allowed for set type `{0}''";
    private static final String NONEMPTYSETTEMPLATEEXPECTED = "A non-empty set template was expected for type `{0}''";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for set type `{1}''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for set type `{0}''";
    private static final String DUPLICATETEMPLATEFIELDFIRST = "Duplicate field `{0}'' in template";
    private static final String DUPLICATETEMPLATEFIELDAGAIN = "Field `{0}'' is already given here";
    private static final String NONEXISTENTTEMPLATEFIELDREFERENCE = "Reference to non-existing field `{0}'' in set template for type `{1}''";
    private static final String MISSINGTEMPLATEFIELD = "Field `{0}'' is missing from template for set type `{1}''";
    private static final String NOFFIELDSDONTMATCH = "The number of fields in set/SET types must be the same";
    private static final String BADOPTIONALITY = "The optionality of fields in set/SET types must be the same";
    private static final String NOTCOMPATIBLESETSETOF = "set/SET and set of/SET OF types are compatible only with other set/SET and set of/SET OF types";
    private static final String NOTCOMPATIBLEUNIONANYTYPE = "union/CHOICE/anytype types are compatible only with other union/CHOICE/anytype types";
    private static boolean strictConstantCheckingSeverity;

    public TTCN3_Set_Type(CompFieldMap compFieldMap) {
        super(compFieldMap);
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_TTCN3_SET;
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_SET;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp) || this == temp) {
            return true;
        }
        if (info == null || noStructuredTypeCompatibility) {
            return this == temp;
        }
        switch (temp.getTypetype()) {
            case TYPE_ASN1_SET: {
                ASN1_Set_Type tempType = (ASN1_Set_Type)temp;
                if (this.getNofComponents() != tempType.getNofComponents(timestamp)) {
                    info.setErrorStr(NOFFIELDSDONTMATCH);
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                int size = this.getNofComponents();
                for (int i = 0; i < size; ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    IType cfType = cf.getType().getTypeRefdLast(timestamp);
                    IType tempTypeCfType = tempTypeCf.getType().getTypeRefdLast(timestamp);
                    if (cf.isOptional() != tempTypeCf.isOptional()) {
                        String cfName = cf.getIdentifier().getDisplayName();
                        String tempTypeCfName = tempTypeCf.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + cfName);
                        info.appendOp2Ref("." + tempTypeCfName);
                        info.setOp1Type(cfType);
                        info.setOp2Type(tempTypeCfType);
                        info.setErrorStr(BADOPTIONALITY);
                        return false;
                    }
                    lChain.markState();
                    rChain.markState();
                    lChain.add(cfType);
                    rChain.add(tempTypeCfType);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(cfType, tempTypeCfType, false);
                    if (!(cfType.equals(tempTypeCfType) || lChain.hasRecursion() && rChain.hasRecursion() || cfType.isCompatible(timestamp, tempTypeCfType, infoTemp, lChain, rChain))) {
                        String cfName = cf.getIdentifier().getDisplayName();
                        String tempTypeCfName = tempTypeCf.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + cfName + infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCfName + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_TTCN3_SET: {
                TTCN3_Set_Type tempType = (TTCN3_Set_Type)temp;
                if (this == tempType) {
                    return true;
                }
                if (this.getNofComponents() != tempType.getNofComponents()) {
                    info.setErrorStr(NOFFIELDSDONTMATCH);
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                int size = this.getNofComponents();
                for (int i = 0; i < size; ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    IType cfType = cf.getType().getTypeRefdLast(timestamp);
                    IType tempTypeCfType = tempTypeCf.getType().getTypeRefdLast(timestamp);
                    if (cf.isOptional() != tempTypeCf.isOptional()) {
                        String cfName = cf.getIdentifier().getDisplayName();
                        String tempTypeCompFieldName = tempTypeCf.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + cfName);
                        info.appendOp2Ref("." + tempTypeCompFieldName);
                        info.setOp1Type(cfType);
                        info.setOp2Type(tempTypeCfType);
                        info.setErrorStr(BADOPTIONALITY);
                        return false;
                    }
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(cfType, tempTypeCfType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(cfType);
                    rChain.add(tempTypeCfType);
                    if (!(cfType.equals(tempTypeCfType) || lChain.hasRecursion() && rChain.hasRecursion() || cfType.isCompatible(timestamp, tempTypeCfType, infoTemp, lChain, rChain))) {
                        String cfName = cf.getIdentifier().getDisplayName();
                        String tempTypeCfName = tempTypeCf.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + cfName + infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCfName + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_SET_OF: {
                SetOf_Type tempType = (SetOf_Type)temp;
                if (!tempType.isSubtypeCompatible(timestamp, this)) {
                    info.setErrorStr("Incompatible set of/SET OF subtypes");
                    return false;
                }
                int nofComps = this.getNofComponents();
                if (nofComps == 0) {
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < nofComps; ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    IType cfType = cf.getType().getTypeRefdLast(timestamp);
                    IType tempTypeOfType = tempType.getOfType().getTypeRefdLast(timestamp);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(cfType, tempTypeOfType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(cfType);
                    rChain.add(tempTypeOfType);
                    if (cfType.equals(tempTypeOfType) || lChain.hasRecursion() && rChain.hasRecursion() || cfType.isCompatible(timestamp, tempTypeOfType, infoTemp, lChain, rChain)) continue;
                    info.appendOp1Ref("." + cf.getIdentifier().getDisplayName() + infoTemp.getOp1RefStr());
                    if (infoTemp.getOp2RefStr().length() > 0) {
                        info.appendOp2Ref("[]");
                    }
                    info.appendOp2Ref(infoTemp.getOp2RefStr());
                    info.setOp1Type(infoTemp.getOp1Type());
                    info.setOp2Type(infoTemp.getOp2Type());
                    info.setErrorStr(infoTemp.getErrorStr());
                    lChain.previousState();
                    rChain.previousState();
                    return false;
                }
                info.setNeedsConversion(true);
                lChain.previousState();
                rChain.previousState();
                return true;
            }
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_CHOICE: 
            case TYPE_ANYTYPE: {
                info.setErrorStr(NOTCOMPATIBLEUNIONANYTYPE);
                return false;
            }
            case TYPE_ASN1_SEQUENCE: 
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_ARRAY: {
                info.setErrorStr(NOTCOMPATIBLESETSETOF);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType temp = type.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == temp;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    @Override
    public String getOutlineIcon() {
        return "set.gif";
    }

    @Override
    public void checkConstructorName(String definitionName) {
        if (this.hasComponentWithName(definitionName)) {
            CompField field = this.getComponentByName(definitionName);
            field.getIdentifier().getLocation().reportSemanticError(MessageFormat.format(UNSUPPERTED_FIELDNAME, field.getIdentifier().getDisplayName()));
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            int size = this.getNofComponents();
            for (int i = 0; i < size; ++i) {
                CompField field = this.getComponentByIndex(i);
                Type type = field.getType();
                if (field.isOptional() || type == null) continue;
                referenceChain.markState();
                type.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case SEQUENCE_VALUE: {
                last = last.setValuetype(timestamp, IValue.Value_type.SET_VALUE);
                if (last.isAsn()) {
                    this.checkThisValueSet(timestamp, (Set_Value)last, valueCheckingOptions.expected_value, false, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                    break;
                }
                this.checkThisValueSet(timestamp, (Set_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case SEQUENCEOF_VALUE: {
                if (((SequenceOf_Value)last).isIndexed()) {
                    value.getLocation().reportSemanticError(MessageFormat.format("Indexed assignment notation cannot be used for set type `{0}''", this.getFullName()));
                    value.setIsErroneous(true);
                    break;
                }
                SequenceOf_Value tempValue = (SequenceOf_Value)last;
                if (tempValue.getNofComponents() == 0) {
                    if (this.compFieldMap != null && this.compFieldMap.getComponentFieldMap(timestamp).isEmpty()) {
                        last = last.setValuetype(timestamp, IValue.Value_type.SET_VALUE);
                        break;
                    }
                    value.getLocation().reportSemanticError(MessageFormat.format(NONEMPTYEXPECTED, this.getFullName()));
                    value.setIsErroneous(true);
                    break;
                }
                value.getLocation().reportSemanticError(MessageFormat.format(last.isAsn() ? VALUELISTNOTATIONERRORASN1 : VALUELISTNOTATIONERRORTTCN3, this.getFullName()));
                value.setIsErroneous(true);
                break;
            }
            case SET_VALUE: {
                if (last.isAsn()) {
                    this.checkThisValueSet(timestamp, (Set_Value)last, valueCheckingOptions.expected_value, false, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                    break;
                }
                this.checkThisValueSet(timestamp, (Set_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case UNDEFINED_BLOCK: {
                last = last.setValuetype(timestamp, IValue.Value_type.SET_VALUE);
                this.checkThisValueSet(timestamp, (Set_Value)last, valueCheckingOptions.expected_value, false, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(MessageFormat.format(last.isAsn() ? SETVALUEXPECTEDASN1 : SETVALUEXPECTEDTTCN3, this.getFullName()));
                value.setIsErroneous(true);
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
    }

    private void checkThisValueSet(CompilationTimeStamp timestamp, Set_Value value, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean impliciOmit, boolean strElem) {
        value.removeGeneratedValues();
        HashMap<String, NamedValue> componentMap = new HashMap<String, NamedValue>();
        Map<String, CompField> realComponents = this.compFieldMap.getComponentFieldMap(timestamp);
        boolean isAsn = value.isAsn();
        int nofValueComponents = value.getNofComponents();
        for (int i = 0; i < nofValueComponents; ++i) {
            NamedValue namedValue = value.getSequenceValueByIndex(i);
            Identifier valueId = namedValue.getName();
            if (!realComponents.containsKey(valueId.getName())) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format(isAsn ? NONEXISTENTFIELDASN1 : NONEXISTENTFIELDTTCN3, namedValue.getName().getDisplayName(), this.getTypename()));
                continue;
            }
            if (componentMap.containsKey(valueId.getName())) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format(isAsn ? DUPLICATEFIELDAGAINASN1 : DUPLICATEFIELDAGAINTTCN3, valueId.getDisplayName()));
                ((NamedValue)componentMap.get(valueId.getName())).getLocation().reportSingularSemanticError(MessageFormat.format(isAsn ? DUPLICATEFIELDFIRSTASN1 : "Field `{0}'' is already given here", valueId.getDisplayName()));
            } else {
                componentMap.put(valueId.getName(), namedValue);
            }
            CompField componentField = realComponents.get(valueId.getName());
            Type type = componentField.getType();
            IValue componentValue = namedValue.getValue();
            if (componentValue == null) continue;
            componentValue.setMyGovernor(type);
            if (IValue.Value_type.NOTUSED_VALUE.equals((Object)componentValue.getValuetype())) {
                if (incompleteAllowed) continue;
                componentValue.getLocation().reportSemanticError(INCOMPLETEPRESENTERROR);
                continue;
            }
            IValue tempValue = type.checkThisValueRef(timestamp, componentValue);
            type.checkThisValue(timestamp, tempValue, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, componentField.isOptional(), true, impliciOmit, strElem));
        }
        if (!incompleteAllowed || strictConstantCheckingSeverity) {
            int nofTypeComponents = realComponents.size();
            for (int i = 0; i < nofTypeComponents; ++i) {
                CompField field = this.compFieldMap.fields.get(i);
                Identifier id = field.getIdentifier();
                if (componentMap.containsKey(id.getName())) continue;
                if (field.isOptional() && impliciOmit) {
                    value.addNamedValue(new NamedValue(new Identifier(Identifier.Identifier_type.ID_TTCN, id.getDisplayName()), new Omit_Value(), false));
                    continue;
                }
                value.getLocation().reportSemanticError(MessageFormat.format(isAsn ? MISSINGFIELDASN1 : MISSINGFIELDTTCN3, id.getDisplayName()));
            }
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        switch (template.getTemplatetype()) {
            case TEMPLATE_LIST: {
                if (((Template_List)template).getNofTemplates() > 0) {
                    template.getLocation().reportSemanticError(MessageFormat.format(VALUELISTNOTATIONNOTALLOWED, this.getFullName()));
                    break;
                }
                if (this.getNofComponents() > 0) {
                    template.getLocation().reportSemanticError(MessageFormat.format(NONEMPTYSETTEMPLATEEXPECTED, this.getFullName()));
                    break;
                }
                ITTCN3Template transformed = template.setTemplatetype(timestamp, ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST);
                this.checkThisNamedTemplateList(timestamp, (Named_Template_List)transformed, isModified, implicitOmit);
                break;
            }
            case NAMED_TEMPLATE_LIST: {
                this.checkThisNamedTemplateList(timestamp, (Named_Template_List)template, isModified, implicitOmit);
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName()));
            }
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(LENGTHRESTRICTIONNOTALLOWED);
        }
    }

    private void checkThisNamedTemplateList(CompilationTimeStamp timestamp, Named_Template_List templateList, boolean isModified, boolean implicitOmit) {
        int i;
        templateList.removeGeneratedValues();
        HashMap<String, NamedTemplate> componentMap = new HashMap<String, NamedTemplate>();
        int nofTypeComponents = this.getNofComponents();
        int nofTemplateComponents = templateList.getNofTemplates();
        Map<String, CompField> realComponents = this.compFieldMap.getComponentFieldMap(timestamp);
        for (i = 0; i < nofTemplateComponents; ++i) {
            NamedTemplate namedTemplate = templateList.getTemplateByIndex(i);
            Identifier identifier = namedTemplate.getName();
            String templateName = identifier.getName();
            if (realComponents.containsKey(templateName)) {
                if (componentMap.containsKey(templateName)) {
                    namedTemplate.getLocation().reportSemanticError(MessageFormat.format(DUPLICATETEMPLATEFIELDFIRST, identifier.getDisplayName()));
                    ((NamedTemplate)componentMap.get(templateName)).getLocation().reportSemanticError(MessageFormat.format("Field `{0}'' is already given here", identifier.getDisplayName()));
                } else {
                    componentMap.put(templateName, namedTemplate);
                }
                CompField componentField = this.getComponentByName(identifier.getName());
                Type type = componentField.getType();
                ITTCN3Template componentTemplate = namedTemplate.getTemplate();
                componentTemplate.setMyGovernor(type);
                componentTemplate = type.checkThisTemplateRef(timestamp, componentTemplate);
                boolean isOptional = componentField.isOptional();
                componentTemplate.checkThisTemplateGeneric(timestamp, type, isModified, isOptional, isOptional, true, implicitOmit);
                continue;
            }
            namedTemplate.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTTEMPLATEFIELDREFERENCE, identifier.getDisplayName(), this.getTypename()));
        }
        if (!isModified && strictConstantCheckingSeverity) {
            for (i = 0; i < nofTypeComponents; ++i) {
                Identifier identifier = this.getComponentIdentifierByIndex(i);
                if (componentMap.containsKey(identifier.getName())) continue;
                if (this.getComponentByIndex(i).isOptional() && implicitOmit) {
                    templateList.addNamedValue(new NamedTemplate(new Identifier(Identifier.Identifier_type.ID_TTCN, identifier.getDisplayName()), new OmitValue_Template(), false));
                    continue;
                }
                templateList.getLocation().reportSemanticError(MessageFormat.format(MISSINGTEMPLATEFIELD, identifier.getDisplayName(), this.getTypename()));
            }
        }
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("set");
    }

    static {
        final IPreferencesService ps = Platform.getPreferencesService();
        if (ps != null) {
            strictConstantCheckingSeverity = ps.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportStrictConstants", false, null);
            Activator activator = Activator.getDefault();
            if (activator != null) {
                activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        String property = event.getProperty();
                        if ("org.eclipse.titan.designer.reportStrictConstants".equals(property)) {
                            strictConstantCheckingSeverity = ps.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportStrictConstants", false, null);
                        }
                    }
                });
            }
        }
    }
}

