/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubtypeConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.TernaryBool;
import org.eclipse.titan.designer.AST.TTCN3.values.Verdict_Value;

public final class VerdicttypeListConstraint
extends SubtypeConstraint {
    static final String[] VERDICT_NAMES = new String[]{"none", "pass", "inconc", "fail", "error"};
    private final int constraint;

    public VerdicttypeListConstraint(ConstraintValue constraint) {
        this.constraint = constraint.value();
    }

    public VerdicttypeListConstraint(Verdict_Value.Verdict_type verdictType) {
        switch (verdictType) {
            case NONE: {
                this.constraint = ConstraintValue.NONE.value();
                break;
            }
            case PASS: {
                this.constraint = ConstraintValue.PASS.value();
                break;
            }
            case INCONC: {
                this.constraint = ConstraintValue.INCONC.value();
                break;
            }
            case FAIL: {
                this.constraint = ConstraintValue.FAIL.value();
                break;
            }
            case ERROR: {
                this.constraint = ConstraintValue.ERROR.value();
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR();
                this.constraint = 0;
            }
        }
    }

    private VerdicttypeListConstraint(int constraint) {
        this.constraint = constraint;
    }

    @Override
    public VerdicttypeListConstraint complement() {
        return new VerdicttypeListConstraint(this.constraint ^ ConstraintValue.ALL.value());
    }

    @Override
    public VerdicttypeListConstraint intersection(SubtypeConstraint other) {
        VerdicttypeListConstraint o = (VerdicttypeListConstraint)other;
        return new VerdicttypeListConstraint(this.constraint & o.constraint);
    }

    @Override
    public boolean isElement(Object o) {
        Verdict_Value.Verdict_type vt = (Verdict_Value.Verdict_type)((Object)o);
        switch (vt) {
            case ERROR: {
                return (this.constraint & ConstraintValue.ERROR.value()) != 0;
            }
            case FAIL: {
                return (this.constraint & ConstraintValue.FAIL.value()) != 0;
            }
            case INCONC: {
                return (this.constraint & ConstraintValue.INCONC.value()) != 0;
            }
            case NONE: {
                return (this.constraint & ConstraintValue.NONE.value()) != 0;
            }
            case PASS: {
                return (this.constraint & ConstraintValue.PASS.value()) != 0;
            }
        }
        return false;
    }

    @Override
    public TernaryBool isEmpty() {
        return TernaryBool.fromBool(this.constraint == 0);
    }

    @Override
    public TernaryBool isEqual(SubtypeConstraint other) {
        VerdicttypeListConstraint o = (VerdicttypeListConstraint)other;
        return TernaryBool.fromBool(this.constraint == o.constraint);
    }

    @Override
    public TernaryBool isFull() {
        return TernaryBool.fromBool(this.constraint == ConstraintValue.ALL.value());
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append('(');
        boolean hasValue = false;
        int i = ConstraintValue.NONE.value();
        for (int idx = 0; i < ConstraintValue.ALL.value() && idx < VERDICT_NAMES.length; i <<= 1, ++idx) {
            if ((this.constraint & i) == 0) continue;
            if (hasValue) {
                sb.append(", ");
            }
            sb.append(VERDICT_NAMES[idx]);
            hasValue = true;
        }
        sb.append(')');
    }

    @Override
    public VerdicttypeListConstraint union(SubtypeConstraint other) {
        VerdicttypeListConstraint o = (VerdicttypeListConstraint)other;
        return new VerdicttypeListConstraint(this.constraint | o.constraint);
    }

    public static enum ConstraintValue {
        NONE(1),
        PASS(2),
        INCONC(4),
        FAIL(8),
        ERROR(16),
        ALL(31);

        private final int value;

        private ConstraintValue(int v) {
            this.value = v;
        }

        public int value() {
            return this.value;
        }
    }
}

