/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.include;

import java.util.ArrayList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.titan.designer.editors.configeditor.pages.include.IncludeItemTransfer;
import org.eclipse.titan.designer.editors.configeditor.pages.include.IncludeSubPage;

public final class IncludeSectionDragSourceListener
implements DragSourceListener {
    private TableViewer viewer;
    private IncludeSubPage includeSubPage;

    public IncludeSectionDragSourceListener(IncludeSubPage includeSubPage, TableViewer viewer) {
        this.includeSubPage = includeSubPage;
        this.viewer = viewer;
    }

    public void dragFinished(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            this.viewer.getTable().setRedraw(false);
            if (event.detail == 2) {
                this.includeSubPage.removeSelectedIncludeItems();
            }
            this.viewer.getTable().setRedraw(true);
            this.viewer.refresh();
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (IncludeItemTransfer.getInstance().isSupportedType(event.dataType)) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            ArrayList<ParseTree> items = new ArrayList<ParseTree>();
            if (!selection.isEmpty()) {
                for (Object element : selection) {
                    if (!(element instanceof ParseTree)) continue;
                    items.add((ParseTree)element);
                }
                event.data = items.toArray(new ParseTree[items.size()]);
            }
        }
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        event.doit = !selection.isEmpty() && selection.getFirstElement() instanceof ParseTree;
    }
}

