/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.editors.GeneralPairMatcher;
import org.eclipse.titan.designer.editors.GlobalIntervalHandler;
import org.eclipse.titan.designer.editors.HeuristicalIntervalDetector;
import org.eclipse.titan.designer.editors.IReferenceParser;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3ReferencePairMatcher;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReferenceAnalyzer;

public final class TTCN3ReferenceParser
implements IReferenceParser {
    private int ofs;
    private boolean reportErrors;

    public TTCN3ReferenceParser(boolean reportErrors) {
        this.reportErrors = reportErrors;
    }

    @Override
    public void setErrorReporting(boolean reportErrors) {
        this.reportErrors = reportErrors;
    }

    public int getReplacementOffset() {
        return this.ofs;
    }

    @Override
    public Reference findReferenceForCompletion(IFile file, int offset, IDocument document) {
        Reference reference = null;
        this.ofs = offset - 1;
        if (-1 == this.ofs) {
            return reference;
        }
        try {
            char currentChar = document.getChar(this.ofs);
            if (')' == currentChar || '}' == currentChar) {
                return reference;
            }
            TTCN3ReferencePairMatcher pairMatcher = new TTCN3ReferencePairMatcher();
            int tempOfs = this.referenceStartOffset(this.ofs, document, pairMatcher);
            if (-1 == tempOfs) {
                return reference;
            }
            if (tempOfs > 3 && ("any ".equals(document.get(tempOfs - 2, 4)) || "all ".equals(document.get(tempOfs - 2, 4)))) {
                tempOfs -= 3;
            }
            this.ofs = tempOfs;
            ++this.ofs;
            String toBeParsed = document.get(this.ofs, offset - this.ofs);
            TTCN3ReferenceAnalyzer refAnalyzer = new TTCN3ReferenceAnalyzer();
            reference = refAnalyzer.parseForCompletion(file, toBeParsed);
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return reference;
    }

    @Override
    public Reference findReferenceForOpening(IFile file, int offset, IDocument document) {
        Reference reference = null;
        this.ofs = offset - 1;
        int endoffset = offset;
        if (-1 == this.ofs) {
            return reference;
        }
        try {
            TTCN3ReferencePairMatcher pairMatcher = new TTCN3ReferencePairMatcher();
            this.ofs = this.referenceStartOffset(this.ofs, document, pairMatcher);
            if (-1 == this.ofs) {
                return reference;
            }
            ++this.ofs;
            if (endoffset >= document.getLength()) {
                return reference;
            }
            char currentChar = document.getChar(endoffset);
            while (endoffset < document.getLength() && (Character.isLetterOrDigit(currentChar) || currentChar == '(' || currentChar == '_') && currentChar != '(') {
                if (++endoffset >= document.getLength()) {
                    return reference;
                }
                currentChar = document.getChar(endoffset);
            }
            String toBeParsed = document.get(this.ofs, endoffset - this.ofs);
            if (toBeParsed.trim().length() == 0) {
                return reference;
            }
            TTCN3ReferenceAnalyzer refAnalyzer = new TTCN3ReferenceAnalyzer();
            reference = refAnalyzer.parse(file, toBeParsed, this.reportErrors, document.getLineOfOffset(this.ofs), this.ofs);
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return reference;
    }

    private int referenceStartOffset(int offset, IDocument document, GeneralPairMatcher pairMatcher) throws BadLocationException {
        int temporalOffset;
        Interval rootInterval = GlobalIntervalHandler.getInterval(document);
        if (rootInterval == null) {
            rootInterval = new HeuristicalIntervalDetector().buildIntervals(document);
            GlobalIntervalHandler.putInterval(document, rootInterval);
        }
        char currentChar = document.getChar(temporalOffset);
        Interval interval = null;
        boolean foundWhiteSpaces = false;
        boolean foundDot = false;
        for (temporalOffset = offset; temporalOffset > 0; --temporalOffset) {
            if (rootInterval != null) {
                interval = rootInterval.getSmallestEnclosingInterval(temporalOffset);
            }
            currentChar = document.getChar(temporalOffset);
            if (interval != null && (Interval.interval_type.SINGLELINE_COMMENT.equals((Object)interval.getType()) || Interval.interval_type.MULTILINE_COMMENT.equals((Object)interval.getType()))) {
                temporalOffset = interval.getStartOffset();
                continue;
            }
            if (currentChar == ')' || currentChar == ']') {
                if (!foundDot) break;
                foundWhiteSpaces = false;
                IRegion pair = pairMatcher.match(document, temporalOffset + 1);
                if (pair == null) {
                    return -1;
                }
                temporalOffset = pair.getOffset();
                continue;
            }
            if ('_' == currentChar || Character.isLetterOrDigit(currentChar)) {
                if (foundWhiteSpaces && !foundDot) break;
                foundWhiteSpaces = false;
                foundDot = false;
                continue;
            }
            if ('.' == currentChar) {
                foundDot = true;
                continue;
            }
            if (' ' == currentChar || '\t' == currentChar || '\n' == currentChar || '\r' == currentChar) {
                foundWhiteSpaces = true;
                continue;
            }
            if ('%' != currentChar) break;
            --temporalOffset;
            break;
        }
        return temporalOffset;
    }
}

