/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class TTCN3StringDetectionPatternRule
implements IPredicateRule {
    private static final int UNDEFINED = -1;
    private IToken fToken;
    private int fColumn = -1;
    private Comparator<char[]> fLineDelimiterComparator = new DecreasingCharArrayLengthComparator();
    private char[][] fLineDelimiters;
    private char[][] fSortedLineDelimiters;

    public TTCN3StringDetectionPatternRule(IToken token) {
        this.fToken = token;
    }

    public void setColumnConstraint(int column) {
        this.fColumn = column < 0 ? -1 : column;
    }

    protected IToken doEvaluate(ICharacterScanner scanner) {
        return this.doEvaluate(scanner, false);
    }

    protected IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
        int c;
        if (!resume && (c = scanner.read()) != 34) {
            scanner.unread();
            return Token.UNDEFINED;
        }
        if (this.endSequenceDetected(scanner)) {
            return this.fToken;
        }
        if (!resume) {
            scanner.unread();
        }
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    private boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        int count;
        char[][] originalDelimiters = scanner.getLegalLineDelimiters();
        if (this.fLineDelimiters == null || originalDelimiters.length != count) {
            this.fSortedLineDelimiters = new char[count][];
        } else {
            for (count = originalDelimiters.length; count > 0 && this.fLineDelimiters[count - 1] == originalDelimiters[count - 1]; --count) {
            }
        }
        if (count != 0) {
            this.fLineDelimiters = originalDelimiters;
            System.arraycopy(this.fLineDelimiters, 0, this.fSortedLineDelimiters, 0, this.fLineDelimiters.length);
            Arrays.sort(this.fSortedLineDelimiters, this.fLineDelimiterComparator);
        }
        int readCount = 1;
        while ((c = scanner.read()) != -1) {
            int c2;
            if (c == 92) {
                scanner.read();
            } else if (c == 34 && (c2 = scanner.read()) != 34) {
                scanner.unread();
                return true;
            }
            ++readCount;
        }
        while (readCount > 0) {
            scanner.unread();
            --readCount;
        }
        return false;
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        for (int i = 1; i < sequence.length; ++i) {
            int c = scanner.read();
            if (c == -1 && eofAllowed) {
                return true;
            }
            if (c == sequence[i]) continue;
            scanner.unread();
            for (int j = i - 1; j > 0; --j) {
                scanner.unread();
            }
            return false;
        }
        return true;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (this.fColumn == -1) {
            return this.doEvaluate(scanner, resume);
        }
        int c = scanner.read();
        scanner.unread();
        if (c == 34) {
            return this.fColumn == scanner.getColumn() ? this.doEvaluate(scanner, resume) : Token.UNDEFINED;
        }
        return Token.UNDEFINED;
    }

    public IToken getSuccessToken() {
        return this.fToken;
    }

    private static class DecreasingCharArrayLengthComparator
    implements Comparator<char[]> {
        private DecreasingCharArrayLengthComparator() {
        }

        @Override
        public int compare(char[] o1, char[] o2) {
            return o2.length - o1.length;
        }
    }
}

