/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.titan.designer.properties.IPropertyChangeListener;

public class PropertyNotificationManager {
    private static List<IPropertyChangeListener> listeners = new ArrayList<IPropertyChangeListener>();

    private PropertyNotificationManager() {
    }

    public static synchronized void addListener(IPropertyChangeListener listener) {
        listeners.add(listener);
    }

    public static synchronized void removeListener(IPropertyChangeListener listener) {
        listeners.remove(listener);
    }

    public static synchronized void firePropertyChange(final IResource resource) {
        if (resource == null) {
            return;
        }
        ArrayList<IPropertyChangeListener> save = new ArrayList<IPropertyChangeListener>(listeners);
        for (final IPropertyChangeListener listener : save) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                }

                public void run() throws Exception {
                    listener.propertyChanged(resource);
                }
            });
        }
    }
}

