/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class BaseNamingConventionPropertyData {
    private BaseNamingConventionPropertyData() {
    }

    public static void removeTITANAttributes(IResource resource, String qualifier, String[] properties) {
        for (int i = 0; i < properties.length; ++i) {
            try {
                resource.setPersistentProperty(new QualifiedName(qualifier, properties[i]), null);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While removing property `" + properties[i] + "' of `" + resource.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static void loadProperties(Node root, IResource resource, String qualifier, String[] properties, String[] tags, String[] defaultValues) {
        String[] newValues = new String[tags.length];
        System.arraycopy(defaultValues, 0, newValues, 0, tags.length);
        if (root != null) {
            NodeList resourceList = root.getChildNodes();
            int size = resourceList.getLength();
            for (int i = 0; i < size; ++i) {
                String name = resourceList.item(i).getNodeName();
                for (int j = 0; j < tags.length; ++j) {
                    if (!tags[j].equals(name)) continue;
                    newValues[j] = resourceList.item(i).getTextContent();
                }
            }
        }
        for (int i = 0; i < properties.length; ++i) {
            QualifiedName qualifiedName = new QualifiedName(qualifier, properties[i]);
            try {
                String oldValue = resource.getPersistentProperty(qualifiedName);
                if (newValues[i] == null || newValues[i].equals(oldValue)) continue;
                resource.setPersistentProperty(qualifiedName, newValues[i]);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While loading property `" + properties[i] + "' of `" + resource.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static Element saveProperties(Document document, IResource resource, String qualifier, String[] properties, String[] tags, String[] defaultValues, String xmlNode) {
        Node root = null;
        String temp = null;
        for (int i = 0; i < properties.length; ++i) {
            try {
                temp = resource.getPersistentProperty(new QualifiedName(qualifier, properties[i]));
                if (temp == null || defaultValues[i].equals(temp)) continue;
                Element node = document.createElement(tags[i]);
                node.appendChild(document.createTextNode(temp));
                if (root == null) {
                    root = document.createElement(xmlNode);
                }
                root.appendChild(node);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While saving property `" + properties[i] + "' of `" + resource.getName() + "'"), (Throwable)e);
            }
        }
        return root;
    }

    public static boolean hasDefaultProperties(IFolder folder, String qualifier, String[] properties, String[] defaultValues) {
        String temp = null;
        for (int i = 0; i < properties.length; ++i) {
            try {
                temp = folder.getPersistentProperty(new QualifiedName(qualifier, properties[i]));
                if (temp == null || defaultValues[i].equals(temp)) continue;
                return false;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While checking property `" + properties[i] + "' of `" + folder.getName() + "'"), (Throwable)e);
            }
        }
        return true;
    }

    public static Element copyProperties(Node source, Document document, boolean saveDefaultValues, String xmlNode, String[] properties, String[] tags, String[] defaultValues) {
        String[] newValues = new String[tags.length];
        System.arraycopy(defaultValues, 0, newValues, 0, tags.length);
        if (source != null) {
            NodeList resourceList = source.getChildNodes();
            int size = resourceList.getLength();
            for (int i = 0; i < size; ++i) {
                String name = resourceList.item(i).getNodeName();
                for (int j = 0; j < tags.length; ++j) {
                    if (!tags[j].equals(name)) continue;
                    newValues[j] = resourceList.item(i).getTextContent();
                }
            }
        }
        Node result = null;
        String temp = null;
        for (int i = 0; i < tags.length; ++i) {
            temp = newValues[i];
            if (temp == null || !saveDefaultValues && defaultValues[i].equals(temp)) continue;
            Element node = document.createElement(tags[i]);
            node.appendChild(document.createTextNode(temp));
            if (result == null) {
                result = document.createElement(xmlNode);
            }
            result.appendChild(node);
        }
        return result;
    }
}

