/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MakeAttributesData {
    public static final String LOCALBUILDSETTINGS = "LocalBuildSettings";
    public static final String BUILD_LEVEL_0 = "Level 0 - Semantic Check";
    public static final String BUILD_LEVEL_1 = "Level 1 - TTCN3 -> C++ compilation";
    public static final String BUILD_LEVEL_2 = "Level 2 - Creating object files";
    public static final String BUILD_LEVEL_2_5 = "Level 2.5 - Creating object files with heuristical dependency update";
    public static final String BUILD_LEVEL_3 = "Level 3 - Creating object files with dependency update";
    public static final String BUILD_LEVEL_4 = "Level 4 - Creating Executable Test Suite";
    public static final String BUILD_LEVEL_4_5 = "Level 4.5 - Creating Executable Test Suite with heuristical dependency update";
    public static final String BUILD_LEVEL_5 = "Level 5 - Creating Executable Test Suite with dependency update";
    public static final String TEMPORAL_MAKEFILE_SCRIPT_PROPERTY = "makefileUpdateScript";
    public static final String TEMPORAL_MAKEFILE_FLAGS_PROPERTY = "makefileFlags";
    public static final String TEMPORAL_WORKINGDIRECTORY_PROPERTY = "workingDir";
    public static final String BUILD_LEVEL_PROPERTY = "buildLevel";
    private static final String[] MAKEFILE_PROPERTIES = new String[]{"buildLevel"};
    private static final String[] MAKEFILE_TAGS = new String[]{"buildLevel"};
    private static final String[] DEFAULT_VALUES = new String[]{"Level 5 - Creating Executable Test Suite with dependency update"};

    private MakeAttributesData() {
    }

    public static String getBuildLevel(String s) {
        if (s == null) {
            return BUILD_LEVEL_5;
        }
        String s1 = s.replace(" ", "");
        if (s1.startsWith("Level2.5")) {
            return BUILD_LEVEL_2_5;
        }
        if (s1.startsWith("Level4.5")) {
            return BUILD_LEVEL_4_5;
        }
        if (s1.startsWith("Level0")) {
            return BUILD_LEVEL_0;
        }
        if (s1.startsWith("Level1")) {
            return BUILD_LEVEL_1;
        }
        if (s1.startsWith("Level2")) {
            return BUILD_LEVEL_2;
        }
        if (s1.startsWith("Level3")) {
            return BUILD_LEVEL_3;
        }
        if (s1.startsWith("Level4")) {
            return BUILD_LEVEL_4;
        }
        if (s1.startsWith("Level5")) {
            return BUILD_LEVEL_5;
        }
        if (s1.startsWith("2.5")) {
            return BUILD_LEVEL_2_5;
        }
        if (s1.startsWith("4.5")) {
            return BUILD_LEVEL_4_5;
        }
        if (s1.startsWith("0")) {
            return BUILD_LEVEL_0;
        }
        if (s1.startsWith("1")) {
            return BUILD_LEVEL_1;
        }
        if (s1.startsWith("2")) {
            return BUILD_LEVEL_2;
        }
        if (s1.startsWith("3")) {
            return BUILD_LEVEL_3;
        }
        if (s1.startsWith("4")) {
            return BUILD_LEVEL_4;
        }
        if (s1.startsWith("5")) {
            return BUILD_LEVEL_5;
        }
        return BUILD_LEVEL_5;
    }

    public static void removeTITANAttributes(IProject project) {
        try {
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", BUILD_LEVEL_PROPERTY), null);
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", TEMPORAL_MAKEFILE_SCRIPT_PROPERTY), null);
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", TEMPORAL_MAKEFILE_FLAGS_PROPERTY), null);
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", TEMPORAL_WORKINGDIRECTORY_PROPERTY), null);
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((String)("While removing attributes of `" + project.getName() + "'"), (Throwable)ce);
        }
    }

    public static void loadMakefileSettings(Node root, IProject project) {
        int i;
        NodeList resourceList = root.getChildNodes();
        String[] newValues = new String[MAKEFILE_TAGS.length];
        System.arraycopy(DEFAULT_VALUES, 0, newValues, 0, MAKEFILE_TAGS.length);
        int size = resourceList.getLength();
        for (i = 0; i < size; ++i) {
            Node node = resourceList.item(i);
            String name = node.getNodeName();
            for (int j = 0; j < MAKEFILE_TAGS.length; ++j) {
                if (!MAKEFILE_TAGS[j].equals(name)) continue;
                newValues[j] = node.getTextContent();
            }
        }
        for (i = 0; i < MAKEFILE_TAGS.length; ++i) {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", MAKEFILE_PROPERTIES[i]);
            try {
                String oldValue = project.getPersistentProperty(qualifiedName);
                if (newValues[i] == null || newValues[i].equals(oldValue)) continue;
                project.setPersistentProperty(qualifiedName, newValues[i]);
                continue;
            }
            catch (CoreException ce) {
                ErrorReporter.logExceptionStackTrace((String)("While setting the property `" + MAKEFILE_PROPERTIES[i] + "' on project `" + project.getName() + "'"), (Throwable)ce);
            }
        }
    }

    public static void saveMakefileSettings(Element makefileSettings, Document document, IProject project) {
        String temp = null;
        for (int i = 0; i < MAKEFILE_PROPERTIES.length; ++i) {
            try {
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", MAKEFILE_PROPERTIES[i]));
                if (temp == null || DEFAULT_VALUES[i].equals(temp)) continue;
                Element node = document.createElement(MAKEFILE_TAGS[i]);
                node.appendChild(document.createTextNode(temp));
                makefileSettings.appendChild(node);
                continue;
            }
            catch (CoreException ce) {
                ErrorReporter.logExceptionStackTrace((String)("While saving the property `" + MAKEFILE_PROPERTIES[i] + "' of project `" + project.getName() + "'"), (Throwable)ce);
            }
        }
    }

    public static void copyMakefileSettings(Node source, Node makefileSettings, Document document, boolean saveDefaultValues) {
        Node node;
        int i;
        NodeList resourceList = source.getChildNodes();
        String[] newValues = new String[MAKEFILE_TAGS.length];
        System.arraycopy(DEFAULT_VALUES, 0, newValues, 0, MAKEFILE_TAGS.length);
        int size = resourceList.getLength();
        for (i = 0; i < size; ++i) {
            node = resourceList.item(i);
            String name = node.getNodeName();
            for (int j = 0; j < MAKEFILE_TAGS.length; ++j) {
                if (!MAKEFILE_TAGS[j].equals(name)) continue;
                newValues[j] = node.getTextContent();
            }
        }
        for (i = 0; i < MAKEFILE_PROPERTIES.length; ++i) {
            String temp = newValues[i];
            if (!saveDefaultValues && (temp == null || DEFAULT_VALUES[i].equals(temp))) continue;
            node = document.createElement(MAKEFILE_TAGS[i]);
            node.appendChild(document.createTextNode(temp));
            makefileSettings.appendChild(node);
        }
    }

    public static Element saveLocalBuildSettings(Document document, IProject project) {
        Element localBuildSettings = document.createElement(LOCALBUILDSETTINGS);
        Element node = MakeAttributesData.saveLocalBuildUpdaterScriptSettings(document, project);
        if (node != null) {
            localBuildSettings.appendChild(node);
        }
        if ((node = MakeAttributesData.saveLocalBuildMakefileFlagsSettings(document, project)) != null) {
            localBuildSettings.appendChild(node);
        }
        node = MakeAttributesData.saveLocalBuildWorkingDirectorySettings(document, project);
        localBuildSettings.appendChild(node);
        return localBuildSettings;
    }

    private static Element saveLocalBuildUpdaterScriptSettings(Document document, IProject project) {
        String temp = null;
        Element node = null;
        try {
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", TEMPORAL_MAKEFILE_SCRIPT_PROPERTY));
            if (temp == null || "".equals(temp)) {
                temp = "";
            }
            node = document.createElement("MakefileScript");
            node.appendChild(document.createTextNode(temp));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While saving build updater settings of `" + project.getName() + "'"), (Throwable)e);
        }
        return node;
    }

    private static Element saveLocalBuildMakefileFlagsSettings(Document document, IProject project) {
        String temp = null;
        Element node = null;
        try {
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", TEMPORAL_MAKEFILE_FLAGS_PROPERTY));
            if (temp != null && !"".equals(temp)) {
                node = document.createElement("MakefileFlags");
                node.appendChild(document.createTextNode(temp));
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While saving makefile settings of `" + project.getName() + "'"), (Throwable)e);
        }
        return node;
    }

    private static Element saveLocalBuildWorkingDirectorySettings(Document document, IProject project) {
        String temp = null;
        Element node = null;
        try {
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", TEMPORAL_WORKINGDIRECTORY_PROPERTY));
            if (temp == null) {
                temp = "bin";
            }
            node = document.createElement("workingDirectory");
            node.appendChild(document.createTextNode(temp));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While saving working directory settings of `" + project.getName() + "'"), (Throwable)e);
        }
        return node;
    }

    public static void loadLocalBuildSettings(Node root, IProject project) {
        String oldValue;
        NodeList resourceList = root.getChildNodes();
        String newWorkingDirectory = "bin";
        String newMakefileFlags = "";
        String newMakefileUpdaterScript = "";
        int size = resourceList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = resourceList.item(i);
            String nodeName = node.getNodeName();
            if ("workingDirectory".equals(nodeName)) {
                newWorkingDirectory = node.getTextContent();
                continue;
            }
            if ("MakefileScript".equals(nodeName)) {
                newMakefileUpdaterScript = node.getTextContent();
                continue;
            }
            if (!"MakefileFlags".equals(nodeName)) continue;
            newMakefileFlags = node.getTextContent();
        }
        QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", TEMPORAL_WORKINGDIRECTORY_PROPERTY);
        try {
            oldValue = project.getPersistentProperty(qualifiedName);
            if (newWorkingDirectory != null && !newWorkingDirectory.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newWorkingDirectory);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting working directory settings of `" + project.getName() + "'"), (Throwable)e);
        }
        qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", TEMPORAL_MAKEFILE_SCRIPT_PROPERTY);
        try {
            oldValue = project.getPersistentProperty(qualifiedName);
            if (newMakefileUpdaterScript != null && !newMakefileUpdaterScript.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newMakefileUpdaterScript);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting updater script settings of `" + project.getName() + "'"), (Throwable)e);
        }
        qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", TEMPORAL_MAKEFILE_FLAGS_PROPERTY);
        try {
            oldValue = project.getPersistentProperty(qualifiedName);
            if (newMakefileFlags != null && !newMakefileFlags.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newMakefileFlags);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting updater flag settings of `" + project.getName() + "'"), (Throwable)e);
        }
    }

    public static Element copyLocalBuildSettings(Node source, Document document, boolean saveDefaultValues) {
        NodeList resourceList = source.getChildNodes();
        String newWorkingDirectory = "bin";
        String newMakefileFlags = "";
        String newMakefileUpdaterScript = "";
        int size = resourceList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = resourceList.item(i);
            String nodeName = node.getNodeName();
            if ("workingDirectory".equals(nodeName)) {
                newWorkingDirectory = node.getTextContent();
                continue;
            }
            if ("MakefileScript".equals(nodeName)) {
                newMakefileUpdaterScript = node.getTextContent();
                continue;
            }
            if (!"MakefileFlags".equals(nodeName)) continue;
            newMakefileFlags = node.getTextContent();
        }
        Element localBuildSettings = document.createElement(LOCALBUILDSETTINGS);
        if (saveDefaultValues || newMakefileFlags.length() > 0) {
            Element node = document.createElement("MakefileFlags");
            node.appendChild(document.createTextNode(newMakefileFlags));
            localBuildSettings.appendChild(node);
        }
        if (saveDefaultValues || newMakefileUpdaterScript.length() > 0) {
            Element node = document.createElement("MakefileScript");
            node.appendChild(document.createTextNode(newMakefileUpdaterScript));
            localBuildSettings.appendChild(node);
        }
        Element node = document.createElement("workingDirectory");
        node.appendChild(document.createTextNode(newWorkingDirectory));
        localBuildSettings.appendChild(node);
        return localBuildSettings;
    }
}

