/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.properties.pages.ListItemDialog;

public class MyListControl {
    private ToolBar toolBar;
    private ToolItem addItem;
    private ToolItem deleteItem;
    private ToolItem editItem;
    private ToolItem moveUpItem;
    private ToolItem moveDownItem;
    private Label title;
    protected List list;
    protected String itemDescription;
    private final Image imgAdd = ImageCache.getImage("list-add.gif");
    private final Image imgAddDisabled = ImageCache.getImage("list-add_d.gif");
    private final Image imgDelete = ImageCache.getImage("list-delete.gif");
    private final Image imgDeleteDisabled = ImageCache.getImage("list-delete_d.gif");
    private final Image imgEdit = ImageCache.getImage("list-edit.gif");
    private final Image imgEditDisabled = ImageCache.getImage("list-edit_d.gif");
    private final Image imgMoveUp = ImageCache.getImage("list-moveup.gif");
    private final Image imgMoveUpDisabled = ImageCache.getImage("list-moveup_d.gif");
    private final Image imgMoveDown = ImageCache.getImage("list-movedown.gif");
    private final Image imgMoveDownDisabled = ImageCache.getImage("list-movedown_d.gif");

    public MyListControl(Composite parent, String title, String itemDescription) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout form1 = new GridLayout();
        form1.numColumns = 1;
        form1.horizontalSpacing = 0;
        form1.verticalSpacing = 0;
        form1.marginHeight = 0;
        form1.marginWidth = 0;
        mainComposite.setLayout((Layout)form1);
        mainComposite.setLayoutData((Object)new GridData(1808));
        Composite titleComposite = new Composite(mainComposite, 2048);
        GridLayout titleform = new GridLayout(2, false);
        titleform.horizontalSpacing = 0;
        titleform.verticalSpacing = 0;
        titleform.marginHeight = 0;
        titleform.marginWidth = 0;
        titleComposite.setLayout((Layout)titleform);
        GridData data = new GridData(768);
        data.heightHint = 25;
        titleComposite.setLayoutData((Object)data);
        this.title = new Label(titleComposite, 1);
        this.title.setText(title);
        GridData titleGrid = new GridData(768);
        this.title.setLayoutData((Object)titleGrid);
        Composite buttonPanel = new Composite(titleComposite, 0);
        GridLayout form2 = new GridLayout();
        form2.numColumns = 5;
        form2.horizontalSpacing = 0;
        form2.verticalSpacing = 0;
        form2.marginWidth = 0;
        form2.marginHeight = 0;
        buttonPanel.setLayout((Layout)form2);
        GridData buttonGrid = new GridData(896);
        buttonPanel.setLayoutData((Object)buttonGrid);
        this.toolBar = new ToolBar(buttonPanel, 8519936);
        this.addItem = new ToolItem(this.toolBar, 8);
        this.addItem.setImage(this.imgAdd);
        this.addItem.setDisabledImage(this.imgAddDisabled);
        this.addItem.setToolTipText("Add");
        this.addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MyListControl.this.addNewItem();
            }
        });
        this.deleteItem = new ToolItem(this.toolBar, 8);
        this.deleteItem.setImage(this.imgDelete);
        this.deleteItem.setDisabledImage(this.imgDeleteDisabled);
        this.deleteItem.setToolTipText("Delete");
        this.deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MyListControl.this.removeSelectedItem();
            }
        });
        this.editItem = new ToolItem(this.toolBar, 8);
        this.editItem.setImage(this.imgEdit);
        this.editItem.setDisabledImage(this.imgEditDisabled);
        this.editItem.setToolTipText("Edit");
        this.editItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MyListControl.this.editSelectedItem();
            }
        });
        this.moveUpItem = new ToolItem(this.toolBar, 8);
        this.moveUpItem.setImage(this.imgMoveUp);
        this.moveUpItem.setDisabledImage(this.imgMoveUpDisabled);
        this.moveUpItem.setToolTipText("Move up");
        this.moveUpItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MyListControl.this.moveUpSelectedItem();
            }
        });
        this.moveDownItem = new ToolItem(this.toolBar, 8);
        this.moveDownItem.setImage(this.imgMoveDown);
        this.moveDownItem.setDisabledImage(this.imgMoveDownDisabled);
        this.moveDownItem.setToolTipText("Move down");
        this.moveDownItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MyListControl.this.moveDownSelectedItem();
            }
        });
        this.list = new List(mainComposite, 2816);
        GridData listGrid = new GridData(1808);
        Point preferredSize = titleComposite.computeSize(-1, -1);
        listGrid.widthHint = preferredSize.x;
        listGrid.heightHint = preferredSize.y * 3;
        listGrid.horizontalSpan = 2;
        this.list.setLayoutData((Object)listGrid);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MyListControl.this.selectionChanged();
            }
        });
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                MyListControl.this.editSelectedItem();
            }
        });
        this.list.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    MyListControl.this.removeSelectedItem();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        this.itemDescription = itemDescription;
        this.selectionChanged();
    }

    public void dispose() {
        if (this.toolBar == null) {
            return;
        }
        this.toolBar.dispose();
        this.addItem.dispose();
        this.deleteItem.dispose();
        this.editItem.dispose();
        this.moveUpItem.dispose();
        this.moveDownItem.dispose();
        this.title.dispose();
        this.list.dispose();
    }

    public final String[] getValues() {
        if (this.list == null) {
            return new String[0];
        }
        return this.list.getItems();
    }

    public final void setValues(String[] values) {
        int i;
        boolean same;
        if (values == null || this.list == null) {
            return;
        }
        String[] items = this.list.getItems();
        boolean bl = same = items.length == values.length;
        if (same) {
            for (i = 0; same && i < items.length; same &= items[i].equals(values[i]), ++i) {
            }
        }
        if (same) {
            return;
        }
        this.list.removeAll();
        for (i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i].length() <= 0) continue;
            this.list.add(values[i]);
        }
        this.selectionChanged();
    }

    protected final void selectionChanged() {
        int size = this.list.getItemCount();
        int index = this.list.getSelectionIndex();
        this.addItem.setEnabled(true);
        this.editItem.setEnabled(size > 0 && index != -1);
        this.deleteItem.setEnabled(size > 0 && index != -1);
        this.moveUpItem.setEnabled(size > 1 && index > 0);
        this.moveDownItem.setEnabled(size > 1 && index < size - 1 && index != -1);
    }

    protected void addNewItem() {
        ListItemDialog dialog = new ListItemDialog(this.list.getShell(), "Add new " + this.itemDescription, this.itemDescription, "");
        if (dialog.open() != 0) {
            return;
        }
        String newItem = dialog.getItem();
        if (newItem != null && newItem.length() > 0) {
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.add(newItem, index + 1);
                this.list.setSelection(index + 1);
            } else {
                int size = this.list.getItemCount();
                this.list.add(newItem, size);
                this.list.setSelection(size);
            }
        }
        this.selectionChanged();
    }

    private void removeSelectedItem() {
        int index = this.list.getSelectionIndex();
        if (index != -1) {
            this.list.remove(index);
        }
        this.selectionChanged();
    }

    protected void editSelectedItem() {
        int index = this.list.getSelectionIndex();
        if (index != -1) {
            String item = this.list.getItem(index);
            ListItemDialog dialog = new ListItemDialog(this.list.getShell(), "Edit " + this.itemDescription, this.itemDescription, item);
            if (dialog.open() != 0) {
                return;
            }
            String newItem = dialog.getItem();
            if (newItem != null && newItem.length() > 0 && !newItem.equals(item)) {
                this.list.setItem(index, newItem);
                this.selectionChanged();
            }
        }
    }

    private final void moveUpSelectedItem() {
        int index = this.list.getSelectionIndex();
        String item = this.list.getItem(index);
        String previous = this.list.getItem(index - 1);
        this.list.setItem(index - 1, item);
        this.list.setItem(index, previous);
        this.list.setSelection(index - 1);
        this.selectionChanged();
    }

    private final void moveDownSelectedItem() {
        int index = this.list.getSelectionIndex();
        String item = this.list.getItem(index);
        String previous = this.list.getItem(index + 1);
        this.list.setItem(index + 1, item);
        this.list.setItem(index, previous);
        this.list.setSelection(index + 1);
        this.selectionChanged();
    }

    public final void setEnabled(boolean enabled) {
        this.toolBar.setEnabled(enabled);
        this.title.setEnabled(enabled);
        this.list.setEnabled(enabled);
        if (enabled) {
            this.selectionChanged();
        } else {
            this.addItem.setEnabled(enabled);
            this.deleteItem.setEnabled(enabled);
            this.editItem.setEnabled(enabled);
            this.moveUpItem.setEnabled(enabled);
            this.moveDownItem.setEnabled(enabled);
        }
    }
}

