/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards.projectFormat;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.properties.data.ProjectBuildPropertyData;
import org.eclipse.titan.designer.wizards.projectFormat.TITANProjectExporter;

public final class TITANAutomaticProjectExporter {
    private static IPreferencesService preferenceService = Platform.getPreferencesService();
    private static String projectFileName;

    private static boolean automaticExportRequested() {
        return preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.automaticExport", false, null);
    }

    private static boolean isRequestedLocation() {
        return preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.requestLocation", false, null);
    }

    private static boolean isAlreadyExported(IProject project) {
        if (project == null) {
            return false;
        }
        String exported = "true";
        try {
            exported = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "alreadyExported"));
        }
        catch (CoreException e) {
            ErrorReporter.logError((String)"Project property 'alreadyExported` cannot be loaded");
        }
        return "true".equals(exported);
    }

    public static boolean saveAllAutomatically(IProject project) {
        if (project == null) {
            ErrorReporter.logError((String)"Invalid project");
            return false;
        }
        if (!TITANAutomaticProjectExporter.automaticExportRequested()) {
            return false;
        }
        TITANProjectExporter exporter = new TITANProjectExporter(project);
        exporter.setProjectFileFromLoadLocation();
        exporter.setExportPreferences();
        if (TITANAutomaticProjectExporter.isRequestedLocation() && !TITANAutomaticProjectExporter.isAlreadyExported(project)) {
            projectFileName = exporter.getProjectFile();
            if (projectFileName == null) {
                projectFileName = project.getLocation() != null ? project.getLocation().append(project.getName() + ".tpd").toOSString() : project.getName() + ".tpd";
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    FileDialog dialog = new FileDialog(new Shell(Display.getDefault(), 16384));
                    dialog.setText("Location for the TITAN Project Descriptor (tpd) file");
                    dialog.setFileName(projectFileName);
                    dialog.setFilterExtensions(new String[]{"*.tpd"});
                    projectFileName = dialog.open();
                }
            });
            if (projectFileName == null) {
                return false;
            }
            Path temp = new Path(projectFileName);
            projectFileName = temp.toString();
            ProjectBuildPropertyData.setLoadLocation(project, projectFileName);
            exporter.setProjectFileFromLoadLocation();
            return exporter.saveAll();
        }
        return exporter.saveAll();
    }
}

