/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards.projectFormat;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

class TITANProjectExportOptionsPage
extends WizardPage {
    private static final String TITLE = "TITAN Project exportation options";
    private Button excludeWorkingDirectoryContents;
    private boolean isExcludedWorkingDirectoryContents = true;
    private Button excludeDotResources;
    private boolean isExcludedDotResources = true;
    private Button excludeLinkedContents;
    private boolean isExcludeLinkedContents = false;
    private Button saveDefaultValues;
    private boolean isSaveDefaultValues = false;
    private Button packAllProjectsIntoOne;
    private boolean isPackAllProjectsIntoOne = false;
    private Button useTpdNameAttribute;
    private boolean isUseTpdNameAttribute = false;
    private IPreferencesService preferenceService = Platform.getPreferencesService();

    public TITANProjectExportOptionsPage(boolean useTpdName) {
        super(TITLE);
        this.setExportPreferences();
        this.isUseTpdNameAttribute = useTpdName;
    }

    private void setExportPreferences() {
        this.isExcludedWorkingDirectoryContents = this.preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.excludeWorkingDirectoryContents", true, null);
        this.isExcludedDotResources = this.preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.excludeDotResources", true, null);
        this.isExcludeLinkedContents = this.preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.excludeLinkedContents", true, null);
        this.isSaveDefaultValues = this.preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.saveDefaultValues", true, null);
        this.isPackAllProjectsIntoOne = this.preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.packAllProjectsIntoOne", true, null);
    }

    public String getDescription() {
        return "Fine tune the amount of data saved about the project";
    }

    public String getTitle() {
        return TITLE;
    }

    public boolean isExcludedWorkingDirectoryContents() {
        return this.isExcludedWorkingDirectoryContents;
    }

    public boolean isExcludedDotResources() {
        return this.isExcludedDotResources;
    }

    public boolean isExcludeLinkedContents() {
        return this.isExcludeLinkedContents;
    }

    public boolean isSaveDefaultValues() {
        return this.isSaveDefaultValues;
    }

    public boolean isPackAllProjectsIntoOne() {
        return this.isPackAllProjectsIntoOne;
    }

    public boolean isUseTpdNameAttribute() {
        return this.isUseTpdNameAttribute;
    }

    public void createControl(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        pageComposite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        pageComposite.setLayoutData((Object)data);
        this.excludeWorkingDirectoryContents = new Button(pageComposite, 32);
        this.excludeWorkingDirectoryContents.setText("Do not generate information on the contents of the working directory");
        this.excludeWorkingDirectoryContents.setEnabled(true);
        this.excludeWorkingDirectoryContents.setSelection(this.isExcludedWorkingDirectoryContents);
        this.excludeWorkingDirectoryContents.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TITANProjectExportOptionsPage.this.isExcludedWorkingDirectoryContents = TITANProjectExportOptionsPage.this.excludeWorkingDirectoryContents.getSelection();
            }
        });
        this.excludeDotResources = new Button(pageComposite, 32);
        this.excludeDotResources.setText("Do not generate information on resources whose name starts with a `.'");
        this.excludeDotResources.setEnabled(true);
        this.excludeDotResources.setSelection(this.isExcludedDotResources);
        this.excludeDotResources.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TITANProjectExportOptionsPage.this.isExcludedDotResources = TITANProjectExportOptionsPage.this.excludeDotResources.getSelection();
            }
        });
        this.excludeLinkedContents = new Button(pageComposite, 32);
        this.excludeLinkedContents.setText("Do not generate information on resources which are contained in a linked resource.");
        this.excludeLinkedContents.setEnabled(true);
        this.excludeLinkedContents.setSelection(this.isExcludeLinkedContents);
        this.excludeLinkedContents.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TITANProjectExportOptionsPage.this.isExcludeLinkedContents = TITANProjectExportOptionsPage.this.excludeLinkedContents.getSelection();
            }
        });
        this.saveDefaultValues = new Button(pageComposite, 32);
        this.saveDefaultValues.setText("Save default values");
        this.saveDefaultValues.setEnabled(true);
        this.saveDefaultValues.setSelection(this.isSaveDefaultValues);
        this.saveDefaultValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TITANProjectExportOptionsPage.this.isSaveDefaultValues = TITANProjectExportOptionsPage.this.saveDefaultValues.getSelection();
            }
        });
        this.packAllProjectsIntoOne = new Button(pageComposite, 32);
        this.packAllProjectsIntoOne.setText("Pack all data of related projects in this descriptor");
        this.packAllProjectsIntoOne.setEnabled(true);
        this.packAllProjectsIntoOne.setSelection(this.isPackAllProjectsIntoOne);
        this.packAllProjectsIntoOne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TITANProjectExportOptionsPage.this.isPackAllProjectsIntoOne = TITANProjectExportOptionsPage.this.packAllProjectsIntoOne.getSelection();
            }
        });
        this.useTpdNameAttribute = new Button(pageComposite, 32);
        this.useTpdNameAttribute.setText("Export tpdName attribute to referenced projects");
        this.useTpdNameAttribute.setToolTipText("See Referred project usage with\u00a0\u2013I\u00a0switch section in the TITAN Reference guide");
        this.useTpdNameAttribute.setEnabled(true);
        this.useTpdNameAttribute.setSelection(this.isUseTpdNameAttribute);
        this.useTpdNameAttribute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TITANProjectExportOptionsPage.this.isUseTpdNameAttribute = TITANProjectExportOptionsPage.this.useTpdNameAttribute.getSelection();
            }
        });
        this.setControl((Control)pageComposite);
    }
}

