/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.converter;

public enum Colors {
    WHITE("#ffffff"),
    BLACK("#000000");

    public final String hexvalue;
    public final double red;
    public final double green;
    public final double blue;

    private Colors(String hex) {
        this.hexvalue = hex;
        this.red = Colors.hexRed(hex);
        this.green = Colors.hexGreen(hex);
        this.blue = Colors.hexBlue(hex);
    }

    public static double hexRed(String color) {
        if (color.length() == 4) {
            return (double)Integer.parseInt(String.valueOf(color.substring(1, 2)) + color.substring(1, 2), 16) / 255.0;
        }
        return (double)Integer.parseInt(color.substring(1, 3), 16) / 255.0;
    }

    public static double hexGreen(String color) {
        if (color.length() == 4) {
            return (double)Integer.parseInt(String.valueOf(color.substring(2, 3)) + color.substring(2, 3), 16) / 255.0;
        }
        return (double)Integer.parseInt(color.substring(3, 5), 16) / 255.0;
    }

    public static double hexBlue(String color) {
        if (color.length() == 4) {
            return (double)Integer.parseInt(String.valueOf(color.substring(3, 4)) + color.substring(3, 4), 16) / 255.0;
        }
        return (double)Integer.parseInt(color.substring(5, 7), 16) / 255.0;
    }

    public static Colors findColorByHex(String hex) {
        Colors[] colorsArray = Colors.values();
        int n = colorsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Colors c = colorsArray[n2];
            if (c.hexvalue.equals(hex)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public static Colors findColorByName(String name) {
        Colors[] colorsArray = Colors.values();
        int n = colorsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Colors c = colorsArray[n2];
            if (c.name().toUpperCase().equals(name.toUpperCase())) {
                return c;
            }
            ++n2;
        }
        return null;
    }
}

