/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtext.tasks.ITaskParser;
import org.eclipse.xtext.tasks.Task;
import org.eclipse.xtext.tasks.TaskTag;
import org.eclipse.xtext.tasks.TaskTags;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DefaultTaskParser
implements ITaskParser {
    @Override
    public List<Task> parseTasks(String source, TaskTags taskTags) {
        ArrayList _xblockexpression = null;
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)taskTags);
        if (_isEmpty) {
            return Collections.emptyList();
        }
        Map<String, TaskTag> taskTagsByName = this.getTaskTagsByName(taskTags);
        Matcher matcher = this.toPattern(taskTags).matcher(source);
        ArrayList tasks = null;
        int prevLine = 1;
        int prevOffset = 0;
        while (matcher.find()) {
            if (tasks == null) {
                tasks = CollectionLiterals.newArrayList();
            }
            Task task = new Task();
            String matchedTag = matcher.group(2);
            String _xifexpression = null;
            boolean _isCaseSensitive = taskTags.isCaseSensitive();
            _xifexpression = _isCaseSensitive ? matchedTag : matchedTag.toLowerCase();
            task.setTag(taskTagsByName.get(_xifexpression));
            task.setDescription(matcher.group(3));
            task.setOffset(matcher.start(2));
            int _countLineBreaks = Strings.countLineBreaks((CharSequence)source, (int)prevOffset, (int)task.getOffset());
            int _plus = _countLineBreaks + prevLine;
            task.setLineNumber(_plus);
            prevLine = task.getLineNumber();
            prevOffset = task.getOffset();
            tasks.add(task);
        }
        List<Object> _elvis = null;
        if (tasks != null) {
            _elvis = tasks;
        } else {
            List _emptyList = Collections.emptyList();
            _elvis = _emptyList;
        }
        _xblockexpression = _elvis;
        return _xblockexpression;
    }

    protected Map<String, TaskTag> getTaskTagsByName(TaskTags taskTags) {
        return taskTags.getTaskTagsByName();
    }

    protected Pattern toPattern(TaskTags taskTags) {
        return taskTags.toPattern();
    }
}

