/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.internal.services.EclipseAdapter;
import org.eclipse.e4.core.services.adapter.Adapter;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.ILoggerProvider;
import org.eclipse.e4.core.services.translation.TranslationProviderFactory;
import org.eclipse.e4.core.services.translation.TranslationService;
import org.eclipse.e4.ui.internal.workbench.ActiveChildLookupFunction;
import org.eclipse.e4.ui.internal.workbench.ActivePartLookupFunction;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.ExceptionHandler;
import org.eclipse.e4.ui.internal.workbench.ModelServiceImpl;
import org.eclipse.e4.ui.internal.workbench.PlaceholderResolver;
import org.eclipse.e4.ui.internal.workbench.ReflectionContributionFactory;
import org.eclipse.e4.ui.internal.workbench.SelectionAggregator;
import org.eclipse.e4.ui.internal.workbench.SelectionServiceImpl;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IExceptionHandler;
import org.eclipse.e4.ui.workbench.IModelResourceHandler;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessAdditions;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessRemovals;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPlaceholderResolver;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fx.core.SystemUtils;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.app.ApplicationContext;
import org.eclipse.fx.core.app.ApplicationLocation;
import org.eclipse.fx.core.app.ExitStatus;
import org.eclipse.fx.core.geom.Bounds;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.ui.services.restart.LifecycleRV;
import org.eclipse.fx.ui.services.restart.RestartService;
import org.eclipse.fx.ui.services.startup.StartupProgressTrackerService;
import org.eclipse.fx.ui.workbench.base.Util;
import org.eclipse.fx.ui.workbench.base.internal.CommandEventDispatcher;
import org.eclipse.fx.ui.workbench.base.internal.EFX_ResourceHandler;
import org.eclipse.fx.ui.workbench.base.internal.LoggerProviderImpl;
import org.eclipse.fx.ui.workbench.base.restart.RestartPreferenceUtil;
import org.eclipse.fx.ui.workbench.base.restart.RestartServiceImpl;
import org.eclipse.fx.ui.workbench.services.EModelStylingService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractE4Application {
    public static final String THEME_ID = "cssTheme";
    private static final String WORKSPACE_VERSION_KEY = "org.eclipse.core.runtime";
    private static final String WORKSPACE_VERSION_VALUE = "2";
    private static final String METADATA_FOLDER = ".metadata";
    private static final String VERSION_FILENAME = "version.ini";
    protected static final String EXIT_CODE = "e4.osgi.exit.code";
    private static final String SCREEN_SETUP = "efx.screensetup";
    private static final String RESTORE_SIZE = "efx.restore-size";
    Object lcManager;
    private IModelResourceHandler handler;
    private static Logger LOGGER = LoggerCreator.createLogger(AbstractE4Application.class);
    private MApplication applicationModel;

    protected abstract @NonNull Realm createRealm(@NonNull IEclipseContext var1);

    protected abstract @NonNull IResourceUtilities<?> createResourceUtility(@NonNull IEclipseContext var1);

    protected abstract @NonNull String getDefaultPresentationEngineURI(@NonNull IEclipseContext var1);

    protected List<ScreenStruct> getScreensetup() {
        return Collections.emptyList();
    }

    protected final Optional<MApplication> getApplicationModel() {
        return Optional.ofNullable(this.applicationModel);
    }

    protected static String[] getApplicationArguments(ApplicationContext applicationContext) {
        return applicationContext.getApplicationArguments();
    }

    public @Nullable E4Workbench createE4Workbench(ApplicationContext applicationContext, IEclipseContext appContext) {
        ContextInjectionFactory.setDefault((IEclipseContext)appContext);
        appContext.set(Realm.class, (Object)this.createRealm(appContext));
        appContext.set(ApplicationContext.class, (Object)applicationContext);
        appContext.set(EModelStylingService.class, (Object)new EModelStylingService(){
            private static final String PREFIX = "efx_styleclass:";

            public void addStyles(MUIElement element, String ... tags) {
                List toAdd = Stream.of(tags).map(t -> PREFIX + t).filter(t -> !element.getTags().contains(t)).collect(Collectors.toList());
                element.getTags().addAll(toAdd);
            }

            public void removeStyles(MUIElement element, String ... tags) {
                List cssTags = Stream.of(tags).map(t -> PREFIX + t).collect(Collectors.toList());
                element.getTags().removeAll(cssTags);
            }

            public List<String> getStyles(MUIElement element) {
                return this.getStylesFromTags(element.getTags());
            }

            public List<String> getStylesFromTags(List<String> tags) {
                return tags.stream().filter(t -> t.startsWith(PREFIX)).map(t -> t.substring(PREFIX.length())).collect(Collectors.toList());
            }
        });
        appContext.set(IResourceUtilities.class, this.createResourceUtility(appContext));
        if (!appContext.containsKey("org.eclipse.e4.ui.workbench.modeling.EModelService")) {
            throw new IllegalStateException("Core services not available. Please make sure that a declarative service implementation (such as the bundle 'org.eclipse.equinox.ds') is available!");
        }
        StartupProgressTrackerService startupProgressTrackerService = (StartupProgressTrackerService)appContext.get(StartupProgressTrackerService.class);
        if (startupProgressTrackerService != null) {
            try {
                ContextInjectionFactory.inject((Object)startupProgressTrackerService, (IEclipseContext)appContext);
            }
            catch (Throwable t) {
                LOGGER.error("Could not fully initialize the startup tracker", t);
            }
            startupProgressTrackerService.stateReached((StartupProgressTrackerService.ProgressState)StartupProgressTrackerService.DefaultProgressState.DI_SYSTEM_INITIALIZED);
            ((IEventBroker)appContext.get(IEventBroker.class)).subscribe("org/eclipse/fx/ui/workbench/base/rendering/window/shown", e -> startupProgressTrackerService.stateReached((StartupProgressTrackerService.ProgressState)StartupProgressTrackerService.DefaultProgressState.WORKBENCH_GUI_SHOWN));
        }
        IContributionFactory factory = (IContributionFactory)appContext.get(IContributionFactory.class.getName());
        this.preLifecycle(appContext);
        LifecycleRV rv = LifecycleRV.CONTINUE;
        String lifeCycleURI = AbstractE4Application.getArgValue("lifeCycleURI", applicationContext, false);
        if (lifeCycleURI != null) {
            this.lcManager = factory.create(lifeCycleURI, appContext);
            if (this.lcManager != null) {
                rv = this.invokePostContextCreate(appContext);
            }
        }
        if (startupProgressTrackerService != null) {
            startupProgressTrackerService.stateReached((StartupProgressTrackerService.ProgressState)StartupProgressTrackerService.DefaultProgressState.POST_CONTEXT_LF_FINISHED);
        }
        switch (rv) {
            case RESTART_CLEAR_STATE: {
                RestartPreferenceUtil prefUtil = (RestartPreferenceUtil)ContextInjectionFactory.make(RestartPreferenceUtil.class, (IEclipseContext)appContext);
                prefUtil.setClearPersistedStateOnRestart(true);
            }
            case RESTART: {
                appContext.set(EXIT_CODE, (Object)ExitStatus.RESTART);
            }
            case SHUTDOWN: {
                return null;
            }
            case CONTINUE: {
                break;
            }
        }
        String toolItemTimer = AbstractE4Application.getArgValue("efx_TOOLITEM_TIMER", applicationContext, false);
        if (toolItemTimer != null) {
            try {
                appContext.set("efx_TOOLITEM_TIMER", (Object)Long.valueOf(toolItemTimer));
            }
            catch (NumberFormatException e2) {
                LOGGER.error("Unable to parse 'efx_TOOLITEM_TIMER' value '" + toolItemTimer + "'", (Throwable)e2);
            }
        }
        this.applicationModel = this.loadApplicationModel(applicationContext, appContext);
        this.applicationModel.setContext(appContext);
        ThreadSynchronize threadSync = (ThreadSynchronize)appContext.get(ThreadSynchronize.class);
        threadSync.syncExec(() -> this.handleOffscreenWindows(appContext));
        Util.setup((MContext)this.applicationModel, appContext);
        this.initializeServices(this.applicationModel);
        if (this.lcManager != null) {
            ContextInjectionFactory.invoke((Object)this.lcManager, ProcessAdditions.class, (IEclipseContext)appContext, null);
            ContextInjectionFactory.invoke((Object)this.lcManager, ProcessRemovals.class, (IEclipseContext)appContext, null);
        }
        IEclipseContext addonStaticContext = EclipseContextFactory.create();
        for (MAddon addon : this.applicationModel.getAddons()) {
            addonStaticContext.set(MAddon.class, (Object)addon);
            Object obj = factory.create(addon.getContributionURI(), appContext, addonStaticContext);
            addon.setObject(obj);
        }
        String xmiURI = AbstractE4Application.getArgValue("applicationXMI", applicationContext, false);
        appContext.set("applicationXMI", (Object)xmiURI);
        String themeId = AbstractE4Application.getArgValue(THEME_ID, applicationContext, false);
        appContext.set(THEME_ID, (Object)themeId);
        appContext.set("rendererFactoryUri", (Object)AbstractE4Application.getArgValue("rendererFactoryUri", applicationContext, false));
        String presentationURI = AbstractE4Application.getArgValue("presentationURI", applicationContext, false);
        if (presentationURI == null) {
            presentationURI = this.getDefaultPresentationEngineURI(appContext);
        }
        appContext.set("presentationURI", (Object)presentationURI);
        this.preCreateWorkbench(appContext);
        E4Workbench workbench = new E4Workbench((MApplicationElement)this.applicationModel, appContext);
        appContext.set(RestartService.class, (Object)((RestartService)ContextInjectionFactory.make(RestartServiceImpl.class, (IEclipseContext)appContext)));
        return workbench;
    }

    private void handleOffscreenWindows(IEclipseContext appContext) {
        EModelService service = (EModelService)appContext.get(EModelService.class);
        List windows = service.findElements((MUIElement)this.applicationModel, null, MWindow.class, Collections.emptyList());
        List<ScreenStruct> screens = this.getScreensetup();
        List bounds = screens.stream().map(s -> new Bounds((double)s.x, (double)s.y, (double)s.width, (double)s.height)).collect(Collectors.toList());
        for (MWindow w : windows) {
            String restoreSize = (String)w.getPersistedState().get(RESTORE_SIZE);
            Bounds b = new Bounds((double)w.getX(), (double)w.getY(), (double)w.getWidth(), (double)w.getHeight());
            if (bounds.stream().noneMatch(v -> v.intersects(b))) {
                int x = 50;
                int y = 50;
                int width = 800;
                int height = 600;
                if (restoreSize != null && !screens.isEmpty()) {
                    ScreenStruct screen = screens.stream().filter(s -> s.primary).findFirst().orElse(screens.get(0));
                    x = screen.x;
                    y = screen.y;
                } else if (restoreSize != null) {
                    try {
                        String[] parts = restoreSize.split(" ");
                        if (parts.length == 4) {
                            x = Integer.parseInt(parts[0]);
                            y = Integer.parseInt(parts[1]);
                            width = Integer.parseInt(parts[2]);
                            height = Integer.parseInt(parts[3]);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.errorf("Unable to parse restore size %s", (Throwable)e, new Object[]{restoreSize});
                    }
                }
                w.setX(x);
                w.setY(y);
                if (SystemUtils.isWindows() && w.getHeight() < 50) {
                    w.setWidth(width);
                    w.setHeight(height);
                }
            }
            if (restoreSize != null) continue;
            w.getPersistedState().put(RESTORE_SIZE, String.format("%s %s %s %s", w.getX(), w.getY(), w.getWidth(), w.getHeight()));
        }
    }

    private LifecycleRV invokePostContextCreate(final IEclipseContext appContext) {
        ThreadSynchronize uiSynchronize = (ThreadSynchronize)appContext.get(ThreadSynchronize.class);
        Object rv = uiSynchronize.syncExec((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ContextInjectionFactory.invoke((Object)AbstractE4Application.this.lcManager, PostContextCreate.class, (IEclipseContext)appContext, (Object)Boolean.TRUE);
            }
        }, null);
        if (rv == null) {
            return LifecycleRV.CONTINUE;
        }
        if (rv instanceof Boolean) {
            return (Boolean)rv != false ? LifecycleRV.CONTINUE : LifecycleRV.SHUTDOWN;
        }
        if (rv instanceof LifecycleRV) {
            return (LifecycleRV)rv;
        }
        LOGGER.warning("Unrecognised return value type from @PostContextCreate. The expected types are Boolean or LifecycleRV.");
        return LifecycleRV.CONTINUE;
    }

    public void saveModel() {
        try {
            this.handler.save();
        }
        catch (IOException e) {
            LOGGER.error("Unable to persist the model", (Throwable)e);
        }
    }

    protected @Nullable Object getLifecycleManager() {
        return this.lcManager;
    }

    protected void preLifecycle(IEclipseContext appContext) {
    }

    protected void preCreateWorkbench(IEclipseContext appContext) {
    }

    private MApplication loadApplicationModel(ApplicationContext appContext, IEclipseContext eclipseContext) {
        MApplication theApp = null;
        String appModelPath = AbstractE4Application.getArgValue("applicationXMI", appContext, false, eclipseContext);
        Assert.isNotNull((Object)appModelPath, (String)"applicationXMI argument missing");
        URI initialWorkbenchDefinitionInstance = URI.createPlatformPluginURI((String)appModelPath, (boolean)true);
        eclipseContext.set("initialWorkbenchModelURI", (Object)initialWorkbenchDefinitionInstance);
        eclipseContext.set("instanceLocation", appContext.getInstanceLocation().orElse(null));
        String value = AbstractE4Application.getArgValue("persistState", appContext, false, eclipseContext);
        boolean saveAndRestore = value == null || Boolean.parseBoolean(value);
        eclipseContext.set("persistState", (Object)saveAndRestore);
        value = AbstractE4Application.getArgValue("clearPersistedState", appContext, true, eclipseContext);
        boolean clearPersistedState = value != null && Boolean.parseBoolean(value);
        RestartPreferenceUtil restartUtil = (RestartPreferenceUtil)ContextInjectionFactory.make(RestartPreferenceUtil.class, (IEclipseContext)eclipseContext);
        if (!clearPersistedState) {
            clearPersistedState = restartUtil.isClearPersistedStateOnRestart();
        }
        eclipseContext.set("clearPersistedState", (Object)clearPersistedState);
        String deltaRestoreKey = "deltaRestore";
        value = AbstractE4Application.getArgValue(deltaRestoreKey, appContext, false, eclipseContext);
        boolean deltaRestore = value == null || Boolean.parseBoolean(value);
        eclipseContext.set(deltaRestoreKey, (Object)deltaRestore);
        String resourceHandler = AbstractE4Application.getArgValue("modelResourceHandler", appContext, false, eclipseContext);
        if (resourceHandler == null) {
            resourceHandler = "bundleclass://org.eclipse.fx.ui.workbench.base/" + EFX_ResourceHandler.class.getName();
        }
        IContributionFactory factory = (IContributionFactory)eclipseContext.get(IContributionFactory.class);
        this.handler = (IModelResourceHandler)factory.create(resourceHandler, eclipseContext);
        Resource resource = this.handler.loadMostRecentModel();
        theApp = (MApplication)resource.getContents().get(0);
        restartUtil.setClearPersistedStateOnRestart(false);
        return theApp;
    }

    private static String getArgValue(String argName, ApplicationContext applicationContext, boolean singledCmdArgValue, IEclipseContext eclipseContext) {
        Object value = eclipseContext.get(argName);
        if (value != null) {
            return value.toString();
        }
        return AbstractE4Application.getArgValue(argName, applicationContext, singledCmdArgValue);
    }

    protected IEclipseContext createApplicationContext() {
        IEclipseContext serviceContext = E4Workbench.getServiceContext();
        IEclipseContext appContext = serviceContext.createChild("WorkbenchContext");
        appContext.set("applicationContext", (Object)appContext);
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        ExceptionHandler exceptionHandler = new ExceptionHandler();
        ReflectionContributionFactory contributionFactory = new ReflectionContributionFactory(registry);
        appContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        appContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        appContext.set(IExceptionHandler.class.getName(), (Object)exceptionHandler);
        appContext.set("org.eclipse.e4.core.locale", (Object)Locale.getDefault());
        if (appContext.get(ILoggerProvider.class) == null) {
            serviceContext.set(ILoggerProvider.class, (Object)((ILoggerProvider)ContextInjectionFactory.make(LoggerProviderImpl.class, (IEclipseContext)serviceContext)));
        }
        appContext.set(org.eclipse.e4.core.services.log.Logger.class.getName(), (Object)((ILoggerProvider)serviceContext.get(ILoggerProvider.class)).getClassLogger(E4Workbench.class));
        appContext.set(EModelService.class, (Object)new ModelServiceImpl(appContext));
        appContext.set(EPlaceholderResolver.class, (Object)new PlaceholderResolver());
        TranslationService bundleTranslationProvider = TranslationProviderFactory.bundleTranslationService((IEclipseContext)appContext);
        appContext.set(TranslationService.class, (Object)bundleTranslationProvider);
        appContext.set(Adapter.class.getName(), ContextInjectionFactory.make(EclipseAdapter.class, (IEclipseContext)appContext));
        appContext.set("e4ActivePart", (Object)new ActivePartLookupFunction());
        appContext.set("activeShell", (Object)new ActiveChildLookupFunction("activeShell", "localActiveShell"));
        return appContext;
    }

    protected void initializeServices(MApplication appModel) {
        IEclipseContext appContext = appModel.getContext();
        this.initializeApplicationServices(appContext);
        List windows = appModel.getChildren();
        for (MWindow childWindow : windows) {
            this.initializeWindowServices(childWindow);
        }
        ((EObject)appModel).eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeatureID(MApplication.class) != 16) {
                    return;
                }
                if (notification.getEventType() != 3) {
                    return;
                }
                MWindow childWindow = (MWindow)notification.getNewValue();
                AbstractE4Application.this.initializeWindowServices(childWindow);
            }
        });
    }

    protected void initializeApplicationServices(IEclipseContext appContext) {
        final IEclipseContext theContext = appContext;
        appContext.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                IEclipseContext activeChildContext = context.getActiveChild();
                if (activeChildContext != null) {
                    Object selection = activeChildContext.get("org.eclipse.ui.selection");
                    theContext.set("org.eclipse.ui.selection", selection);
                }
                return true;
            }
        });
        appContext.set(ESelectionService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return ContextInjectionFactory.make(SelectionServiceImpl.class, (IEclipseContext)context);
            }
        });
        ContextInjectionFactory.make(CommandEventDispatcher.class, (IEclipseContext)appContext);
    }

    protected void initializeWindowServices(MWindow childWindow) {
        IEclipseContext windowContext = childWindow.getContext();
        this.initWindowContext(windowContext);
        ((EObject)childWindow).eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeatureID(MWindow.class) != 23) {
                    return;
                }
                IEclipseContext windowContext = (IEclipseContext)notification.getNewValue();
                AbstractE4Application.this.initWindowContext(windowContext);
            }
        });
    }

    protected void initWindowContext(IEclipseContext windowContext) {
        if (windowContext == null) {
            return;
        }
        SelectionAggregator selectionAggregator = (SelectionAggregator)ContextInjectionFactory.make(SelectionAggregator.class, (IEclipseContext)windowContext);
        windowContext.set(SelectionAggregator.class, (Object)selectionAggregator);
    }

    protected static @Nullable String getArgValue(String argName, ApplicationContext applicationContext, boolean singledCmdArgValue) {
        int i;
        if (argName == null || argName.length() == 0) {
            return null;
        }
        String[] args = AbstractE4Application.getApplicationArguments(applicationContext);
        if (singledCmdArgValue) {
            i = 0;
            while (i < args.length) {
                if (("-" + argName).equals(args[i])) {
                    return "true";
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < args.length) {
                if (("-" + argName).equals(args[i]) && i + 1 < args.length) {
                    return args[i + 1];
                }
                ++i;
            }
        }
        String brandingProperty = (String)applicationContext.getApplicationProperty(argName);
        return brandingProperty == null ? System.getProperty(argName) : brandingProperty;
    }

    public boolean checkInstanceLocation(@Nullable ApplicationLocation instanceLocation, @NonNull IEclipseContext context) {
        block6: {
            if (instanceLocation == null && Boolean.FALSE.equals(context.get("persistState"))) {
                return true;
            }
            if (instanceLocation == null) {
                return false;
            }
            if (!AbstractE4Application.checkValidWorkspace(instanceLocation.getURL())) {
                return false;
            }
            if (!instanceLocation.lock()) break block6;
            AbstractE4Application.writeWorkspaceVersion(instanceLocation);
            return true;
        }
        try {
            File workspaceDirectory = new File(instanceLocation.getURL().getFile());
            workspaceDirectory.exists();
        }
        catch (IOException e) {
            LOGGER.error("Could not create instance location", (Throwable)e);
        }
        return false;
    }

    private static boolean checkValidWorkspace(URL url) {
        if (url == null) {
            return false;
        }
        String version = AbstractE4Application.readWorkspaceVersion(url);
        if (version == null) {
            return true;
        }
        int ide_version = Integer.parseInt(WORKSPACE_VERSION_VALUE);
        int workspace_version = Integer.parseInt(version);
        if (workspace_version == ide_version) {
            return true;
        }
        return true;
    }

    private static String readWorkspaceVersion(URL workspace) {
        File versionFile = AbstractE4Application.getVersionFile(workspace, false);
        if (versionFile == null || !versionFile.exists()) {
            return null;
        }
        try {
            Properties props = new Properties();
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream is = new FileInputStream(versionFile);){
                props.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return props.getProperty(WORKSPACE_VERSION_KEY);
        }
        catch (IOException e) {
            LOGGER.error("Unable to create workspace", (Throwable)e);
            return null;
        }
    }

    private static File getVersionFile(URL workspaceUrl, boolean create) {
        File versionFile;
        block6: {
            File metaDir;
            block5: {
                if (workspaceUrl == null) {
                    return null;
                }
                try {
                    metaDir = new File(workspaceUrl.getPath(), METADATA_FOLDER);
                    if (metaDir.exists() || create && metaDir.mkdir()) break block5;
                    return null;
                }
                catch (IOException e) {
                    return null;
                }
            }
            versionFile = new File(metaDir, VERSION_FILENAME);
            if (versionFile.exists() || create && versionFile.createNewFile()) break block6;
            return null;
        }
        return versionFile;
    }

    private static void writeWorkspaceVersion(ApplicationLocation instanceLoc) {
        if (instanceLoc == null || instanceLoc.isReadOnly()) {
            return;
        }
        File versionFile = AbstractE4Application.getVersionFile(instanceLoc.getURL(), true);
        if (versionFile == null) {
            return;
        }
        String versionLine = "org.eclipse.core.runtime=2";
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream output = new FileOutputStream(versionFile);){
                ((OutputStream)output).write(versionLine.getBytes("UTF-8"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to write workspace version", (Throwable)e);
        }
    }

    public static final class ScreenStruct {
        final boolean primary;
        final int x;
        final int y;
        final int width;
        final int height;

        public ScreenStruct(boolean primary, int x, int y, int width, int height) {
            this.primary = primary;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

