/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalVarExpression
extends Expression {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Identifier globalVarName;

    public GlobalVarExpression(Identifier globalVarName) {
        this.globalVarName = globalVarName;
    }

    public String getVarName() {
        return this.globalVarName.toString();
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Variable o = ctx.getGlobalVariables().get(this.globalVarName.toString());
        if (o == null) {
            this.logger.warn((Object)("Global variable '" + this.globalVarName.toString() + "' is null. Is it configured?"));
            return null;
        }
        return o.getValue();
    }

    @Override
    public Type analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        return ctx.getObjectType();
    }

    @Override
    protected String toStringInternal() {
        return "var " + this.globalVarName.toString();
    }
}

