/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import java.util.Arrays;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.EqualsHashCode;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Beta
public class EqualsHashCodeProcessor
extends AbstractClassProcessor {
    public void doTransform(MutableClassDeclaration it, final @Extension TransformationContext context) {
        boolean _tripleNotEquals;
        Type _findTypeGlobally = context.findTypeGlobally(Data.class);
        AnnotationReference _findAnnotation = it.findAnnotation(_findTypeGlobally);
        boolean bl = _tripleNotEquals = _findAnnotation != null;
        if (_tripleNotEquals) {
            return;
        }
        Util util = new Util(context);
        boolean _hasEquals = util.hasEquals((ClassDeclaration)it);
        if (_hasEquals) {
            Type _findTypeGlobally_1 = context.findTypeGlobally(EqualsHashCode.class);
            AnnotationReference annotation = it.findAnnotation(_findTypeGlobally_1);
            context.addWarning((Element)annotation, "equals is already defined, this annotation has no effect");
        } else {
            boolean _hasHashCode = util.hasHashCode((ClassDeclaration)it);
            if (_hasHashCode) {
                context.addWarning((Element)it, "hashCode is already defined, this annotation has no effect");
            } else {
                Iterable _declaredFields = it.getDeclaredFields();
                Functions.Function1<MutableFieldDeclaration, Boolean> _function = new Functions.Function1<MutableFieldDeclaration, Boolean>(){

                    public Boolean apply(MutableFieldDeclaration it) {
                        boolean _isThePrimaryGeneratedJavaElement;
                        boolean _isTransient;
                        boolean _not_1;
                        boolean _not;
                        boolean _and = false;
                        boolean _and_1 = false;
                        boolean _isStatic = it.isStatic();
                        boolean bl = _not = !_isStatic;
                        _and_1 = !_not ? false : (_not_1 = !(_isTransient = it.isTransient()));
                        _and = !_and_1 ? false : (_isThePrimaryGeneratedJavaElement = context.isThePrimaryGeneratedJavaElement((Element)it));
                        return _and;
                    }
                };
                Iterable fields = IterableExtensions.filter((Iterable)_declaredFields, (Functions.Function1)_function);
                boolean _hasSuperEquals = util.hasSuperEquals((ClassDeclaration)it);
                util.addEquals(it, fields, _hasSuperEquals);
                boolean _hasSuperHashCode = util.hasSuperHashCode((ClassDeclaration)it);
                util.addHashCode(it, fields, _hasSuperHashCode);
            }
        }
    }

    @Beta
    public static class Util {
        @Extension
        private TransformationContext context;

        public Util(TransformationContext context) {
            this.context = context;
        }

        public boolean hasHashCode(ClassDeclaration it) {
            MethodDeclaration _findDeclaredMethod = it.findDeclaredMethod("hashCode", new TypeReference[0]);
            return _findDeclaredMethod != null;
        }

        public boolean hasEquals(ClassDeclaration it) {
            Iterable _declaredMethods = it.getDeclaredMethods();
            Functions.Function1<MethodDeclaration, Boolean> _function = new Functions.Function1<MethodDeclaration, Boolean>(){

                public Boolean apply(MethodDeclaration it) {
                    Iterable _parameters;
                    int _size;
                    boolean _equals_1;
                    boolean _and = false;
                    boolean _and_1 = false;
                    String _simpleName = it.getSimpleName();
                    boolean _equals = Objects.equal((Object)_simpleName, (Object)"equals");
                    _and_1 = !_equals ? false : (_equals_1 = (_size = IterableExtensions.size((Iterable)(_parameters = it.getParameters()))) == 1);
                    if (!_and_1) {
                        _and = false;
                    } else {
                        boolean _equals_2;
                        Iterable _parameters_1 = it.getParameters();
                        ParameterDeclaration _head = (ParameterDeclaration)IterableExtensions.head((Iterable)_parameters_1);
                        TypeReference _type = _head.getType();
                        TypeReference _object = Util.this.context.getObject();
                        _and = _equals_2 = Objects.equal((Object)_type, (Object)_object);
                    }
                    return _and;
                }
            };
            return IterableExtensions.exists((Iterable)_declaredMethods, (Functions.Function1)_function);
        }

        public boolean hasSuperEquals(ClassDeclaration cls) {
            TypeReference _object;
            boolean _xblockexpression = false;
            TypeReference _extendedClass = cls.getExtendedClass();
            Type _type = _extendedClass.getType();
            ClassDeclaration superClass = (ClassDeclaration)_type;
            boolean _xifexpression = false;
            TypeReference _newTypeReference = this.context.newTypeReference((Type)superClass, new TypeReference[0]);
            boolean _equals = _newTypeReference.equals((Object)(_object = this.context.getObject()));
            if (_equals) {
                _xifexpression = false;
            } else {
                boolean _xifexpression_1 = false;
                boolean _hasEquals = this.hasEquals(superClass);
                _xifexpression_1 = _hasEquals ? true : this.hasSuperEquals(superClass);
                _xifexpression = _xifexpression_1;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public boolean hasSuperHashCode(ClassDeclaration cls) {
            TypeReference _object;
            boolean _xblockexpression = false;
            TypeReference _extendedClass = cls.getExtendedClass();
            Type _type = _extendedClass.getType();
            ClassDeclaration superClass = (ClassDeclaration)_type;
            boolean _xifexpression = false;
            TypeReference _newTypeReference = this.context.newTypeReference((Type)superClass, new TypeReference[0]);
            boolean _equals = _newTypeReference.equals((Object)(_object = this.context.getObject()));
            if (_equals) {
                _xifexpression = false;
            } else {
                boolean _xifexpression_1 = false;
                boolean _hasHashCode = this.hasHashCode(superClass);
                _xifexpression_1 = _hasHashCode ? true : this.hasSuperHashCode(superClass);
                _xifexpression = _xifexpression_1;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public void addEquals(final MutableClassDeclaration cls, final Iterable<? extends FieldDeclaration> includedFields, final boolean includeSuper) {
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    Element _primarySourceElement = Util.this.context.getPrimarySourceElement((Element)cls);
                    Util.this.context.setPrimarySourceElement((MutableElement)it, _primarySourceElement);
                    TypeReference _primitiveBoolean = Util.this.context.getPrimitiveBoolean();
                    it.setReturnType(_primitiveBoolean);
                    AnnotationReference _newAnnotationReference = Util.this.context.newAnnotationReference(Override.class);
                    it.addAnnotation(_newAnnotationReference);
                    AnnotationReference _newAnnotationReference_1 = Util.this.context.newAnnotationReference(Pure.class);
                    it.addAnnotation(_newAnnotationReference_1);
                    TypeReference _object = Util.this.context.getObject();
                    it.addParameter("obj", _object);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"if (this == obj)");
                            _builder.newLine();
                            _builder.append((Object)"  ");
                            _builder.append((Object)"return true;");
                            _builder.newLine();
                            _builder.append((Object)"if (obj == null)");
                            _builder.newLine();
                            _builder.append((Object)"  ");
                            _builder.append((Object)"return false;");
                            _builder.newLine();
                            _builder.append((Object)"if (getClass() != obj.getClass())");
                            _builder.newLine();
                            _builder.append((Object)"  ");
                            _builder.append((Object)"return false;");
                            _builder.newLine();
                            if (includeSuper) {
                                _builder.append((Object)"if (!super.equals(obj))");
                                _builder.newLine();
                                _builder.append((Object)"  ");
                                _builder.append((Object)"return false;");
                                _builder.newLine();
                            }
                            TypeReference _newWildCardSelfTypeReference = Util.this.newWildCardSelfTypeReference((ClassDeclaration)cls);
                            _builder.append((Object)_newWildCardSelfTypeReference, "");
                            _builder.append((Object)" other = (");
                            TypeReference _newWildCardSelfTypeReference_1 = Util.this.newWildCardSelfTypeReference((ClassDeclaration)cls);
                            _builder.append((Object)_newWildCardSelfTypeReference_1, "");
                            _builder.append((Object)") obj;");
                            _builder.newLineIfNotEmpty();
                            for (FieldDeclaration field : includedFields) {
                                StringConcatenationClient _contributeToEquals = Util.this.contributeToEquals(field);
                                _builder.append((Object)_contributeToEquals, "");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"return true;");
                            _builder.newLine();
                        }
                    };
                    it.setBody(_client);
                }
            };
            cls.addMethod("equals", (Procedures.Procedure1)_function);
        }

        private TypeReference newWildCardSelfTypeReference(ClassDeclaration cls) {
            Iterable _typeParameters = cls.getTypeParameters();
            Functions.Function1<TypeParameterDeclaration, TypeReference> _function = new Functions.Function1<TypeParameterDeclaration, TypeReference>(){

                public TypeReference apply(TypeParameterDeclaration it) {
                    TypeReference _object = Util.this.context.getObject();
                    return Util.this.context.newWildcardTypeReference(_object);
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)_typeParameters, (Functions.Function1)_function);
            return this.context.newTypeReference((Type)cls, (TypeReference[])Conversions.unwrapArray((Object)_map, TypeReference.class));
        }

        public StringConcatenationClient contributeToEquals(final FieldDeclaration it) {
            String _name_2;
            String _name_1;
            StringConcatenationClient _switchResult = null;
            TypeReference _type = it.getType();
            TypeReference _orObject = this.orObject(_type);
            String _name = _orObject.getName();
            boolean _matched = false;
            if (!_matched && Objects.equal((Object)_name, (Object)(_name_1 = Double.TYPE.getName()))) {
                StringConcatenationClient _client;
                _matched = true;
                _switchResult = _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (");
                        _builder.append(Double.class, "");
                        _builder.append((Object)".doubleToLongBits(other.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)") != ");
                        _builder.append(Double.class, "");
                        _builder.append((Object)".doubleToLongBits(this.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append((Object)_simpleName_1, "");
                        _builder.append((Object)"))");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"  ");
                        _builder.append((Object)"return false; ");
                        _builder.newLine();
                    }
                };
            }
            if (!_matched && Objects.equal((Object)_name, (Object)(_name_2 = Float.TYPE.getName()))) {
                StringConcatenationClient _client_1;
                _matched = true;
                _switchResult = _client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (");
                        _builder.append(Float.class, "");
                        _builder.append((Object)".floatToIntBits(other.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)") != ");
                        _builder.append(Float.class, "");
                        _builder.append((Object)".floatToIntBits(this.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append((Object)_simpleName_1, "");
                        _builder.append((Object)"))");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"  ");
                        _builder.append((Object)"return false; ");
                        _builder.newLine();
                    }
                };
            }
            if (!_matched) {
                String _name_8;
                String _name_7;
                String _name_6;
                String _name_5;
                String _name_4;
                String _name_3 = Boolean.TYPE.getName();
                if (Objects.equal((Object)_name, (Object)_name_3)) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_4 = Integer.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_5 = Character.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_6 = Byte.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_7 = Short.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_8 = Long.TYPE.getName()))) {
                    _matched = true;
                }
                if (_matched) {
                    StringConcatenationClient _client_2;
                    _switchResult = _client_2 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"if (other.");
                            String _simpleName = it.getSimpleName();
                            _builder.append((Object)_simpleName, "");
                            _builder.append((Object)" != this.");
                            String _simpleName_1 = it.getSimpleName();
                            _builder.append((Object)_simpleName_1, "");
                            _builder.append((Object)")");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"  ");
                            _builder.append((Object)"return false;");
                            _builder.newLine();
                        }
                    };
                }
            }
            if (!_matched) {
                StringConcatenationClient _client_3;
                _switchResult = _client_3 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)" == null) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"  ");
                        _builder.append((Object)"if (other.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append((Object)_simpleName_1, "  ");
                        _builder.append((Object)" != null)");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"    ");
                        _builder.append((Object)"return false;");
                        _builder.newLine();
                        _builder.append((Object)"} else if (!");
                        StringConcatenationClient _deepEquals = Util.this.deepEquals(it);
                        _builder.append((Object)_deepEquals, "");
                        _builder.append((Object)")");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"  ");
                        _builder.append((Object)"return false;");
                        _builder.newLine();
                    }
                };
            }
            return _switchResult;
        }

        public StringConcatenationClient deepEquals(final FieldDeclaration it) {
            StringConcatenationClient _xifexpression = null;
            TypeReference _type = it.getType();
            boolean _isArray = _type.isArray();
            if (_isArray) {
                StringConcatenationClient _client_1;
                StringConcatenationClient _client;
                StringConcatenationClient _xifexpression_1 = null;
                TypeReference _type_1 = it.getType();
                TypeReference _arrayComponentType = _type_1.getArrayComponentType();
                boolean _isPrimitive = _arrayComponentType.isPrimitive();
                _xifexpression_1 = _isPrimitive ? (_client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(Arrays.class, "");
                        _builder.append((Object)".equals(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)", other.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append((Object)_simpleName_1, "");
                        _builder.append((Object)")");
                    }
                }) : (_client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(Arrays.class, "");
                        _builder.append((Object)".deepEquals(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)", other.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append((Object)_simpleName_1, "");
                        _builder.append((Object)")");
                    }
                });
                _xifexpression = _xifexpression_1;
            } else {
                StringConcatenationClient _client_2;
                _xifexpression = _client_2 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)".equals(other.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append((Object)_simpleName_1, "");
                        _builder.append((Object)")");
                    }
                };
            }
            return _xifexpression;
        }

        public void addHashCode(final MutableClassDeclaration cls, final Iterable<? extends FieldDeclaration> includedFields, final boolean includeSuper) {
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    Element _primarySourceElement = Util.this.context.getPrimarySourceElement((Element)cls);
                    Util.this.context.setPrimarySourceElement((MutableElement)it, _primarySourceElement);
                    TypeReference _primitiveInt = Util.this.context.getPrimitiveInt();
                    it.setReturnType(_primitiveInt);
                    AnnotationReference _newAnnotationReference = Util.this.context.newAnnotationReference(Override.class);
                    it.addAnnotation(_newAnnotationReference);
                    AnnotationReference _newAnnotationReference_1 = Util.this.context.newAnnotationReference(Pure.class);
                    it.addAnnotation(_newAnnotationReference_1);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"final int prime = 31;");
                            _builder.newLine();
                            _builder.append((Object)"int result = ");
                            if (includeSuper) {
                                _builder.append((Object)"super.hashCode()");
                            } else {
                                _builder.append((Object)"1");
                            }
                            _builder.append((Object)";");
                            _builder.newLineIfNotEmpty();
                            for (FieldDeclaration field : includedFields) {
                                StringConcatenationClient _contributeToHashCode = Util.this.contributeToHashCode(field);
                                _builder.append((Object)_contributeToHashCode, "");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"return result;");
                            _builder.newLine();
                        }
                    };
                    it.setBody(_client);
                }
            };
            cls.addMethod("hashCode", (Procedures.Procedure1)_function);
        }

        public StringConcatenationClient contributeToHashCode(final FieldDeclaration it) {
            String _name_8;
            String _name_3;
            String _name_2;
            String _name_1;
            StringConcatenationClient _switchResult = null;
            TypeReference _type = it.getType();
            TypeReference _orObject = this.orObject(_type);
            String _name = _orObject.getName();
            boolean _matched = false;
            if (!_matched && Objects.equal((Object)_name, (Object)(_name_1 = Double.TYPE.getName()))) {
                StringConcatenationClient _client;
                _matched = true;
                _switchResult = _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"result = prime * result + (int) (");
                        _builder.append(Double.class, "");
                        _builder.append((Object)".doubleToLongBits(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)") ^ (");
                        _builder.append(Double.class, "");
                        _builder.append((Object)".doubleToLongBits(this.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append((Object)_simpleName_1, "");
                        _builder.append((Object)") >>> 32));");
                    }
                };
            }
            if (!_matched && Objects.equal((Object)_name, (Object)(_name_2 = Float.TYPE.getName()))) {
                StringConcatenationClient _client_1;
                _matched = true;
                _switchResult = _client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"result = prime * result + ");
                        _builder.append(Float.class, "");
                        _builder.append((Object)".floatToIntBits(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)");");
                    }
                };
            }
            if (!_matched && Objects.equal((Object)_name, (Object)(_name_3 = Boolean.TYPE.getName()))) {
                StringConcatenationClient _client_2;
                _matched = true;
                _switchResult = _client_2 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"result = prime * result + (this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)" ? 1231 : 1237);");
                    }
                };
            }
            if (!_matched) {
                String _name_7;
                String _name_6;
                String _name_5;
                String _name_4 = Integer.TYPE.getName();
                if (Objects.equal((Object)_name, (Object)_name_4)) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_5 = Character.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_6 = Byte.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_7 = Short.TYPE.getName()))) {
                    _matched = true;
                }
                if (_matched) {
                    StringConcatenationClient _client_3;
                    _switchResult = _client_3 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"result = prime * result + this.");
                            String _simpleName = it.getSimpleName();
                            _builder.append((Object)_simpleName, "");
                            _builder.append((Object)";");
                        }
                    };
                }
            }
            if (!_matched && Objects.equal((Object)_name, (Object)(_name_8 = Long.TYPE.getName()))) {
                StringConcatenationClient _client_4;
                _matched = true;
                _switchResult = _client_4 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"result = prime * result + (int) (this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)" ^ (this.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append((Object)_simpleName_1, "");
                        _builder.append((Object)" >>> 32));");
                    }
                };
            }
            if (!_matched) {
                StringConcatenationClient _client_5;
                _switchResult = _client_5 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"result = prime * result + ((this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)"== null) ? 0 : ");
                        StringConcatenationClient _deepHashCode = Util.this.deepHashCode(it);
                        _builder.append((Object)_deepHashCode, "");
                        _builder.append((Object)");");
                    }
                };
            }
            return _switchResult;
        }

        public StringConcatenationClient deepHashCode(final FieldDeclaration it) {
            StringConcatenationClient _xblockexpression = null;
            TypeReference _type = it.getType();
            TypeReference type = this.orObject(_type);
            StringConcatenationClient _xifexpression = null;
            boolean _isArray = type.isArray();
            if (_isArray) {
                StringConcatenationClient _client_1;
                StringConcatenationClient _client;
                StringConcatenationClient _xifexpression_1 = null;
                TypeReference _arrayComponentType = type.getArrayComponentType();
                boolean _isPrimitive = _arrayComponentType.isPrimitive();
                _xifexpression_1 = _isPrimitive ? (_client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(Arrays.class, "");
                        _builder.append((Object)".hashCode(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)")");
                    }
                }) : (_client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(Arrays.class, "");
                        _builder.append((Object)".deepHashCode(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)")");
                    }
                });
                _xifexpression = _xifexpression_1;
            } else {
                StringConcatenationClient _client_2;
                _xifexpression = _client_2 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)".hashCode()");
                    }
                };
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        private TypeReference orObject(TypeReference ref) {
            TypeReference _object;
            TypeReference _elvis = null;
            _elvis = ref != null ? ref : (_object = this.context.getObject());
            return _elvis;
        }
    }
}

