/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.ui.adapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.ide.css.cssext.ui.adapter.ClassPathSearchUtil;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ClasspathManager {
    private static ClasspathManager INSTANCE = new ClasspathManager();
    private Map<IProject, List<URI>> cache = new HashMap<IProject, List<URI>>();
    private Logger logger;
    private IElementChangedListener listener = new IElementChangedListener(){

        public void elementChanged(ElementChangedEvent event) {
            IJavaElementDelta[] iJavaElementDeltaArray = event.getDelta().getChangedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta d = iJavaElementDeltaArray[n2];
                if (d.getElement().getElementType() == 2) {
                    try {
                        IResource r = d.getElement().getCorrespondingResource();
                        if (r instanceof IProject) {
                            ClasspathManager.this.invalidateClasspath((IProject)r);
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
    };

    public static ClasspathManager getInstance() {
        return INSTANCE;
    }

    private ClasspathManager() {
        JavaCore.addElementChangedListener((IElementChangedListener)this.listener, (int)1);
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerCreator.createLogger(ClasspathManager.class);
        }
        return this.logger;
    }

    public void invalidateClasspath(IProject project) {
        this.getLogger().debug("invalidateClasspath(" + String.valueOf(project) + ")");
        this.cache.remove(project);
    }

    public List<URI> getClasspath(IProject project) {
        this.getLogger().debug("getClasspath(" + String.valueOf(project) + ")");
        List<URI> result = this.cache.get(project);
        if (result == null) {
            result = this.scanClasspath(project);
            this.cache.put(project, result);
        } else {
            this.getLogger().debug(" => result from cache");
        }
        return result;
    }

    private List<URI> scanClasspath(IProject project) {
        this.getLogger().debug("scanClasspath(" + String.valueOf(project) + ")");
        ArrayList<ClassPathSearchUtil.Entry> allFiles = new ArrayList<ClassPathSearchUtil.Entry>();
        try {
            IContainer workspace = project.getParent();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IWorkspaceRoot root = workspace.getWorkspace().getRoot();
            long locCount = 0L;
            IClasspathEntry[] resolvedClasspath = javaProject.getResolvedClasspath(true);
            allFiles.addAll(ClassPathSearchUtil.checkEntries(root, resolvedClasspath));
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        ArrayList<URI> extensions = new ArrayList<URI>();
        for (ClassPathSearchUtil.Entry entry : allFiles) {
            URI uri = entry.toURI();
            extensions.add(uri);
        }
        this.getLogger().debug(" => " + String.valueOf(extensions));
        return extensions;
    }
}

