/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.compare;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.template.TemplateModelFileHelper;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.editors.providers.PatternElementLabelProvider;
import org.eclipse.egf.pattern.utils.TemplateFileHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.swt.graphics.Image;

public class MethodCompareItem
implements IStreamContentAccessor,
ITypedElement,
IEditableContent {
    private PatternMethod patternMethod;
    private String name;

    public MethodCompareItem(PatternMethod patternMethod) {
        this.patternMethod = patternMethod;
    }

    public InputStream getContents() throws CoreException {
        BufferedReader bufferedReader = null;
        try {
            InputStream inputStream = TemplateModelFileHelper.getInputStream((PatternMethod)this.patternMethod);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line.replace("    ", "\t"));
                stringBuilder.append("\n");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuilder.toString().getBytes());
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, null, e.getMessage(), (Throwable)e));
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Image getImage() {
        return Activator.getDefault().getImage("obj16/method.gif");
    }

    public String getName() {
        if (this.name == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(new PatternElementLabelProvider().getText(this.patternMethod.getPattern()));
            stringBuilder.append(".");
            stringBuilder.append(this.patternMethod.getName());
            this.name = stringBuilder.toString();
        }
        return this.name;
    }

    public String getType() {
        return "txt";
    }

    public boolean isEditable() {
        return this.getFile().exists();
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        return dest;
    }

    public void setContent(byte[] newContent) {
        try {
            TemplateFileHelper.setContent((IFile)this.getFile(), (String)new String(newContent));
        }
        catch (CoreException e) {
            Activator.getDefault().log((IStatus)new Status(4, null, e.getMessage(), (Throwable)e));
        }
    }

    public IFile getFile() {
        URI templateURI = TemplateModelFileHelper.getTemplateURI((PatternMethod)this.patternMethod);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(templateURI.toPlatformString(true)));
        return file;
    }
}

