/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.jet.engine;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.egf.pattern.jet.engine.ExtendedJetCompiler;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETMark;
import org.eclipse.emf.codegen.jet.JETSkeleton;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkeletonJETCompiler
extends ExtendedJetCompiler {
    private static final String GENERATOR_SKELETON = "platform:/plugin/org.eclipse.egf.pattern.jet/templates/generator.skeleton";

    public SkeletonJETCompiler(String templateURI, InputStream inputStream, String encoding) throws JETException {
        super(templateURI, inputStream, encoding);
    }

    @Override
    public void handleDirective(String directive, JETMark start, JETMark stop, Map<String, String> attributes) throws JETException {
        if (directive.equals("jet") && this.skeleton == null) {
            this.skeleton = new CustomJETSkeleton();
            String skeletonURI = attributes.get("skeleton");
            if (skeletonURI == null) {
                skeletonURI = GENERATOR_SKELETON;
            }
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(SkeletonJETCompiler.openStream((String)SkeletonJETCompiler.resolveLocation((String[])this.templateURIPath, (String)this.templateURI, (String)skeletonURI)[1]));
                byte[] input = new byte[bufferedInputStream.available()];
                bufferedInputStream.read(input);
                bufferedInputStream.close();
                this.skeleton.setCompilationUnitContents(new String(input));
            }
            catch (IOException exception) {
                throw new JETException((Throwable)exception);
            }
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (entry.getKey().equals("skeleton")) continue;
                if (entry.getKey().equals("package")) {
                    this.skeleton.setPackageName(entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("imports")) {
                    this.skeleton.addImports(entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("class")) {
                    this.skeleton.setClassName(entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("nlString")) {
                    this.skeleton.setNLString(entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("startTag")) {
                    this.parser.setStartTag(entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("endTag")) {
                    this.parser.setEndTag(entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("version")) continue;
                throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.bad.attribute", new Object[]{entry.getKey(), start.format("jet.mark.file.line.column")}));
            }
            this.handleNewSkeleton();
        } else {
            super.handleDirective(directive, start, stop, attributes);
        }
    }

    public static class CustomJETSkeleton
    extends JETSkeleton {
        public void setParentClass(String classname) {
            IDOMNode node = this.compilationUnit.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 4) {
                    IDOMType type = (IDOMType)node;
                    type.setSuperclass(classname);
                }
                node = node.getNextNode();
            }
        }
    }
}

