/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.pde;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformURIConverter
extends ExtensibleURIConverterImpl
implements IPluginModelListener {
    private static volatile PlatformURIConverter __platformURIConverter;
    private static Object __lock;

    static {
        __lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlatformURIConverter getInstance() {
        if (__platformURIConverter == null) {
            Object object = __lock;
            synchronized (object) {
                if (__platformURIConverter == null) {
                    __platformURIConverter = new PlatformURIConverter();
                }
            }
        }
        return __platformURIConverter;
    }

    private PlatformURIConverter() {
        PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
        this.loadURIMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelsChanged(PluginModelDelta delta) {
        Object object = __lock;
        synchronized (object) {
            this.loadURIMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI normalize(URI uri) {
        Object object = __lock;
        synchronized (object) {
            return super.normalize(uri);
        }
    }

    protected ExtensibleURIConverterImpl.URIMap getInternalURIMap() {
        if (this.uriMap == null) {
            URIMappingRegistryImpl mappingRegistryImpl = new URIMappingRegistryImpl();
            this.uriMap = (ExtensibleURIConverterImpl.URIMap)mappingRegistryImpl.map();
        }
        return this.uriMap;
    }

    public void dispose() {
        PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
        this.getURIMap().clear();
    }

    private void loadURIMap() {
        this.getURIMap().clear();
        this.getURIMap().putAll(PlatformURIConverter.computePlatformURIMap());
    }

    public static Map<URI, URI> computePlatformURIMap() {
        return PlatformURIConverter.computePlatformPluginToPlatformResourceMap();
    }

    public static Map<URI, URI> computePlatformPluginToPlatformResourceMap() {
        HashMap<URI, URI> pluginToResource = new HashMap<URI, URI>();
        HashMap<URI, URI> resourceToPlugin = new HashMap<URI, URI>();
        IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getActiveModels((boolean)true);
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleId;
            IPluginModelBase base = iPluginModelBaseArray[n2];
            if (base != null && (bundleId = BundleHelper.getBundleId((IPluginModelBase)base)) != null) {
                if (base.getUnderlyingResource() != null) {
                    pluginToResource.put(URI.createPlatformPluginURI((String)(String.valueOf(bundleId) + "/"), (boolean)false), URI.createPlatformResourceURI((String)(String.valueOf(bundleId) + "/"), (boolean)true));
                } else {
                    resourceToPlugin.put(URI.createPlatformResourceURI((String)(String.valueOf(bundleId) + "/"), (boolean)false), URI.createPlatformPluginURI((String)(String.valueOf(bundleId) + "/"), (boolean)false));
                }
            }
            ++n2;
        }
        HashMap<URI, URI> result = new HashMap<URI, URI>(pluginToResource.size() + resourceToPlugin.size());
        result.putAll(pluginToResource);
        result.putAll(resourceToPlugin);
        return result;
    }
}

