/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.java.editor;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.pattern.ui.editors.templateEditor.MethodEditorActivationListener;
import org.eclipse.egf.pattern.ui.java.editor.EclipsePreferencesAdapter;
import org.eclipse.egf.pattern.ui.java.editor.JavaDocumentProvider;
import org.eclipse.egf.pattern.ui.java.editor.JavaTextEditorHelper;
import org.eclipse.egf.pattern.ui.java.editor.JavaTextSourceViewerConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.text.PreferencesAdapter;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class JavaTextEditor
extends TextEditor {
    private RefreshUIJob job;
    private Pattern pattern;
    private ActivationListener fActivationListener;
    public static boolean refreshJob = false;

    public void setFocus() {
        super.setFocus();
    }

    public JavaTextEditor(Pattern pattern) throws CoreException, IOException {
        this.pattern = pattern;
        JavaDocumentProvider provider = new JavaDocumentProvider(this);
        this.setDocumentProvider((IDocumentProvider)provider);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.fActivationListener = new ActivationListener(site.getWorkbenchWindow().getPartService(), this);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        IPreferenceStore store = this.createCombinedPreferenceStore(input);
        this.setPreferenceStore(store);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof JavaSourceViewer) {
            ((JavaSourceViewer)sourceViewer).setPreferenceStore(store);
        }
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        JavaTextSourceViewerConfiguration configure = new JavaTextSourceViewerConfiguration(textTools.getColorManager(), store, this, "___java_partitioning");
        this.setSourceViewerConfiguration((SourceViewerConfiguration)configure);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
    }

    protected void updateStatusField(String category) {
        super.updateStatusField(category);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ISourceViewer viewer = this.getViewer();
        IDocument document = viewer.getDocument();
        document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                if (JavaTextEditor.this.job == null) {
                    JavaTextEditor.this.job = new RefreshUIJob("RefreshTemplateEditor");
                }
                JavaTextEditor.this.job.start();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
    }

    private IPreferenceStore createCombinedPreferenceStore(IEditorInput input) {
        ArrayList<Object> stores = new ArrayList<Object>(3);
        IJavaProject project = EditorUtility.getJavaProject((IEditorInput)input);
        if (project != null) {
            stores.add(new EclipsePreferencesAdapter((IScopeContext)new ProjectScope(project.getProject()), "org.eclipse.jdt.core"));
        }
        stores.add(JavaPlugin.getDefault().getPreferenceStore());
        stores.add(new PreferencesAdapter(JavaCore.getPlugin().getPluginPreferences()));
        stores.add(EditorsUI.getPreferenceStore());
        stores.add(PlatformUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    public final ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public IPreferenceStore getEditorPreferenceStore() {
        return super.getPreferenceStore();
    }

    public void dispose() {
        if (this.fActivationListener != null) {
            this.fActivationListener.dispose();
            this.fActivationListener = null;
        }
        super.dispose();
    }

    class ActivationListener
    extends MethodEditorActivationListener {
        public ActivationListener(IPartService partService, TextEditor editor) {
            super(partService, editor);
        }

        protected void handleActivation() {
            JavaTextEditor.this.safelySanityCheckState(JavaTextEditor.this.getEditorInput());
        }
    }

    class JavaModifyListener
    implements ModifyListener {
        JavaModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (JavaTextEditor.this.job == null) {
                JavaTextEditor.this.job = new RefreshUIJob("RefreshTemplateEditor");
            }
            JavaTextEditor.this.job.start();
        }
    }

    class RefreshUIJob
    extends Job {
        private long timestamp;
        private boolean lazy;

        public RefreshUIJob(String name) {
            super(name);
            this.timestamp = -1L;
            this.lazy = false;
        }

        private void start() {
            if (!this.lazy) {
                this.schedule(1000L);
            } else if (System.currentTimeMillis() - this.timestamp > 999L && !this.lazy) {
                this.lazy = true;
            }
            this.timestamp = System.currentTimeMillis();
        }

        protected IStatus run(IProgressMonitor monitor) {
            refreshJob = true;
            JavaTextEditorHelper.refreshPublicTemplateEditor(JavaTextEditor.this);
            if (this.lazy) {
                this.schedule();
                this.lazy = false;
            }
            return Status.OK_STATUS;
        }
    }
}

